"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_EDITOR_MODE = exports.MLJobEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/ml_job_editor/ml_job_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  expandLiteralStrings
} = _public.XJson;
const ML_EDITOR_MODE = exports.ML_EDITOR_MODE = {
  TEXT: 'text',
  JSON: 'json',
  XJSON: _monaco.XJsonLang.ID
};
const MLJobEditor = ({
  value,
  height = '500px',
  width = '100%',
  mode = ML_EDITOR_MODE.JSON,
  readOnly = false,
  onChange = () => {},
  'data-test-subj': dataTestSubj,
  schema
}) => {
  if (mode === ML_EDITOR_MODE.XJSON) {
    try {
      value = expandLiteralStrings(value);
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: mode,
    options: {
      readOnly
    },
    value: value,
    width: width,
    height: height,
    onChange: onChange,
    "data-test-subj": dataTestSubj,
    editorDidMount: editor => {
      var _editor$getModel;
      const editorModelUri = (_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.uri.toString();
      if (schema) {
        var _monaco$languages$jso;
        _monaco.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
          validate: true,
          enableSchemaRequest: false,
          schemaValidation: 'error',
          schemas: [...((_monaco$languages$jso = _monaco.monaco.languages.json.jsonDefaults.diagnosticsOptions.schemas) !== null && _monaco$languages$jso !== void 0 ? _monaco$languages$jso : []), {
            uri: editorModelUri,
            fileMatch: [editorModelUri],
            schema
          }]
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.MLJobEditor = MLJobEditor;