"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = exports.ANALYTICS_STEPS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_source_context = require("../../../contexts/ml/data_source_context");
var _kibana = require("../../../contexts/kibana");
var _use_create_analytics_form = require("../analytics_management/hooks/use_create_analytics_form");
var _create_analytics_advanced_editor = require("./components/create_analytics_advanced_editor");
var _components = require("./components");
var _page_header = require("../../../components/page_header");
var _page_title = require("../../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let ANALYTICS_STEPS = exports.ANALYTICS_STEPS = /*#__PURE__*/function (ANALYTICS_STEPS) {
  ANALYTICS_STEPS[ANALYTICS_STEPS["CONFIGURATION"] = 0] = "CONFIGURATION";
  ANALYTICS_STEPS[ANALYTICS_STEPS["ADVANCED"] = 1] = "ADVANCED";
  ANALYTICS_STEPS[ANALYTICS_STEPS["DETAILS"] = 2] = "DETAILS";
  ANALYTICS_STEPS[ANALYTICS_STEPS["VALIDATION"] = 3] = "VALIDATION";
  ANALYTICS_STEPS[ANALYTICS_STEPS["CREATE"] = 4] = "CREATE";
  return ANALYTICS_STEPS;
}({});
const Page = ({
  jobId
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(ANALYTICS_STEPS.CONFIGURATION);
  const [activatedSteps, setActivatedSteps] = (0, _react.useState)([true, false, false, false, false]);
  const {
    selectedDataView
  } = (0, _data_source_context.useDataSource)();
  const createAnalyticsForm = (0, _use_create_analytics_form.useCreateAnalyticsForm)();
  const {
    state
  } = createAnalyticsForm;
  const {
    isAdvancedEditorEnabled,
    disableSwitchToForm,
    isJobCreated
  } = state;
  const {
    jobType
  } = state.form;
  const {
    initiateWizard,
    setJobClone,
    switchToAdvancedEditor,
    switchToForm
  } = createAnalyticsForm.actions;
  (0, _react.useEffect)(() => {
    initiateWizard();
    if (selectedDataView) {
      (async function () {
        if (jobId !== undefined) {
          const analyticsConfigs = await mlApi.dataFrameAnalytics.getDataFrameAnalytics(jobId, true);
          if (Array.isArray(analyticsConfigs.data_frame_analytics) && analyticsConfigs.data_frame_analytics.length > 0) {
            const clonedJobConfig = analyticsConfigs.data_frame_analytics[0];
            await setJobClone(clonedJobConfig);
          }
        }
      })();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (activatedSteps[currentStep] === false) {
      activatedSteps.splice(currentStep, 1, true);
      setActivatedSteps(activatedSteps);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentStep]);
  const analyticsWizardSteps = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.configurationStepTitle', {
      defaultMessage: 'Configuration'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.ConfigurationStep, (0, _extends2.default)({}, createAnalyticsForm, {
      isClone: jobId !== undefined,
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.CONFIGURATION],
      sourceDataViewTitle: selectedDataView.getIndexPattern(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    })),
    status: currentStep >= ANALYTICS_STEPS.CONFIGURATION ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.advancedStepTitle', {
      defaultMessage: 'Additional options'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.AdvancedStep, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.ADVANCED],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    })),
    status: currentStep >= ANALYTICS_STEPS.ADVANCED ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.detailsStepTitle', {
      defaultMessage: 'Job details'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.DetailsStep, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.DETAILS],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    })),
    status: currentStep >= ANALYTICS_STEPS.DETAILS ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.validationStepTitle', {
      defaultMessage: 'Validation'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.ValidationStepWrapper, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.VALIDATION],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    })),
    status: currentStep >= ANALYTICS_STEPS.VALIDATION ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.createStepTitle', {
      defaultMessage: 'Create'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.CreateStep, (0, _extends2.default)({}, createAnalyticsForm, {
      step: currentStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 17
      }
    })),
    status: currentStep >= ANALYTICS_STEPS.CREATE ? undefined : 'incomplete'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsCreationContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "mlDataFrameAnalyticsWizardHeaderTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }, jobId === undefined && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.creationPageTitle",
      defaultMessage: "Create job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    }), jobId !== undefined && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.clone.creationPageTitle",
      defaultMessage: "Clone job from {jobId}",
      values: {
        jobId
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.creationPageSourceIndexTitle",
    defaultMessage: "Source data view: {dataViewTitle}",
    values: {
      dataViewTitle: selectedDataView.getIndexPattern()
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: disableSwitchToForm && _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jsonEditorDisabledSwitchText', {
      defaultMessage: 'Configuration contains advanced fields not supported by the form. You cannot switch back to the form.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: jobType === undefined || disableSwitchToForm || isJobCreated,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.switchToJsonEditorSwitch', {
      defaultMessage: 'Switch to json editor'
    }),
    checked: isAdvancedEditorEnabled,
    onChange: e => {
      if (e.target.checked === true) {
        switchToAdvancedEditor();
      } else {
        switchToForm();
      }
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardAdvancedEditorSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }), isAdvancedEditorEnabled === true && /*#__PURE__*/_react.default.createElement(_create_analytics_advanced_editor.CreateAnalyticsAdvancedEditor, (0, _extends2.default)({}, createAnalyticsForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  })), isAdvancedEditorEnabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    "data-test-subj": "mlAnalyticsCreateJobWizardSteps",
    steps: analyticsWizardSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  })));
};
exports.Page = Page;