"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchExplainData = void 0;
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchExplainData = async (mlApi, formState) => {
  const jobConfig = (0, _state.getJobConfigFromFormState)(formState);
  let errorMessage = '';
  let errorReason = '';
  let success = true;
  let expectedMemory = '';
  let fieldSelection = [];
  let noDocsContainMappedFields = false;
  try {
    var _resp$memory_estimati;
    delete jobConfig.dest;
    delete jobConfig.model_memory_limit;
    delete jobConfig.analyzed_fields;
    const resp = await mlApi.dataFrameAnalytics.explainDataFrameAnalytics(jobConfig);
    expectedMemory = (_resp$memory_estimati = resp.memory_estimation) === null || _resp$memory_estimati === void 0 ? void 0 : _resp$memory_estimati.expected_memory_without_disk;
    fieldSelection = resp.field_selection || [];
  } catch (error) {
    const errObj = (0, _mlErrorUtils.extractErrorProperties)(error);
    success = false;
    errorMessage = errObj.message;
    if (errObj.causedBy) {
      errorReason = errObj.causedBy;
    }
  }
  if (errorMessage.includes('status_exception') && errorMessage.includes('Unable to estimate memory usage as no documents')) {
    noDocsContainMappedFields = true;
  }
  return {
    success,
    expectedMemory,
    fieldSelection,
    errorMessage,
    errorReason,
    noDocsContainMappedFields
  };
};
exports.fetchExplainData = fetchExplainData;