"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleEditorFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _detector_description_list = require("./components/detector_description_list");
var _actions_section = require("./actions_section");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _conditions_section = require("./conditions_section");
var _scope_section = require("./scope_section");
var _select_rule_action = require("./select_rule_action");
var _utils = require("./utils");
var _job_utils = require("../../../../common/util/job_utils");
var _job_service = require("../../services/job_service");
var _toast_notification_service = require("../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/rule_editor/rule_editor_flyout.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Flyout component for viewing and editing job detector rules.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class RuleEditorFlyoutUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "showFlyout", (anomaly, focusTrapProps) => {
      var _this$props$selectedJ;
      let ruleIndex = -1;
      const job = (_this$props$selectedJ = this.props.selectedJob) !== null && _this$props$selectedJ !== void 0 ? _this$props$selectedJ : this.mlJobService.getJob(anomaly.jobId);
      if (job === undefined) {
        // No details found for this job, display an error and
        // don't open the Flyout as no edits can be made without the job.
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.unableToConfigureRulesNotificationMesssage', {
          defaultMessage: 'Unable to configure job rules as no job found with ID {jobId}',
          values: {
            jobId: anomaly.jobId
          }
        }));
        this.setState({
          job,
          isFlyoutVisible: false
        });
        return;
      }
      this.partitioningFieldNames = (0, _job_utils.getPartitioningFieldNames)(job, anomaly.detectorIndex);

      // Check if any rules are configured for this detector.
      const detectorIndex = anomaly.detectorIndex;
      const detector = job.analysis_config.detectors[detectorIndex];
      if (detector.custom_rules === undefined) {
        ruleIndex = 0;
      }
      let isConditionsEnabled = false;
      if (ruleIndex === 0) {
        // Configuring the first rule for a detector.
        isConditionsEnabled = this.partitioningFieldNames.length === 0;
      }
      this.setState({
        anomaly,
        job,
        ruleIndex,
        isConditionsEnabled,
        isScopeEnabled: false,
        isFlyoutVisible: true,
        focusTrapProps
      });
      if (this.partitioningFieldNames.length > 0 && this.canGetFilters) {
        // Load the current list of filters. These are used for configuring rule scope.
        this.props.kibana.services.mlServices.mlApi.filters.filters().then(filters => {
          const filterListIds = filters.map(filter => filter.filter_id);
          this.setState({
            filterListIds
          });
        }).catch(error => {
          this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithLoadingFilterListsNotificationMesssage', {
            defaultMessage: 'Error loading the filter lists used in the job rule scope'
          }));
        });
      }
    });
    (0, _defineProperty2.default)(this, "closeFlyout", () => {
      this.setState({
        isFlyoutVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "setEditRuleIndex", ruleIndex => {
      const detectorIndex = this.state.anomaly.detectorIndex;
      const detector = this.state.job.analysis_config.detectors[detectorIndex];
      const rules = detector.custom_rules;
      const rule = rules === undefined || ruleIndex >= rules.length ? (0, _utils.getNewRuleDefaults)() : rules[ruleIndex];
      const isConditionsEnabled = this.partitioningFieldNames.length === 0 || rule.conditions !== undefined && rule.conditions.length > 0;
      const isScopeEnabled = rule.scope !== undefined && Object.keys(rule.scope).length > 0;
      if (isScopeEnabled === true) {
        // Add 'enabled:true' to mark them as selected in the UI.
        Object.keys(rule.scope).forEach(field => {
          rule.scope[field].enabled = true;
        });
      }
      this.setState({
        ruleIndex,
        rule,
        isConditionsEnabled,
        isScopeEnabled
      });
    });
    (0, _defineProperty2.default)(this, "onSkipResultChange", e => {
      const checked = e.target.checked;
      this.setState(prevState => {
        const actions = [...prevState.rule.actions];
        const idx = actions.indexOf(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_RESULT);
        if (idx === -1 && checked) {
          actions.push(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_RESULT);
        } else if (idx > -1 && !checked) {
          actions.splice(idx, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            actions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onSkipModelUpdateChange", e => {
      const checked = e.target.checked;
      this.setState(prevState => {
        const actions = [...prevState.rule.actions];
        const idx = actions.indexOf(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_MODEL_UPDATE);
        if (idx === -1 && checked) {
          actions.push(_mlAnomalyUtils.ML_DETECTOR_RULE_ACTION.SKIP_MODEL_UPDATE);
        } else if (idx > -1 && !checked) {
          actions.splice(idx, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            actions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onConditionsEnabledChange", e => {
      const isConditionsEnabled = e.target.checked;
      this.setState(prevState => {
        let conditions;
        if (isConditionsEnabled === false) {
          // Clear any conditions that have been added.
          conditions = [];
        } else {
          // Add a default new condition.
          conditions = [(0, _utils.getNewConditionDefaults)()];
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          },
          isConditionsEnabled
        };
      });
    });
    (0, _defineProperty2.default)(this, "addCondition", () => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        conditions.push((0, _utils.getNewConditionDefaults)());
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "updateCondition", (index, appliesTo, operator, value) => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        if (index < conditions.length) {
          conditions[index] = {
            applies_to: appliesTo,
            operator,
            value
          };
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "deleteCondition", index => {
      this.setState(prevState => {
        const conditions = [...prevState.rule.conditions];
        if (index < conditions.length) {
          conditions.splice(index, 1);
        }
        return {
          rule: {
            ...prevState.rule,
            conditions
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "onScopeEnabledChange", e => {
      const isScopeEnabled = e.target.checked;
      this.setState(prevState => {
        const rule = {
          ...prevState.rule
        };
        if (isScopeEnabled === false) {
          // Clear scope property.
          delete rule.scope;
        }
        return {
          rule,
          isScopeEnabled
        };
      });
    });
    (0, _defineProperty2.default)(this, "updateScope", (fieldName, filterId, filterType, enabled) => {
      this.setState(prevState => {
        let scope = {
          ...prevState.rule.scope
        };
        if (scope === undefined) {
          scope = {};
        }
        scope[fieldName] = {
          filter_id: filterId,
          filter_type: filterType,
          enabled
        };
        return {
          rule: {
            ...prevState.rule,
            scope
          }
        };
      });
    });
    (0, _defineProperty2.default)(this, "saveEdit", () => {
      const {
        rule,
        ruleIndex
      } = this.state;
      this.updateRuleAtIndex(ruleIndex, rule);
    });
    (0, _defineProperty2.default)(this, "updateRuleAtIndex", (ruleIndex, editedRule) => {
      const mlJobService = this.mlJobService;
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const {
        mlApi
      } = this.props.kibana.services.mlServices;
      const {
        job,
        anomaly
      } = this.state;
      const jobId = job.job_id;
      const detectorIndex = anomaly.detectorIndex;
      (0, _utils.saveJobRule)(mlJobService, job, detectorIndex, ruleIndex, editedRule, mlApi).then(resp => {
        if (resp.success) {
          toasts.add({
            title: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.changesToJobDetectorRulesSavedNotificationMessageTitle', {
              defaultMessage: 'Changes to {jobId} detector rules saved',
              values: {
                jobId
              }
            }),
            color: 'success',
            iconType: 'check',
            text: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.changesToJobDetectorRulesSavedNotificationMessageDescription', {
              defaultMessage: 'Note that changes will take effect for new results only.'
            })
          });
          this.closeFlyout();
        } else {
          toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithSavingChangesToJobDetectorRulesNotificationMessage', {
            defaultMessage: 'Error saving changes to {jobId} detector rules',
            values: {
              jobId
            }
          }));
        }
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithSavingChangesToJobDetectorRulesNotificationMessage', {
          defaultMessage: 'Error saving changes to {jobId} detector rules',
          values: {
            jobId
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "deleteRuleAtIndex", index => {
      const mlJobService = this.mlJobService;
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const {
        mlApi
      } = this.props.kibana.services.mlServices;
      const {
        job,
        anomaly
      } = this.state;
      const jobId = job.job_id;
      const detectorIndex = anomaly.detectorIndex;
      (0, _utils.deleteJobRule)(mlJobService, job, detectorIndex, index, mlApi).then(resp => {
        if (resp.success) {
          toasts.addSuccess(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.ruleDeletedFromJobDetectorNotificationMessage', {
            defaultMessage: 'Rule deleted from {jobId} detector',
            values: {
              jobId
            }
          }));
          const updatedJob = mlJobService.getJob(anomaly.jobId);
          const updatedDetector = updatedJob.analysis_config.detectors[detectorIndex];
          const updatedRules = updatedDetector.custom_rules;
          if (!updatedRules) {
            this.closeFlyout();
          } else {
            this.setState({
              job: {
                ...updatedJob
              }
            });
          }
        } else {
          toasts.addDanger(_i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithDeletingRuleFromJobDetectorNotificationMessage', {
            defaultMessage: 'Error deleting rule from {jobId} detector',
            values: {
              jobId
            }
          }));
        }
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithDeletingRuleFromJobDetectorNotificationMessage', {
          defaultMessage: 'Error deleting rule from {jobId} detector',
          values: {
            jobId
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "addItemToFilterList", (item, filterId, closeFlyoutOnAdd) => {
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const {
        mlApi
      } = this.props.kibana.services.mlServices;
      (0, _utils.addItemToFilter)(item, filterId, mlApi).then(() => {
        if (closeFlyoutOnAdd === true) {
          toasts.add({
            title: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.addedItemToFilterListNotificationMessageTitle', {
              defaultMessage: 'Added {item} to {filterId}',
              values: {
                item,
                filterId
              }
            }),
            color: 'success',
            iconType: 'check',
            text: _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.addedItemToFilterListNotificationMessageDescription', {
              defaultMessage: 'Note that changes will take effect for new results only.'
            })
          });
          this.closeFlyout();
        }
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.errorWithAddingItemToFilterListNotificationMessage', {
          defaultMessage: 'An error occurred adding {item} to filter {filterId}',
          values: {
            item,
            filterId
          }
        }));
      });
    });
    this.state = {
      anomaly: {},
      job: {},
      ruleIndex: -1,
      rule: (0, _utils.getNewRuleDefaults)(),
      skipModelUpdate: false,
      isConditionsEnabled: false,
      isScopeEnabled: false,
      filterListIds: [],
      isFlyoutVisible: false,
      focusTrapProps: {}
    };
    this.partitioningFieldNames = [];
    this.canGetFilters = (0, _check_capabilities.checkPermission)('canGetFilters');
    this.mlJobService = (0, _job_service.mlJobServiceFactory)(props.kibana.services.mlServices.mlApi);
  }
  componentDidMount() {
    if (this.props.kibana.services.notifications) {
      this.toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(this.props.kibana.services.notifications.toasts);
      if (typeof this.props.setShowFunction === 'function') {
        this.props.setShowFunction(this.showFlyout);
      }
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetShowFunction === 'function') {
      this.props.unsetShowFunction();
    }
  }
  render() {
    var _this$props$kibana$se;
    const docsUrl = (_this$props$kibana$se = this.props.kibana.services.docLinks) === null || _this$props$kibana$se === void 0 ? void 0 : _this$props$kibana$se.links.ml.customRules;
    const {
      isFlyoutVisible,
      job,
      anomaly,
      ruleIndex,
      rule,
      filterListIds,
      isConditionsEnabled,
      isScopeEnabled,
      focusTrapProps
    } = this.state;
    if (isFlyoutVisible === false) {
      return null;
    }
    let flyout;
    if (ruleIndex === -1) {
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: this.closeFlyout,
        "aria-labelledby": "flyoutTitle",
        focusTrapProps: focusTrapProps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 515,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        hasBorder: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 520,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 521,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        id: "flyoutTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 522,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.editRulesTitle",
        defaultMessage: "Edit job rules",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 523,
          columnNumber: 17
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 531,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_select_rule_action.SelectRuleAction, {
        job: job,
        anomaly: anomaly,
        setEditRuleIndex: this.setEditRuleIndex,
        updateRuleAtIndex: this.updateRuleAtIndex,
        deleteRuleAtIndex: this.deleteRuleAtIndex,
        addItemToFilterList: this.addItemToFilterList,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 532,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 542,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 543,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 544,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: this.closeFlyout,
        flush: "left",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 545,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.closeButtonLabel",
        defaultMessage: "Close",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 546,
          columnNumber: 19
        }
      }))))));
    } else {
      const detectorIndex = anomaly.detectorIndex;
      const detector = job.analysis_config.detectors[detectorIndex];
      const rules = detector.custom_rules;
      const isCreate = rules === undefined || ruleIndex >= rules.length;
      const hasPartitioningFields = this.partitioningFieldNames && this.partitioningFieldNames.length > 0;
      const conditionSupported = _mlAnomalyUtils.ML_DETECTOR_RULE_CONDITIONS_NOT_SUPPORTED_FUNCTIONS.indexOf(anomaly.source.function) === -1;
      const conditionsText = _i18n.i18n.translate('xpack.ml.ruleEditor.ruleEditorFlyout.conditionsDescription', {
        defaultMessage: 'Add numeric conditions for when the job rule applies. Multiple conditions are combined using AND.'
      });
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        "data-test-subj": "mlRuleEditorFlyout",
        onClose: this.closeFlyout,
        "aria-labelledby": "flyoutTitle",
        focusTrapProps: focusTrapProps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 575,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        hasBorder: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 581,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 582,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        id: "flyoutTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 583,
          columnNumber: 15
        }
      }, isCreate === true ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.createRuleTitle",
        defaultMessage: "Create job rule",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 585,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.editRuleTitle",
        defaultMessage: "Edit job rule",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 590,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 599,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_detector_description_list.DetectorDescriptionList, {
        job: job,
        detector: detector,
        anomaly: anomaly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 600,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 601,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 602,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 603,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.rulesDescription",
        defaultMessage: "Job rules instruct anomaly detectors to change their behavior based on domain-specific knowledge that you provide. When you create a job rule, you can specify conditions, scope, and actions. When the conditions of a job rule are satisfied, its actions are triggered. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docsUrl,
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 612,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.ruleEditor.ruleEditorFlyout.rulesDescription.learnMoreLinkText",
            defaultMessage: "Learn more",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 613,
              columnNumber: 25
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 604,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 624,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 626,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 627,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.actionTitle",
        defaultMessage: "Action",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 628,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_actions_section.ActionsSection, {
        actions: rule.actions,
        onSkipResultChange: this.onSkipResultChange,
        onSkipModelUpdateChange: this.onSkipModelUpdateChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 634,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 640,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 642,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 643,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.conditionsTitle",
        defaultMessage: "Conditions",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 644,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 650,
          columnNumber: 13
        }
      }), conditionSupported === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        id: "enable_conditions_checkbox",
        label: conditionsText,
        checked: isConditionsEnabled,
        onChange: this.onConditionsEnabledChange,
        disabled: !conditionSupported || !hasPartitioningFields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 652,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.ruleEditorFlyout.conditionsNotSupportedTitle",
          defaultMessage: "Conditions are not supported for detectors using the {functionName} function",
          values: {
            functionName: anomaly.source.function
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 662,
            columnNumber: 19
          }
        }),
        iconType: "info",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 660,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 671,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_conditions_section.ConditionsSection, {
        isEnabled: isConditionsEnabled,
        conditions: rule.conditions,
        addCondition: this.addCondition,
        updateCondition: this.updateCondition,
        deleteCondition: this.deleteCondition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 672,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 680,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_scope_section.ScopeSection, {
        isEnabled: isScopeEnabled,
        onEnabledChange: this.onScopeEnabledChange,
        partitioningFieldNames: this.partitioningFieldNames,
        filterListIds: filterListIds,
        scope: rule.scope,
        updateScope: this.updateScope,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 682,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.ruleEditorFlyout.rerunJobTitle",
          defaultMessage: "Rerun job",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 693,
            columnNumber: 17
          }
        }),
        color: "warning",
        iconType: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 691,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 701,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.whenChangesTakeEffectDescription",
        defaultMessage: "Changes to job rules take effect for new results only.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 702,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 707,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.howToApplyChangesToExistingResultsDescription",
        defaultMessage: "To apply these changes to existing results you must clone and rerun the job. Note rerunning the job may take some time and should only be done once you have completed all your changes to the rules for this job.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 708,
          columnNumber: 17
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 718,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 719,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 720,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: this.closeFlyout,
        flush: "left",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 721,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.closeButtonLabel",
        defaultMessage: "Close",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 722,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 728,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.saveEdit,
        isDisabled: !(0, _utils.isValidRule)(rule),
        fill: true,
        "data-test-subj": "mlRuleEditorSaveButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 729,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleEditorFlyout.saveButtonLabel",
        defaultMessage: "Save",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 735,
          columnNumber: 19
        }
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 747,
        columnNumber: 12
      }
    }, flyout);
  }
}
(0, _defineProperty2.default)(RuleEditorFlyoutUI, "propTypes", {
  setShowFunction: _propTypes.default.func.isRequired,
  unsetShowFunction: _propTypes.default.func.isRequired,
  selectedJob: _propTypes.default.object
});
const RuleEditorFlyout = exports.RuleEditorFlyout = (0, _public.withKibana)(RuleEditorFlyoutUI);