"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _anomaly_description = require("../../../../common/util/anomaly_description");
var _anomalies_table_constants = require("./anomalies_table_constants");
var _anomaly_details_utils = require("./anomaly_details_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/anomaly_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for displaying details of an anomaly in the expanded row section
 * of the anomalies table.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetails = ({
  anomaly,
  examples,
  definition,
  categoryDefinitionError,
  isAggregatedData,
  filter,
  influencersLimit,
  influencerFilter,
  tabIndex,
  job
}) => {
  if (examples !== undefined && examples.length > 0) {
    const tabs = [{
      id: 'Details',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.detailsTitle', {
        defaultMessage: 'Details'
      }),
      content: /*#__PURE__*/_react.default.createElement(Contents, {
        anomaly: anomaly,
        filter: filter,
        influencerFilter: influencerFilter,
        influencersLimit: influencersLimit,
        isAggregatedData: isAggregatedData,
        job: job,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 11
        }
      })
    }, {
      id: 'category-examples',
      name: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.categoryExamplesTitle', {
        defaultMessage: 'Category examples'
      }),
      content: /*#__PURE__*/_react.default.createElement(CategoryExamples, {
        examples: examples,
        definition: definition,
        error: categoryDefinitionError,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 11
        }
      })
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
      tabs: tabs,
      size: "s",
      initialSelectedTab: tabs[tabIndex],
      onTabClick: () => {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(Contents, {
    anomaly: anomaly,
    filter: filter,
    influencerFilter: influencerFilter,
    influencersLimit: influencersLimit,
    isAggregatedData: isAggregatedData,
    job: job,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
};
exports.AnomalyDetails = AnomalyDetails;
const Contents = ({
  anomaly,
  isAggregatedData,
  filter,
  influencersLimit,
  influencerFilter,
  job
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dividerStyle = (0, _react.useMemo)(() => {
    return (0, _mlIsPopulatedObject.isPopulatedObject)(anomaly.source.anomaly_score_explanation) ? {
      borderRight: `1px solid ${euiTheme.colors.lightShade}`
    } : {};
  }, [euiTheme.colors, anomaly]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      padding: euiTheme.size.m
    },
    "data-test-subj": "mlAnomaliesListRowDetails",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(Description, {
    anomaly: anomaly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: dividerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Details, {
    anomaly: anomaly,
    isAggregatedData: isAggregatedData,
    filter: filter,
    job: job,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(Influencers, {
    anomaly: anomaly,
    influencerFilter: influencerFilter,
    influencersLimit: influencersLimit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_details_utils.AnomalyExplanationDetails, {
    anomaly: anomaly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }))))));
};
const Description = ({
  anomaly
}) => {
  const {
    anomalyDescription,
    mvDescription
  } = (0, _anomaly_description.getAnomalyDescription)(anomaly);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.descriptionTitle",
    defaultMessage: "Description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  })), anomalyDescription), mvDescription !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 39
    }
  }, mvDescription));
};
const Details = ({
  anomaly,
  isAggregatedData,
  filter,
  job
}) => {
  var _anomaly$source$is_in, _anomaly$source;
  const isInterimResult = (_anomaly$source$is_in = (_anomaly$source = anomaly.source) === null || _anomaly$source === void 0 ? void 0 : _anomaly$source.is_interim) !== null && _anomaly$source$is_in !== void 0 ? _anomaly$source$is_in : false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, isAggregatedData === true ? /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.detailsOnHighestSeverityAnomalyTitle",
    defaultMessage: "Details on highest severity anomaly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyDetailsTitle",
    defaultMessage: "Anomaly details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  })), isInterimResult === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: {
      fontStyle: 'italic'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.interimResultLabel",
    defaultMessage: "Interim result",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_anomaly_details_utils.DetailsItems, {
    anomaly: anomaly,
    filter: filter,
    modelPlotEnabled: job.modelPlotEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }));
};
const Influencers = ({
  anomaly,
  influencersLimit,
  influencerFilter
}) => {
  const [showAllInfluencers, setShowAllInfluencers] = (0, _react.useState)(false);
  const toggleAllInfluencers = setShowAllInfluencers.bind(null, prev => !prev);
  const anomalyInfluencers = anomaly.influencers;
  let listItems = [];
  let othersCount = 0;
  let numToDisplay = 0;
  if (anomalyInfluencers !== undefined && influencerFilter !== undefined) {
    numToDisplay = showAllInfluencers === true ? anomalyInfluencers.length : Math.min(influencersLimit, anomalyInfluencers.length);
    othersCount = Math.max(anomalyInfluencers.length - numToDisplay, 0);
    if (othersCount === 1) {
      // Display the 1 extra influencer as displaying "and 1 more" would also take up a line.
      numToDisplay++;
      othersCount = 0;
    }
    listItems = (0, _anomaly_details_utils.getInfluencersItems)(anomalyInfluencers, influencerFilter, numToDisplay);
  }
  if (listItems.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.anomalyDetails.influencersTitle",
      defaultMessage: "Influencers",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 13
      }
    }))), listItems.map(({
      title,
      description
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: '180px'
      },
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 15
      }
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 15
      }
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 13
      }
    }))), othersCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => toggleAllInfluencers(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyDescriptionListMoreLinkText",
      defaultMessage: "and {othersCount} more",
      values: {
        othersCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 13
      }
    })), numToDisplay > influencersLimit + 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => toggleAllInfluencers(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyDescriptionShowLessLinkText",
      defaultMessage: "Show less",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 13
      }
    })));
  }
  return null;
};
const CategoryExamples = ({
  definition,
  examples,
  error
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    gutterSize: "xs",
    css: {
      padding: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 5
    }
  }, error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.categoryDefinitionErrorTitle', {
      defaultMessage: 'An error occurred loading category definition:'
    }),
    "data-test-subj": "mlAnomaliesTableCategoryDefinitionError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 13
    }
  }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 11
    }
  })), definition !== undefined && definition.terms && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `example-terms`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    css: {
      display: 'inline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.termsTitle', {
    defaultMessage: 'Terms'
  })), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.termsDescriptionAriaLabel', {
      defaultMessage: 'Description'
    }),
    type: "question",
    color: "subdued",
    size: "s",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.anomalyDetails.termsDescriptionTooltip",
      defaultMessage: "A space separated list of the common tokens that are matched in values of the category (may have been truncated to a max character limit of {maxChars})",
      values: {
        maxChars: _anomalies_table_constants.MAX_CHARS
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 13
    }
  }, definition.terms)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  })), definition !== undefined && definition.regex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `example-regex`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 394,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    css: {
      display: 'inline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.regexTitle', {
    defaultMessage: 'Regex'
  })), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.regexDescriptionAriaLabel', {
      defaultMessage: 'Description'
    }),
    type: "question",
    color: "subdued",
    size: "s",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.anomalyDetails.regexDescriptionTooltip",
      defaultMessage: "The regular expression that is used to search for values that match the category (may have been truncated to a max character limit of {maxChars})",
      values: {
        maxChars: _anomalies_table_constants.MAX_CHARS
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 417,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 13
    }
  }, definition.regex)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 11
    }
  })), examples.map((example, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `example${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 11
      }
    }, i === 0 && definition !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 437,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.examplesTitle', {
      defaultMessage: 'Examples'
    }))), /*#__PURE__*/_react.default.createElement("span", {
      css: {
        fontFamily: euiTheme.font.familyCode
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 13
      }
    }, example));
  }));
};