"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _recently_accessed = require("../../../util/recently_accessed");
var _job_service = require("../../../services/job_service");
var _table_service = require("../../../services/table_service");
var _search = require("../../../../../common/constants/search");
var _job_utils = require("../../../../../common/util/job_utils");
var _annotations_service = require("../../../services/annotations_service");
var _annotations = require("../../../../../common/constants/annotations");
var _locator = require("../../../../../common/constants/locator");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
var _datafeed_chart_flyout = require("../../../jobs/jobs_list/components/datafeed_chart_flyout");
var _revert_model_snapshot_flyout = require("../../model_snapshots/revert_model_snapshot_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/annotations/annotations_table/annotations_table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Table for displaying annotations. This is mostly a copy of the forecasts table.
 * This version supports both fetching the annotations by itself (used in the jobs list) and
 * getting the annotations via props (used in Anomaly Explorer and Single Series Viewer).
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const editAnnotationsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.annotationsTable.editAnnotationsTooltip",
  defaultMessage: "Edit annotation",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 3
  }
});
const viewDataFeedText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.annotationsTable.datafeedChartTooltip",
  defaultMessage: "View datafeed counts",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 3
  }
});
const CURRENT_SERIES = 'current_series';
/**
 * Table component for rendering the lists of annotations for an ML job.
 */
class AnnotationsTableUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getAnnotationsWithExtraInfo", (0, _memoizeOne.default)(annotations => {
      var _this$props$chartDeta, _this$props$chartDeta2;
      // if there is a specific view/chart entities that the annotations can be scoped to
      // add a new column called 'current_series'
      if (Array.isArray((_this$props$chartDeta = this.props.chartDetails) === null || _this$props$chartDeta === void 0 ? void 0 : (_this$props$chartDeta2 = _this$props$chartDeta.entityData) === null || _this$props$chartDeta2 === void 0 ? void 0 : _this$props$chartDeta2.entities)) {
        return annotations.map(annotation => {
          var _this$props$chartDeta3, _this$props$chartDeta4;
          const allMatched = (_this$props$chartDeta3 = this.props.chartDetails) === null || _this$props$chartDeta3 === void 0 ? void 0 : (_this$props$chartDeta4 = _this$props$chartDeta3.entityData) === null || _this$props$chartDeta4 === void 0 ? void 0 : _this$props$chartDeta4.entities.every(({
            fieldType,
            fieldValue
          }) => {
            const field = `${fieldType}_value`;
            return !(!annotation[field] || annotation[field] !== fieldValue);
          });
          return {
            ...annotation,
            [CURRENT_SERIES]: allMatched
          };
        });
      } else {
        // if not make it return the original annotations
        return annotations;
      }
    }));
    (0, _defineProperty2.default)(this, "annotationsRefreshSubscription", null);
    (0, _defineProperty2.default)(this, "previousJobId", undefined);
    (0, _defineProperty2.default)(this, "openSingleMetricView", async (annotation = {}) => {
      const {
        services: {
          chrome: {
            recentlyAccessed
          },
          application: {
            navigateToUrl
          },
          share
        }
      } = this.props.kibana;

      // Creates the link to the Single Metric Viewer.
      // Set the total time range from the start to the end of the annotation.
      const job = this.getJob(annotation.job_id);
      const dataCounts = job.data_counts;
      const resultLatest = (0, _job_utils.getLatestDataOrBucketTimestamp)(dataCounts.latest_record_timestamp, dataCounts.latest_bucket_timestamp);
      const from = new Date(dataCounts.earliest_record_timestamp).toISOString();
      const to = new Date(resultLatest).toISOString();
      const timeRange = {
        from,
        to,
        mode: 'absolute'
      };
      let mlTimeSeriesExplorer = {};
      const entityCondition = {};
      if (annotation.timestamp !== undefined && annotation.end_timestamp !== undefined) {
        mlTimeSeriesExplorer = {
          zoom: {
            from: new Date(annotation.timestamp).toISOString(),
            to: new Date(annotation.end_timestamp).toISOString()
          }
        };
        if (annotation.timestamp < dataCounts.earliest_record_timestamp) {
          timeRange.from = new Date(annotation.timestamp).toISOString();
        }
        if (annotation.end_timestamp > dataCounts.latest_record_timestamp) {
          timeRange.to = new Date(annotation.end_timestamp).toISOString();
        }
      }

      // if the annotation is at the series level
      // then pass the partitioning field(s) and detector index to the Single Metric Viewer
      if (annotation.detector_index !== undefined) {
        mlTimeSeriesExplorer.detectorIndex = annotation.detector_index;
      }
      if (annotation.partition_field_value !== undefined) {
        entityCondition[annotation.partition_field_name] = annotation.partition_field_value;
      }
      if (annotation.over_field_value !== undefined) {
        entityCondition[annotation.over_field_name] = annotation.over_field_value;
      }
      if (annotation.by_field_value !== undefined) {
        // Note that analyses with by and over fields, will have a top-level by_field_name,
        // but the by_field_value(s) will be in the nested causes array.
        entityCondition[annotation.by_field_name] = annotation.by_field_value;
      }
      mlTimeSeriesExplorer.entities = entityCondition;
      const mlLocator = share.url.locators.get(_locator.ML_APP_LOCATOR);
      const singleMetricViewerLink = await mlLocator.getUrl({
        page: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
        pageState: {
          timeRange,
          refreshInterval: {
            display: 'Off',
            pause: true,
            value: 0
          },
          jobIds: [job.job_id],
          query: {
            query_string: {
              analyze_wildcard: true,
              query: '*'
            }
          },
          ...mlTimeSeriesExplorer
        }
      }, {
        absolute: true
      });
      (0, _recently_accessed.addItemToRecentlyAccessed)('timeseriesexplorer', job.job_id, singleMetricViewerLink, recentlyAccessed);
      await navigateToUrl(singleMetricViewerLink);
    });
    (0, _defineProperty2.default)(this, "onMouseOverRow", record => {
      if (this.mouseOverRecord !== undefined) {
        if (this.mouseOverRecord.rowId !== record.rowId) {
          // Mouse is over a different row, fire mouseleave on the previous record.
          _table_service.mlTableService.rowMouseleave$.next({
            record: this.mouseOverRecord,
            type: 'annotation'
          });

          // fire mouseenter on the new record.
          _table_service.mlTableService.rowMouseenter$.next({
            record,
            type: 'annotation'
          });
        }
      } else {
        // Mouse is now over a row, fire mouseenter on the record.
        _table_service.mlTableService.rowMouseenter$.next({
          record,
          type: 'annotation'
        });
      }
      this.mouseOverRecord = record;
    });
    (0, _defineProperty2.default)(this, "onMouseLeaveRow", () => {
      if (this.mouseOverRecord !== undefined) {
        _table_service.mlTableService.rowMouseleave$.next({
          record: this.mouseOverRecord,
          type: 'annotation'
        });
        this.mouseOverRecord = undefined;
      }
    });
    this.state = {
      annotations: [],
      isLoading: false,
      queryText: `event:(${_annotations.ANNOTATION_EVENT_USER} or ${_annotations.ANNOTATION_EVENT_DELAYED_DATA})`,
      searchError: undefined,
      jobId: Array.isArray(props.jobs) && props.jobs.length > 0 && props.jobs[0] !== undefined ? props.jobs[0].job_id : undefined,
      datafeedFlyoutVisible: false,
      modelSnapshot: null,
      revertSnapshotFlyoutVisible: false,
      datafeedEnd: null
    };
    this.sorting = {
      sort: {
        field: 'timestamp',
        direction: 'asc'
      }
    };
    this.mlJobService = (0, _job_service.mlJobServiceFactory)(props.kibana.services.mlServices.mlApi);
  }
  getAnnotations() {
    const job = this.props.jobs[0];
    const dataCounts = job.data_counts;
    this.setState({
      isLoading: true
    });
    const mlApi = this.props.kibana.services.mlServices.mlApi;
    if (dataCounts.processed_record_count > 0) {
      // Load annotations for the selected job.
      mlApi.annotations.getAnnotations$({
        jobIds: [job.job_id],
        earliestMs: null,
        latestMs: null,
        maxAnnotations: _search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE
      }).toPromise().then(resp => {
        this.setState((prevState, props) => ({
          annotations: resp.annotations[props.jobs[0].job_id] || [],
          errorMessage: undefined,
          isLoading: false,
          jobId: props.jobs[0].job_id
        }));
      }).catch(resp => {
        console.log('Error loading list of annotations for jobs list:', resp);
        this.setState({
          annotations: [],
          errorMessage: 'Error loading the list of annotations for this job',
          isLoading: false,
          jobId: undefined
        });
      });
    } else {
      this.setState({
        annotations: [],
        isLoading: false,
        jobId: undefined
      });
    }
  }
  getJob(jobId) {
    // check if the job was supplied via props and matches the supplied jobId
    if (Array.isArray(this.props.jobs) && this.props.jobs.length > 0) {
      const job = this.props.jobs[0];
      if (jobId === undefined || job.job_id === jobId) {
        return job;
      }
    }
    return this.mlJobService.getJob(jobId);
  }
  componentDidMount() {
    if (this.props.annotations === undefined && Array.isArray(this.props.jobs) && this.props.jobs.length > 0) {
      this.annotationsRefreshSubscription = _annotations_service.annotationsRefresh$.subscribe(() => {
        this.getAnnotations();
      });
      (0, _annotations_service.annotationsRefreshed)();
    }
  }
  componentDidUpdate() {
    if (Array.isArray(this.props.jobs) && this.props.jobs.length > 0 && this.previousJobId !== this.props.jobs[0].job_id && this.props.annotations === undefined && this.state.isLoading === false && this.state.jobId !== this.props.jobs[0].job_id) {
      (0, _annotations_service.annotationsRefreshed)();
      this.previousJobId = this.props.jobs[0].job_id;
    }
  }
  componentWillUnmount() {
    if (this.annotationsRefreshSubscription !== null) {
      this.annotationsRefreshSubscription.unsubscribe();
    }
  }
  render() {
    var _this$props$jobs$, _this$props$chartDeta5, _this$props$chartDeta6, _this$props$refreshJo;
    const {
      isSingleMetricViewerLinkVisible = true,
      isNumberBadgeVisible = false,
      annotationUpdatesService
    } = this.props;
    const {
      queryText,
      searchError
    } = this.state;
    if (this.props.annotations === undefined) {
      if (this.state.isLoading === true) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "spaceAround",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 352,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "l",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 354,
            columnNumber: 15
          }
        })));
      }
      if (this.state.errorMessage !== undefined) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: this.state.errorMessage,
          color: "danger",
          iconType: "cross",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 361,
            columnNumber: 16
          }
        });
      }
    }
    const annotations = this.props.annotations || this.state.annotations;
    if (annotations.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.annotationsTable.annotationsNotCreatedTitle",
          defaultMessage: "No annotations created for this job",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 371,
            columnNumber: 13
          }
        }),
        iconType: "info",
        role: "alert",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 369,
          columnNumber: 9
        }
      }, this.state.jobId && (0, _job_utils.isTimeSeriesViewJob)(this.getJob(this.state.jobId)) && /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 380,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.annotationsTable.howToCreateAnnotationDescription",
        defaultMessage: "To create an annotation, open the {linkToSingleMetricView}",
        values: {
          linkToSingleMetricView: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: () => this.openSingleMetricView(),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 386,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.annotationsTable.howToCreateAnnotationDescription.singleMetricViewerLinkText",
            defaultMessage: "Single Metric Viewer",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 387,
              columnNumber: 23
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 381,
          columnNumber: 15
        }
      })));
    }
    const columns = [{
      field: 'annotation',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.annotationColumnName', {
        defaultMessage: 'Annotation'
      }),
      sortable: true,
      width: '40%',
      scope: 'row',
      'data-test-subj': `mlAnnotationsColumnAnnotation`
    }, {
      field: 'timestamp',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.fromColumnName', {
        defaultMessage: 'From'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      sortable: true,
      'data-test-subj': `mlAnnotationsColumnFrom`
    }, {
      field: 'end_timestamp',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.toColumnName', {
        defaultMessage: 'To'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      sortable: true,
      'data-test-subj': `mlAnnotationsColumnTo`
    }, {
      field: 'modified_time',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.lastModifiedDateColumnName', {
        defaultMessage: 'Last modified date'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      sortable: true,
      'data-test-subj': `mlAnnotationsColumnModifiedDate`
    }, {
      field: 'modified_username',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.lastModifiedByColumnName', {
        defaultMessage: 'Last modified by'
      }),
      sortable: true,
      'data-test-subj': `mlAnnotationsColumnModifiedBy`
    }, {
      field: 'event',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.eventColumnName', {
        defaultMessage: 'Event'
      }),
      sortable: true,
      width: '10%',
      'data-test-subj': `mlAnnotationsColumnEvent`
    }];
    const jobIds = (0, _lodash.uniq)(annotations.map(a => a.job_id));
    if (jobIds.length > 1) {
      columns.unshift({
        field: 'job_id',
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.jobIdColumnName', {
          defaultMessage: 'job ID'
        }),
        sortable: true,
        'data-test-subj': `mlAnnotationsColumnJobId`
      });
    }
    if (isNumberBadgeVisible) {
      columns.unshift({
        field: 'key',
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.labelColumnName', {
          defaultMessage: 'Label'
        }),
        sortable: key => +key,
        width: '60px',
        render: key => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "default",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 482,
              columnNumber: 18
            }
          }, key);
        },
        'data-test-subj': `mlAnnotationsColumnLabel`
      });
    }
    const actions = [];
    if (this.props.jobs === undefined || ((_this$props$jobs$ = this.props.jobs[0]) === null || _this$props$jobs$ === void 0 ? void 0 : _this$props$jobs$.blocked) === undefined) {
      actions.push({
        name: editAnnotationsText,
        description: editAnnotationsText,
        icon: 'pencil',
        type: 'icon',
        onClick: annotation => {
          const annotationId = annotation._id;
          const originalAnnotation = annotations.find(d => d._id === annotationId);
          annotationUpdatesService.setValue(originalAnnotation !== null && originalAnnotation !== void 0 ? originalAnnotation : annotation);
        },
        'data-test-subj': `mlAnnotationsActionEdit`
      });
      if (this.state.jobId && this.props.jobs[0].analysis_config.bucket_span) {
        // add datafeed modal action
        actions.push({
          name: viewDataFeedText,
          description: viewDataFeedText,
          icon: 'visAreaStacked',
          type: 'icon',
          onClick: annotation => {
            this.setState({
              datafeedFlyoutVisible: true,
              datafeedEnd: annotation.end_timestamp
            });
          },
          'data-test-subj': `mlAnnotationsActionViewDatafeed`
        });
      }
      if (isSingleMetricViewerLinkVisible) {
        actions.push({
          name: annotation => {
            const isDrillDownAvailable = (0, _job_utils.isTimeSeriesViewJob)(this.getJob(annotation.job_id));
            if (isDrillDownAvailable) {
              return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.annotationsTable.openInSingleMetricViewerTooltip",
                defaultMessage: "Open in Single Metric Viewer",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 528,
                  columnNumber: 17
                }
              });
            }
            return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.annotationsTable.jobConfigurationNotSupportedInSingleMetricViewerTooltip",
                defaultMessage: "Job configuration not supported in Single Metric Viewer",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 537,
                  columnNumber: 19
                }
              }),
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 535,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.ml.annotationsTable.openInSingleMetricViewerTooltip",
              defaultMessage: "Open in Single Metric Viewer",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 543,
                columnNumber: 17
              }
            }));
          },
          description: annotation => {
            const isDrillDownAvailable = (0, _job_utils.isTimeSeriesViewJob)(this.getJob(annotation.job_id));
            return isDrillDownAvailable ? _i18n.i18n.translate('xpack.ml.annotationsTable.openInSingleMetricViewerAriaLabel', {
              defaultMessage: 'Open in Single Metric Viewer'
            }) : _i18n.i18n.translate('xpack.ml.annotationsTable.jobConfigurationNotSupportedInSingleMetricViewerAriaLabel', {
              defaultMessage: 'Job configuration not supported in Single Metric Viewer'
            });
          },
          enabled: annotation => (0, _job_utils.isTimeSeriesViewJob)(this.getJob(annotation.job_id)),
          icon: 'singleMetricViewer',
          type: 'icon',
          onClick: annotation => this.openSingleMetricView(annotation),
          'data-test-subj': `mlAnnotationsActionOpenInSingleMetricViewer`
        });
      }
    }
    const getRowProps = item => {
      return {
        'data-test-subj': `mlAnnotationsTableRow row-${item._id}`,
        onMouseOver: () => this.onMouseOverRow(item),
        onMouseLeave: () => this.onMouseLeaveRow()
      };
    };

    // Build the options to show in the Event type filter.
    // Do not try and run a search using a terms agg on the event field
    // because in 7.9 this field was incorrectly mapped as a text rather than keyword.

    // Always display options for user and delayed data types.
    const countsByEvent = {
      [_annotations.ANNOTATION_EVENT_USER]: 0,
      [_annotations.ANNOTATION_EVENT_DELAYED_DATA]: 0
    };
    annotations.forEach(annotation => {
      var _annotation$event;
      // Default to user type for annotations created in early releases which didn't have an event field
      const event = (_annotation$event = annotation.event) !== null && _annotation$event !== void 0 ? _annotation$event : _annotations.ANNOTATION_EVENT_USER;
      if (countsByEvent[event] === undefined) {
        countsByEvent[event] = 0;
      }
      countsByEvent[event]++;
    });
    const filters = [{
      type: 'field_value_selection',
      field: 'event',
      name: 'Event',
      multiSelect: 'or',
      options: Object.entries(countsByEvent).map(([key, docCount]) => ({
        value: key,
        name: key,
        view: `${key} (${docCount})`
      })),
      'data-test-subj': 'mlAnnotationTableEventFilter'
    }];
    if (this.props.detectors) {
      columns.push({
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.detectorColumnName', {
          defaultMessage: 'Detector'
        }),
        width: '10%',
        render: item => {
          if ('detector_index' in item) {
            return this.props.detectors[item.detector_index].detector_description;
          }
          return '';
        }
      });
    }
    if (Array.isArray((_this$props$chartDeta5 = this.props.chartDetails) === null || _this$props$chartDeta5 === void 0 ? void 0 : (_this$props$chartDeta6 = _this$props$chartDeta5.entityData) === null || _this$props$chartDeta6 === void 0 ? void 0 : _this$props$chartDeta6.entities)) {
      var _this$props$chartDeta7, _this$props$chartDeta8;
      // only show the column if the field exists in that job in SMV
      (_this$props$chartDeta7 = this.props.chartDetails) === null || _this$props$chartDeta7 === void 0 ? void 0 : (_this$props$chartDeta8 = _this$props$chartDeta7.entityData) === null || _this$props$chartDeta8 === void 0 ? void 0 : _this$props$chartDeta8.entities.forEach(entity => {
        if (entity.fieldType === 'partition_field') {
          columns.push({
            field: 'partition_field_value',
            name: _i18n.i18n.translate('xpack.ml.annotationsTable.partitionSMVColumnName', {
              defaultMessage: 'Partition'
            }),
            sortable: true
          });
        }
        if (entity.fieldType === 'over_field') {
          columns.push({
            field: 'over_field_value',
            name: _i18n.i18n.translate('xpack.ml.annotationsTable.overColumnSMVName', {
              defaultMessage: 'Over'
            }),
            sortable: true
          });
        }
        if (entity.fieldType === 'by_field') {
          columns.push({
            field: 'by_field_value',
            name: _i18n.i18n.translate('xpack.ml.annotationsTable.byColumnSMVName', {
              defaultMessage: 'By'
            }),
            sortable: true
          });
        }
      });
      filters.push({
        type: 'is',
        field: CURRENT_SERIES,
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.seriesOnlyFilterName', {
          defaultMessage: 'Filter to series'
        })
      });
    } else {
      // else show all the partition columns in AE because there might be multiple jobs
      columns.push({
        field: 'partition_field_value',
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.partitionAEColumnName', {
          defaultMessage: 'Partition'
        }),
        sortable: true
      });
      columns.push({
        field: 'over_field_value',
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.overAEColumnName', {
          defaultMessage: 'Over'
        }),
        sortable: true
      });
      columns.push({
        field: 'by_field_value',
        name: _i18n.i18n.translate('xpack.ml.annotationsTable.byAEColumnName', {
          defaultMessage: 'By'
        }),
        sortable: true
      });
    }
    const search = {
      defaultQuery: queryText,
      box: {
        incremental: true,
        schema: true
      },
      filters: filters
    };
    columns.push({
      align: _eui.RIGHT_ALIGNMENT,
      width: '65px',
      name: _i18n.i18n.translate('xpack.ml.annotationsTable.actionsColumnName', {
        defaultMessage: 'Actions'
      }),
      actions,
      'data-test-subj': `mlAnnotationsColumnActions`
    }, {
      // hidden column, for search only
      field: CURRENT_SERIES,
      name: CURRENT_SERIES,
      dataType: 'boolean',
      width: '0px',
      render: () => ''
    });
    const items = this.getAnnotationsWithExtraInfo(annotations);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 720,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      "data-test-subj": 'mlAnnotationsTable',
      error: searchError,
      className: "eui-textBreakWord",
      compressed: true,
      items: items,
      columns: columns,
      pagination: {
        pageSizeOptions: [5, 10, 25]
      },
      sorting: this.sorting,
      search: search,
      rowProps: getRowProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 721,
        columnNumber: 9
      }
    }), this.state.jobId && this.state.datafeedFlyoutVisible && this.state.datafeedEnd ? /*#__PURE__*/_react.default.createElement(_datafeed_chart_flyout.DatafeedChartFlyout, {
      onClose: () => {
        this.setState({
          datafeedFlyoutVisible: false
        });
      },
      onModelSnapshotAnnotationClick: modelSnapshot => {
        this.setState({
          modelSnapshot,
          revertSnapshotFlyoutVisible: true,
          datafeedFlyoutVisible: false
        });
      },
      end: this.state.datafeedEnd,
      jobId: this.state.jobId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 736,
        columnNumber: 11
      }
    }) : null, this.state.revertSnapshotFlyoutVisible === true && this.state.modelSnapshot !== null ? /*#__PURE__*/_react.default.createElement(_revert_model_snapshot_flyout.RevertModelSnapshotFlyout, {
      snapshot: this.state.modelSnapshot,
      snapshots: [this.state.modelSnapshot],
      job: this.getJob(this.state.jobId),
      closeFlyout: () => {
        this.setState({
          revertSnapshotFlyoutVisible: false
        });
      },
      refresh: (_this$props$refreshJo = this.props.refreshJobList) !== null && _this$props$refreshJo !== void 0 ? _this$props$refreshJo : () => {},
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 754,
        columnNumber: 11
      }
    }) : null);
  }
}
(0, _defineProperty2.default)(AnnotationsTableUI, "propTypes", {
  annotations: _propTypes.default.array,
  annotationUpdatesService: _propTypes.default.object.isRequired,
  jobs: _propTypes.default.array,
  detectors: _propTypes.default.array,
  isSingleMetricViewerLinkVisible: _propTypes.default.bool,
  isNumberBadgeVisible: _propTypes.default.bool,
  refreshJobList: _propTypes.default.func,
  chartDetails: _propTypes.default.object,
  kibana: _propTypes.default.object
});
const AnnotationsTable = exports.AnnotationsTable = (0, _public.withKibana)(props => {
  const annotationUpdatesService = (0, _react.useContext)(_ml_annotation_updates_context.MlAnnotationUpdatesContext);
  return /*#__PURE__*/_react.default.createElement(AnnotationsTableUI, (0, _extends2.default)({
    annotationUpdatesService: annotationUpdatesService
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 773,
      columnNumber: 10
    }
  }));
});