"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAnomalyAlertFlyout = exports.JobListMlAnomalyAlertFlyout = exports.EditAlertRule = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _kibana = require("../application/contexts/kibana");
var _alerts = require("../../common/constants/alerts");
var _app = require("../../common/constants/app");
var _create_focus_trap_props = require("../application/util/create_focus_trap_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/ml_alerting_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Invoke alerting flyout from the ML plugin context.
 * @param initialAlert
 * @param jobIds
 * @param onCloseFlyout
 * @param onSave
 * @constructor
 */
const MlAnomalyAlertFlyout = ({
  initialAlert,
  jobIds,
  onCloseFlyout,
  onSave,
  focusTrapProps
}) => {
  const {
    services: {
      triggersActionsUi,
      ...services
    }
  } = (0, _kibana.useMlKibana)();
  const AlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUi) return;
    const {
      ruleTypeRegistry,
      actionTypeRegistry
    } = triggersActionsUi;
    const commonProps = {
      plugins: {
        ...services,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      onCancel: () => {
        onCloseFlyout();
      },
      onSubmit: async () => {
        if (onSave) {
          onSave();
        }
        onCloseFlyout();
      }
    };
    if (initialAlert) {
      return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, (0, _extends2.default)({}, commonProps, {
        id: initialAlert.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 14
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, (0, _extends2.default)({}, commonProps, {
      consumer: _app.PLUGIN_ID,
      ruleTypeId: _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION,
      initialMetadata: {},
      initialValues: {
        params: {
          jobSelection: {
            jobIds
          }
        }
      },
      focusTrapProps: focusTrapProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }));
    // deps on id to avoid re-rendering on auto-refresh
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [triggersActionsUi, initialAlert === null || initialAlert === void 0 ? void 0 : initialAlert.id, jobIds]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, AlertFlyout);
};
exports.MlAnomalyAlertFlyout = MlAnomalyAlertFlyout;
/**
 * Component to wire the Alerting flyout with the Job list view.
 * @param setShowFunction
 * @param unsetShowFunction
 * @constructor
 */
const JobListMlAnomalyAlertFlyout = ({
  setShowFunction,
  unsetShowFunction,
  onSave
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const [jobIds, setJobIds] = (0, _react.useState)();
  const showFlyoutCallback = (0, _react.useCallback)(jobIdsUpdate => {
    setJobIds(jobIdsUpdate);
    setIsVisible(true);
  }, []);
  (0, _react.useEffect)(() => {
    setShowFunction(showFlyoutCallback);
    return () => {
      unsetShowFunction();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return isVisible && jobIds ? /*#__PURE__*/_react.default.createElement(MlAnomalyAlertFlyout, {
    jobIds: jobIds,
    onCloseFlyout: () => setIsVisible(false),
    onSave: () => {
      setIsVisible(false);
      onSave();
    },
    focusTrapProps: (0, _create_focus_trap_props.createJobActionFocusTrapProps)(jobIds[0]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }) : null;
};
exports.JobListMlAnomalyAlertFlyout = JobListMlAnomalyAlertFlyout;
const EditAlertRule = ({
  initialAlert,
  onSave
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: setIsVisible.bind(null, !isVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, initialAlert.name), isVisible ? /*#__PURE__*/_react.default.createElement(MlAnomalyAlertFlyout, {
    initialAlert: initialAlert,
    onCloseFlyout: setIsVisible.bind(null, false),
    onSave: () => {
      setIsVisible(false);
      onSave();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }) : null);
};
exports.EditAlertRule = EditAlertRule;