"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _job_selector = require("../job_selector");
var _jobs = require("../../application/services/ml_api_service/jobs");
var _http_service = require("../../application/services/http_service");
var _kibana = require("../../application/contexts/kibana");
var _tests_selection_control = require("./tests_selection_control");
var _alerts = require("../../../common/constants/alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/alerting/jobs_health_rule/anomaly_detection_jobs_health_rule_trigger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionJobsHealthRuleTrigger = ({
  ruleParams,
  setRuleParams,
  errors
}) => {
  const {
    services: {
      http
    }
  } = (0, _kibana.useMlKibana)();
  const mlHttpService = (0, _react.useMemo)(() => new _http_service.HttpService(http), [http]);
  const adJobsApiService = (0, _react.useMemo)(() => (0, _jobs.jobsApiProvider)(mlHttpService), [mlHttpService]);
  const [excludeJobsOptions, setExcludeJobsOptions] = (0, _react.useState)([]);
  const includeJobsAndGroupIds = (0, _react.useMemo)(() => {
    var _ruleParams$includeJo;
    return Object.values((_ruleParams$includeJo = ruleParams.includeJobs) !== null && _ruleParams$includeJo !== void 0 ? _ruleParams$includeJo : {}).flat();
  }, [ruleParams.includeJobs]);
  const excludeJobsAndGroupIds = (0, _react.useMemo)(() => {
    var _ruleParams$excludeJo;
    return Object.values((_ruleParams$excludeJo = ruleParams.excludeJobs) !== null && _ruleParams$excludeJo !== void 0 ? _ruleParams$excludeJo : {}).flat();
  }, [ruleParams.excludeJobs]);
  const onAlertParamChange = (0, _react.useCallback)(param => update => {
    setRuleParams(param, update);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const formErrors = Object.values(errors).flat();
  const isFormInvalid = formErrors.length > 0;
  (0, _useDebounce.default)(function updateExcludeJobsOptions() {
    var _ruleParams$includeJo2, _ruleParams$includeJo3, _ruleParams$includeJo4, _ruleParams$includeJo5;
    const areAllJobsSelected = ((_ruleParams$includeJo2 = ruleParams.includeJobs) === null || _ruleParams$includeJo2 === void 0 ? void 0 : (_ruleParams$includeJo3 = _ruleParams$includeJo2.jobIds) === null || _ruleParams$includeJo3 === void 0 ? void 0 : _ruleParams$includeJo3[0]) === _alerts.ALL_JOBS_SELECTION;
    if (!areAllJobsSelected && !((_ruleParams$includeJo4 = ruleParams.includeJobs) !== null && _ruleParams$includeJo4 !== void 0 && (_ruleParams$includeJo5 = _ruleParams$includeJo4.groupIds) !== null && _ruleParams$includeJo5 !== void 0 && _ruleParams$includeJo5.length)) {
      // It only makes sense to suggest excluded jobs options when at least one group or all jobs are selected
      setExcludeJobsOptions([]);
      return;
    }
    adJobsApiService.jobs(areAllJobsSelected ? [] : ruleParams.includeJobs.groupIds).then(jobs => {
      setExcludeJobsOptions([{
        label: _i18n.i18n.translate('xpack.ml.jobSelector.jobOptionsLabel', {
          defaultMessage: 'Jobs'
        }),
        options: jobs.map(v => ({
          label: v.job_id
        }))
      }, {
        label: _i18n.i18n.translate('xpack.ml.jobSelector.groupOptionsLabel', {
          defaultMessage: 'Groups'
        }),
        options: [...new Set(jobs.map(v => v.groups).flat().filter(v => {
          var _ruleParams$includeJo6;
          return (0, _mlIsDefined.isDefined)(v) && !((_ruleParams$includeJo6 = ruleParams.includeJobs.groupIds) !== null && _ruleParams$includeJo6 !== void 0 && _ruleParams$includeJo6.includes(v));
        }))].map(v => ({
          label: v
        }))
      }]);
    });
  }, 500, [ruleParams.includeJobs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": 'mlJobsHealthAlertingRuleForm',
    invalidCallout: 'none',
    error: formErrors,
    isInvalid: isFormInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    jobsAndGroupIds: includeJobsAndGroupIds,
    adJobsApiService: adJobsApiService
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('includeJobs'), []),
    errors: Array.isArray(errors.includeJobs) ? errors.includeJobs : [],
    multiSelect: true,
    allowSelectAll: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.alertTypes.jobsHealthAlertingRule.includeJobs.label",
      defaultMessage: "Include jobs or groups",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }),
    shouldUseDropdownJobCreate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    jobsAndGroupIds: excludeJobsAndGroupIds,
    adJobsApiService: adJobsApiService,
    onChange: (0, _react.useCallback)(update => {
      const callback = onAlertParamChange('excludeJobs');
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(update)) {
        callback(update);
      } else {
        callback(null);
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []),
    errors: Array.isArray(errors.excludeJobs) ? errors.excludeJobs : [],
    multiSelect: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.alertTypes.jobsHealthAlertingRule.excludeJobs.label",
      defaultMessage: "Exclude jobs or groups",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    }),
    options: excludeJobsOptions,
    shouldUseDropdownJobCreate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_tests_selection_control.TestsSelectionControl, {
    config: ruleParams.testsConfig
    // eslint-disable-next-line react-hooks/exhaustive-deps
    ,
    onChange: (0, _react.useCallback)(onAlertParamChange('testsConfig'), []),
    errors: Array.isArray(errors.testsConfig) ? errors.testsConfig : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }));
};

// Default export is required for React.lazy loading

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AnomalyDetectionJobsHealthRuleTrigger;
module.exports = exports.default;