"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegionKeyEditor = RegionKeyEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ems_file_select = require("../../components/ems_file_select");
var _util = require("../../util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/lens/choropleth_chart/region_key_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RegionKeyEditor(props) {
  const [emsFileLayers, setEmsFileLayers] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let ignore = false;
    setIsLoading(true);
    (0, _util.getEmsFileLayers)().then(fileLayers => {
      if (!ignore) {
        setEmsFileLayers(fileLayers);
        setIsLoading(false);
      }
    }).catch(() => {
      if (!ignore) {
        // eslint-disable-next-line no-console
        console.warn(`Lens region map is unable to access administrative boundaries from Elastic Maps Service (EMS). To avoid unnecessary EMS requests, set 'map.includeElasticMapsService: false' in 'kibana.yml'.`);
        setIsLoading(false);
      }
    });
    return () => {
      ignore = true;
    };
  }, []);
  function onEmsLayerSelect(emsLayerId) {
    const emsFields = getEmsFields(emsFileLayers, emsLayerId);
    props.setState({
      ...props.state,
      emsLayerId,
      emsField: emsFields.length ? emsFields[0].value : undefined
    });
  }
  const emsFieldSelect = (0, _react.useMemo)(() => {
    const emsFields = getEmsFields(emsFileLayers, props.state.emsLayerId);
    if (emsFields.length === 0) {
      return null;
    }
    const selectedOption = props.state.emsField ? emsFields.find(option => {
      return props.state.emsField === option.value;
    }) : undefined;
    function onEmsFieldSelect(selectedOptions) {
      if (selectedOptions.length === 0) {
        return;
      }
      props.setState({
        ...props.state,
        emsField: selectedOptions[0].value
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.choropleth.joinFieldLabel', {
        defaultMessage: 'Join field'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: true,
      isClearable: false,
      options: emsFields,
      selectedOptions: selectedOption ? [selectedOption] : [],
      onChange: onEmsFieldSelect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }));
  }, [emsFileLayers, props]);
  return isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isLoading: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ems_file_select.EMSFileSelect, {
    isColumnCompressed: true,
    value: props.state.emsLayerId ? props.state.emsLayerId : null,
    onChange: onEmsLayerSelect,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), emsFieldSelect);
}
function getEmsFields(emsFileLayers, emsLayerId) {
  if (!emsLayerId) {
    return [];
  }
  const emsFileLayer = emsFileLayers.find(fileLayer => {
    return fileLayer.getId() === emsLayerId;
  });
  return emsFileLayer ? emsFileLayer.getFieldsInLanguage().filter(field => {
    return field.type === 'id';
  }).map(field => {
    return {
      value: field.name,
      label: field.description
    };
  }) : [];
}