"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChoroplethChart = ChoroplethChart;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _constants = require("../../../common/constants");
var _get_ems_suggestion = require("./get_ems_suggestion");
var _passive_map = require("../passive_map");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/lens/choropleth_chart/choropleth_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ChoroplethChart({
  data,
  args,
  formatFactory,
  uiSettings,
  emsFileLayers,
  onRenderComplete
}) {
  if (!args.regionAccessor || !args.valueAccessor) {
    return null;
  }
  let emsLayerId = args.emsLayerId ? args.emsLayerId : _constants.emsWorldLayerId;
  let emsField = args.emsField ? args.emsField : 'iso2';
  if (!args.emsLayerId || !args.emsField) {
    const emsSuggestion = (0, _get_ems_suggestion.getEmsSuggestion)(emsFileLayers, data, args.regionAccessor);
    if (emsSuggestion) {
      emsLayerId = emsSuggestion.layerId;
      emsField = emsSuggestion.field;
    }
  }
  const emsLayerLabel = getEmsLayerLabel(emsLayerId, emsFileLayers);
  const choroplethLayer = {
    id: args.layerId,
    label: emsLayerLabel ? _i18n.i18n.translate('xpack.maps.lens.choroplethChart.choroplethLayerLabel', {
      defaultMessage: '{emsLayerLabel} by {accessorLabel}',
      values: {
        emsLayerLabel,
        accessorLabel: getAccessorLabel(data, args.valueAccessor)
      }
    }) : '',
    joins: [{
      leftField: emsField,
      right: {
        id: args.valueAccessor,
        type: _common.SOURCE_TYPES.TABLE_SOURCE,
        __rows: data.rows,
        __columns: [{
          name: args.regionAccessor,
          label: getAccessorLabel(data, args.regionAccessor),
          type: 'string'
        }, {
          name: args.valueAccessor,
          label: getAccessorLabel(data, args.valueAccessor),
          type: 'number'
        }],
        // Right join/term is the field in the doc you’re trying to join it to (foreign key - e.g. US)
        term: args.regionAccessor
      }
    }],
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.EMS_FILE,
      id: emsLayerId,
      tooltipProperties: [emsField]
    },
    style: {
      type: 'VECTOR',
      // @ts-ignore missing style properties. Remove once 'VectorLayerDescriptor' type is updated
      properties: {
        [_common.VECTOR_STYLES.FILL_COLOR]: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            color: 'Blue to Red',
            colorCategory: 'palette_0',
            fieldMetaOptions: {
              isEnabled: true,
              sigma: 3
            },
            type: _common.COLOR_MAP_TYPE.ORDINAL,
            field: {
              name: args.valueAccessor,
              origin: _common.FIELD_ORIGIN.JOIN
            },
            useCustomColorRamp: false
          }
        },
        [_common.VECTOR_STYLES.LINE_COLOR]: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            color: '#3d3d3d'
          }
        },
        [_common.VECTOR_STYLES.LINE_WIDTH]: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 1
          }
        }
      },
      isTimeAware: false
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  return /*#__PURE__*/_react.default.createElement(_passive_map.PassiveMap, {
    passiveLayer: choroplethLayer,
    onRenderComplete: onRenderComplete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 10
    }
  });
}
function getAccessorLabel(table, accessor) {
  const column = table.columns.find(col => {
    return col.id === accessor;
  });
  return column ? column.name : accessor;
}
function getEmsLayerLabel(emsLayerId, emsFileLayers) {
  const fileLayer = emsFileLayers.find(file => {
    return file.getId() === emsLayerId;
  });
  return fileLayer ? fileLayer.getDisplayName() : null;
}