"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isScreenshotMode = exports.getVisualizeCapabilities = exports.getUsageCollection = exports.getUrlForApp = exports.getUiSettings = exports.getUiActions = exports.getToasts = exports.getTimeFilter = exports.getTheme = exports.getSpacesApi = exports.getSpaceId = exports.getShowMapsInspectorAdapter = exports.getShareService = exports.getServerless = exports.getSearchService = exports.getSearchBar = exports.getSavedObjectsTagging = exports.getPreserveDrawingBuffer = exports.getNavigation = exports.getNavigateToUrl = exports.getNavigateToApp = exports.getMapsEmsStart = exports.getMapsCapabilities = exports.getMapAppConfig = exports.getIsDarkMode = exports.getIsCloud = exports.getInspector = exports.getIndexPatternService = exports.getIndexPatternSelectComponent = exports.getIndexNameFormComponent = exports.getHttp = exports.getFileUploadComponent = exports.getFileUpload = exports.getExecutionContextService = exports.getEmsTileLayerId = exports.getEmbeddableService = exports.getEmbeddableEnhanced = exports.getEMSSettings = exports.getDocLinks = exports.getDevToolsCapabilities = exports.getData = exports.getCoreOverlays = exports.getCoreI18n = exports.getCoreChrome = exports.getCore = exports.getContentManagement = exports.getCharts = exports.getAutocompleteService = exports.getApplication = exports.getAnalytics = void 0;
exports.setIsCloudEnabled = setIsCloudEnabled;
exports.setSpaceId = exports.setMapAppConfig = void 0;
exports.setStartServices = setStartServices;
exports.untilPluginStartServicesReady = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/maps-ems-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
let isDarkMode = false;
let coreStart;
let pluginsStart;
let mapsEms;
let emsSettings;
function setStartServices(core, plugins) {
  coreStart = core;
  pluginsStart = plugins;
  mapsEms = plugins.mapsEms;
  emsSettings = mapsEms.createEMSSettings();
  core.theme.theme$.subscribe(({
    darkMode
  }) => {
    isDarkMode = darkMode;
  });
  servicesReady$.next(true);
}
let isCloudEnabled = false;
function setIsCloudEnabled(enabled) {
  isCloudEnabled = enabled;
}
const getIsCloud = () => isCloudEnabled;
exports.getIsCloud = getIsCloud;
let spaceId = 'default';
const getSpaceId = () => spaceId;
exports.getSpaceId = getSpaceId;
const setSpaceId = _spaceId => {
  spaceId = _spaceId;
};
exports.setSpaceId = setSpaceId;
const getIndexNameFormComponent = () => pluginsStart.fileUpload.IndexNameFormComponent;
exports.getIndexNameFormComponent = getIndexNameFormComponent;
const getFileUploadComponent = () => pluginsStart.fileUpload.FileUploadComponent;
exports.getFileUploadComponent = getFileUploadComponent;
const getIndexPatternService = () => pluginsStart.data.dataViews;
exports.getIndexPatternService = getIndexPatternService;
const getAutocompleteService = () => pluginsStart.unifiedSearch.autocomplete;
exports.getAutocompleteService = getAutocompleteService;
const getInspector = () => pluginsStart.inspector;
exports.getInspector = getInspector;
const getFileUpload = () => pluginsStart.fileUpload;
exports.getFileUpload = getFileUpload;
const getUiSettings = () => coreStart.uiSettings;
exports.getUiSettings = getUiSettings;
const getIsDarkMode = () => isDarkMode;
exports.getIsDarkMode = getIsDarkMode;
const getIndexPatternSelectComponent = () => pluginsStart.unifiedSearch.ui.IndexPatternSelect;
exports.getIndexPatternSelectComponent = getIndexPatternSelectComponent;
const getSearchBar = () => pluginsStart.unifiedSearch.ui.SearchBar;
exports.getSearchBar = getSearchBar;
const getHttp = () => coreStart.http;
exports.getHttp = getHttp;
const getExecutionContextService = () => coreStart.executionContext;
exports.getExecutionContextService = getExecutionContextService;
const getTimeFilter = () => pluginsStart.data.query.timefilter.timefilter;
exports.getTimeFilter = getTimeFilter;
const getToasts = () => coreStart.notifications.toasts;
exports.getToasts = getToasts;
const getCoreChrome = () => coreStart.chrome;
exports.getCoreChrome = getCoreChrome;
const getDevToolsCapabilities = () => coreStart.application.capabilities.dev_tools;
exports.getDevToolsCapabilities = getDevToolsCapabilities;
const getMapsCapabilities = () => coreStart.application.capabilities.maps_v2;
exports.getMapsCapabilities = getMapsCapabilities;
const getVisualizeCapabilities = () => coreStart.application.capabilities.visualize_v2;
exports.getVisualizeCapabilities = getVisualizeCapabilities;
const getDocLinks = () => coreStart.docLinks;
exports.getDocLinks = getDocLinks;
const getCoreOverlays = () => coreStart.overlays;
exports.getCoreOverlays = getCoreOverlays;
const getCharts = () => pluginsStart.charts;
exports.getCharts = getCharts;
const getData = () => pluginsStart.data;
exports.getData = getData;
const getUiActions = () => pluginsStart.uiActions;
exports.getUiActions = getUiActions;
const getCore = () => coreStart;
exports.getCore = getCore;
const getNavigation = () => pluginsStart.navigation;
exports.getNavigation = getNavigation;
const getCoreI18n = () => coreStart.i18n;
exports.getCoreI18n = getCoreI18n;
const getAnalytics = () => coreStart.analytics;
exports.getAnalytics = getAnalytics;
const getSearchService = () => pluginsStart.data.search;
exports.getSearchService = getSearchService;
const getEmbeddableService = () => pluginsStart.embeddable;
exports.getEmbeddableService = getEmbeddableService;
const getNavigateToApp = () => coreStart.application.navigateToApp;
exports.getNavigateToApp = getNavigateToApp;
const getUrlForApp = () => coreStart.application.getUrlForApp;
exports.getUrlForApp = getUrlForApp;
const getNavigateToUrl = () => coreStart.application.navigateToUrl;
exports.getNavigateToUrl = getNavigateToUrl;
const getSavedObjectsTagging = () => pluginsStart.savedObjectsTagging;
exports.getSavedObjectsTagging = getSavedObjectsTagging;
const getSpacesApi = () => pluginsStart.spaces;
exports.getSpacesApi = getSpacesApi;
const getTheme = () => coreStart.theme;
exports.getTheme = getTheme;
const getApplication = () => coreStart.application;
exports.getApplication = getApplication;
const getUsageCollection = () => pluginsStart.usageCollection;
exports.getUsageCollection = getUsageCollection;
const getContentManagement = () => pluginsStart.contentManagement;
exports.getContentManagement = getContentManagement;
const isScreenshotMode = () => {
  return pluginsStart.screenshotMode ? pluginsStart.screenshotMode.isScreenshotMode() : false;
};
exports.isScreenshotMode = isScreenshotMode;
const getServerless = () => pluginsStart.serverless;
exports.getServerless = getServerless;
const getEmbeddableEnhanced = () => pluginsStart.embeddableEnhanced;

// xpack.maps.* kibana.yml settings from this plugin
exports.getEmbeddableEnhanced = getEmbeddableEnhanced;
let mapAppConfig;
const setMapAppConfig = config => mapAppConfig = config;
exports.setMapAppConfig = setMapAppConfig;
const getMapAppConfig = () => mapAppConfig;
exports.getMapAppConfig = getMapAppConfig;
const getShowMapsInspectorAdapter = () => getMapAppConfig().showMapsInspectorAdapter;
exports.getShowMapsInspectorAdapter = getShowMapsInspectorAdapter;
const getPreserveDrawingBuffer = () => getMapAppConfig().preserveDrawingBuffer;
exports.getPreserveDrawingBuffer = getPreserveDrawingBuffer;
const getMapsEmsStart = () => {
  return mapsEms;
};
exports.getMapsEmsStart = getMapsEmsStart;
const getEMSSettings = () => {
  return emsSettings;
};
exports.getEMSSettings = getEMSSettings;
const getEmsTileLayerId = () => {
  // To be updated unce Borealis is the only theme available
  if (coreStart.theme.getTheme().name !== 'borealis') {
    return mapsEms.config.emsTileLayerId;
  } else {
    return {
      ...mapsEms.config.emsTileLayerId,
      dark: _common.EMS_DARKMAP_BOREALIS_ID,
      desaturated: _common.EMS_ROADMAP_BOREALIS_DESATURATED_ID
    };
  }
};
exports.getEmsTileLayerId = getEmsTileLayerId;
const getShareService = () => pluginsStart.share;
exports.getShareService = getShareService;