"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerTOC = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _toc_entry = require("./toc_entry");
var _layer_group = require("../../../../classes/layers/layer_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/right_side_controls/layer_control/layer_toc/layer_toc.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CLEAR_DND_STATE = {
  combineLayer: null,
  isOwnAncestor: false,
  newRightSiblingLayer: null,
  sourceLayer: null
};
class LayerTOC extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ...CLEAR_DND_STATE
    });
    (0, _defineProperty2.default)(this, "_updateDebounced", _lodash.default.debounce(this.forceUpdate, 100));
    (0, _defineProperty2.default)(this, "_onDragStart", ({
      source
    }) => {
      const sourceIndex = this._reverseIndex(source.index);
      const sourceLayer = this.props.layerList[sourceIndex];
      this.setState({
        ...CLEAR_DND_STATE,
        sourceLayer
      });
    });
    (0, _defineProperty2.default)(this, "_onDragUpdate", ({
      combine,
      destination,
      source
    }) => {
      const sourceIndex = this._reverseIndex(source.index);
      const sourceLayer = this.props.layerList[sourceIndex];
      if (combine) {
        const combineIndex = this.props.layerList.findIndex(findLayer => {
          return findLayer.getId() === combine.draggableId;
        });
        const combineLayer = combineIndex !== -1 ? this.props.layerList[combineIndex] : null;
        const newRightSiblingIndex = combineIndex - 1;
        const newRightSiblingLayer = newRightSiblingIndex < 0 ? null : this.props.layerList[newRightSiblingIndex];
        const forebearers = combineLayer ? this._getForebearers(combineLayer) : [];
        this.setState({
          combineLayer,
          newRightSiblingLayer,
          sourceLayer,
          isOwnAncestor: forebearers.includes(sourceLayer.getId())
        });
        return;
      }
      if (!destination || source.index === destination.index) {
        this.setState({
          ...CLEAR_DND_STATE
        });
        return;
      }
      const destinationIndex = this._reverseIndex(destination.index);
      const newRightSiblingIndex = sourceIndex > destinationIndex ?
      // When layer is moved to the right, new right sibling is layer to the right of destination
      destinationIndex - 1 :
      // When layer is moved to the left, new right sibling is the destination
      destinationIndex;
      const newRightSiblingLayer = newRightSiblingIndex < 0 ? null : this.props.layerList[newRightSiblingIndex];
      const forebearers = newRightSiblingLayer ? this._getForebearers(newRightSiblingLayer) : [];
      this.setState({
        combineLayer: null,
        newRightSiblingLayer,
        sourceLayer,
        isOwnAncestor: forebearers.includes(sourceLayer.getId())
      });
    });
    (0, _defineProperty2.default)(this, "_onDragEnd", () => {
      const {
        combineLayer,
        isOwnAncestor,
        sourceLayer,
        newRightSiblingLayer
      } = this.state;
      this.setState({
        ...CLEAR_DND_STATE
      });
      if (isOwnAncestor || !sourceLayer) {
        return;
      }
      if (combineLayer) {
        // add source to layer group when combine is layer group
        if ((0, _layer_group.isLayerGroup)(combineLayer) && newRightSiblingLayer) {
          this.props.setLayerParent(sourceLayer.getId(), combineLayer.getId());
          this.props.moveLayerToLeftOfTarget(sourceLayer.getId(), newRightSiblingLayer.getId());
          return;
        }

        // creage layer group that contains source and combine
        this.props.createLayerGroup(sourceLayer.getId(), combineLayer.getId());
        return;
      }
      if (newRightSiblingLayer) {
        this.props.setLayerParent(sourceLayer.getId(), newRightSiblingLayer.getParent());
        this.props.moveLayerToLeftOfTarget(sourceLayer.getId(), newRightSiblingLayer.getId());
        return;
      }
      this.props.moveLayerToBottom(sourceLayer.getId());
    });
  }
  componentWillUnmount() {
    this._updateDebounced.cancel();
  }
  shouldComponentUpdate() {
    this._updateDebounced();
    return false;
  }
  _reverseIndex(index) {
    return this.props.layerList.length - index - 1;
  }
  _getForebearers(layer) {
    const parentId = layer.getParent();
    if (!parentId) {
      return [];
    }
    const parentLayer = this.props.layerList.find(findLayer => {
      return findLayer.getId() === parentId;
    });
    if (!parentLayer) {
      return [];
    }
    return [...this._getForebearers(parentLayer), parentId];
  }
  _getDepth(layer, depth) {
    if (layer.getParent() === undefined) {
      return {
        depth,
        showInTOC: true
      };
    }
    const parent = this.props.layerList.find(nextLayer => {
      return layer.getParent() === nextLayer.getId();
    });
    if (!parent) {
      return {
        depth,
        showInTOC: false
      };
    }
    return this.props.openTOCDetails.includes(parent.getId()) ? this._getDepth(parent, depth + 1) : {
      depth,
      showInTOC: false
    };
  }
  _getDroppableClass() {
    if (!this.state.sourceLayer) {
      // nothing is dragged
      return '';
    }
    if (this.state.isOwnAncestor) {
      return 'mapLayerToc-droppable-dropNotAllowed';
    }
    if (this.state.combineLayer) {
      return 'mapLayerToc-droppable-isCombining';
    }
    return 'mapLayerToc-droppable-isDragging';
  }
  _renderLayers() {
    const tocEntryList = this.props.layerList.map((layer, index) => {
      return {
        ...this._getDepth(layer, 0),
        draggableIndex: this._reverseIndex(index),
        layer
      };
    }).filter(({
      showInTOC
    }) => {
      return showInTOC;
    })
    // Reverse layer list so first layer drawn on map is at the bottom and
    // last layer drawn on map is at the top.
    .reverse();
    if (this.props.isReadOnly) {
      return tocEntryList.map(({
        depth,
        layer
      }) => {
        return /*#__PURE__*/_react.default.createElement(_toc_entry.TOCEntry, {
          key: layer.getId(),
          depth: depth,
          layer: layer,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 16
          }
        });
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragStart: this._onDragStart,
      onDragUpdate: this._onDragUpdate,
      onDragEnd: this._onDragEnd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: "mapLayerTOC",
      spacing: "none",
      isCombineEnabled: !this.state.isOwnAncestor,
      className: this._getDroppableClass(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, (droppableProvided, droppableSnapshot) => {
      const tocEntries = tocEntryList.map(({
        draggableIndex,
        depth,
        layer
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
        spacing: "none",
        key: layer.getId(),
        index: draggableIndex,
        draggableId: layer.getId(),
        customDragHandle: true,
        disableInteractiveElementBlocking: true // Allows button to be drag handle
        ,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 15
        }
      }, (draggableProvided, draggableSnapshot) => {
        return /*#__PURE__*/_react.default.createElement(_toc_entry.TOCEntry, {
          depth: depth,
          layer: layer,
          dragHandleProps: draggableProvided.dragHandleProps,
          isDragging: draggableSnapshot.isDragging,
          isDraggingOver: droppableSnapshot.isDraggingOver,
          isCombineLayer: this.state.combineLayer !== null && this.state.combineLayer.getId() === layer.getId(),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 21
          }
        });
      }));
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 20
        }
      }, tocEntries);
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mapLayerTOC",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 12
      }
    }, this._renderLayers());
  }
}
exports.LayerTOC = LayerTOC;