"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinEditor = JoinEditor;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _join = require("./resources/join");
var _join_documentation_popover = require("./resources/join_documentation_popover");
var _es_source = require("../../../classes/sources/es_source");
var _constants = require("../../../../common/constants");
var _add_join_button = require("./add_join_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/join_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function JoinEditor({
  joins,
  layer,
  onChange,
  leftJoinFields,
  layerDisplayName
}) {
  const [supportsSpatialJoin, setSupportsSpatialJoin] = (0, _react.useState)(false);
  const [spatialJoinDisableReason, setSpatialJoinDisableReason] = (0, _react.useState)('');
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let ignore = false;
    const source = layer.getSource();
    if (!(0, _es_source.isESSource)(source)) {
      setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.esSourceOnly', {
        defaultMessage: 'Spatial joins are not supported for {sourceType}.',
        values: {
          sourceType: source.getType()
        }
      }));
      setSupportsSpatialJoin(false);
      return;
    }
    if (source.isMvt()) {
      setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.geoJsonOnly', {
        defaultMessage: 'Spatial joins are not supported with vector tiles.'
      }));
      setSupportsSpatialJoin(false);
      return;
    }

    // TODO remove isPointsOnly check once non-point spatial joins have been implemented
    setIsLoading(true);
    source.getSupportedShapeTypes().then(supportedShapes => {
      if (!ignore) {
        const isPointsOnly = supportedShapes.length === 1 && supportedShapes[0] === _constants.VECTOR_SHAPE_TYPE.POINT;
        if (!isPointsOnly) {
          setSpatialJoinDisableReason(_i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.disabled.pointsOnly', {
            defaultMessage: 'Spatial joins are not supported with geo_shape geometry.'
          }));
          setSupportsSpatialJoin(isPointsOnly);
          setIsLoading(false);
          return;
        }
        setSpatialJoinDisableReason('');
        setSupportsSpatialJoin(true);
        setIsLoading(false);
      }
    }).catch(error => {
      // keep spatial joins disabled when unable to verify if they are supported
    });
    return () => {
      ignore = true;
    };
  }, [layer]);
  const renderJoins = () => {
    return joins.map((joinDescriptor, index) => {
      var _joinDescriptor$right, _joinDescriptor$right2;
      const handleOnChange = updatedDescriptor => {
        onChange(layer, [...joins.slice(0, index), updatedDescriptor, ...joins.slice(index + 1)]);
      };
      const handleOnRemove = () => {
        onChange(layer, [...joins.slice(0, index), ...joins.slice(index + 1)]);
      };
      return /*#__PURE__*/_react.default.createElement(_join.Join, {
        key: (_joinDescriptor$right = joinDescriptor === null || joinDescriptor === void 0 ? void 0 : (_joinDescriptor$right2 = joinDescriptor.right) === null || _joinDescriptor$right2 === void 0 ? void 0 : _joinDescriptor$right2.id) !== null && _joinDescriptor$right !== void 0 ? _joinDescriptor$right : index,
        join: joinDescriptor,
        onChange: handleOnChange,
        onRemove: handleOnRemove,
        leftFields: leftJoinFields,
        leftSourceName: layerDisplayName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      });
    });
  };
  const addJoin = joinDescriptor => {
    var _joinDescriptor$right3;
    onChange(layer, [...joins, {
      ...joinDescriptor,
      right: {
        ...((_joinDescriptor$right3 = joinDescriptor === null || joinDescriptor === void 0 ? void 0 : joinDescriptor.right) !== null && _joinDescriptor$right3 !== void 0 ? _joinDescriptor$right3 : {})
      }
    }]);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerPanel.joinEditor.title",
    defaultMessage: "Joins",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_join_documentation_popover.JoinDocumentationPopover, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }))), renderJoins(), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_add_join_button.AddJoinButton, {
    disabledReason: spatialJoinDisableReason,
    isDisabled: !supportsSpatialJoin,
    label: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.spatialJoin.addButtonLabel', {
      defaultMessage: 'Add spatial join'
    }),
    onClick: () => {
      addJoin({
        leftField: '_id',
        right: {
          type: _constants.SOURCE_TYPES.ES_DISTANCE_SOURCE,
          id: (0, _uuid.v4)(),
          applyGlobalQuery: true,
          applyGlobalTime: true
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_add_join_button.AddJoinButton, {
    disabledReason: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.termJoin.mvtSingleJoinMsg', {
      defaultMessage: 'Vector tiles can only support a single join.'
    }),
    isDisabled: layer.getSource().isMvt() && joins.length >= 1,
    label: _i18n.i18n.translate('xpack.maps.layerPanel.joinEditor.termJoin.addButtonLabel', {
      defaultMessage: 'Add term join'
    }),
    onClick: () => {
      addJoin({
        right: {
          type: _constants.SOURCE_TYPES.ES_TERM_SOURCE,
          id: (0, _uuid.v4)(),
          applyGlobalQuery: true,
          applyGlobalTime: true
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }))));
}