"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trigger_utils = require("../trigger_actions/trigger_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/action_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ActionSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      actions: []
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadActions();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadActions() {
    if (!this.props.getFilterActions || !this.props.getActionContext) {
      return;
    }
    const actions = await this.props.getFilterActions();
    if (this._isMounted) {
      this.setState({
        actions: actions.filter(action => !(0, _trigger_utils.isUrlDrilldown)(action))
      });
    }
  }
  render() {
    if (this.state.actions.length === 0 || !this.props.getActionContext) {
      return null;
    }
    if (this.state.actions.length === 1 && this.props.value === this.state.actions[0].id) {
      return null;
    }
    const actionContext = this.props.getActionContext();
    const options = this.state.actions.map(action => {
      const iconType = action.getIconType(actionContext);
      return {
        value: action.id,
        inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 11
          }
        }, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          className: "mapActionSelectIcon",
          type: iconType,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 25
          }
        }) : null, action.getDisplayName(actionContext))
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.actionSelect.label', {
        defaultMessage: 'Action'
      }),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      compressed: true,
      options: options,
      valueOfSelected: this.props.value ? this.props.value : '',
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }));
  }
}
exports.ActionSelect = ActionSelect;