"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconStops = IconStops;
exports.getFirstUnusedSymbol = getFirstUnusedSymbol;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../common/constants");
var _i18n = require("@kbn/i18n");
var _style_util = require("../../style_util");
var _eui = require("@elastic/eui");
var _icon_select = require("./icon_select");
var _stop_input = require("../stop_input");
var _symbol_utils = require("../../symbol_utils");
var _map_color_stops = require("../map_color_stops.styles");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/icon_stops.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isDuplicateStop(targetStop, iconStops) {
  const stops = iconStops.filter(({
    stop
  }) => {
    return targetStop === stop;
  });
  return stops.length > 1;
}
function getFirstUnusedSymbol(iconStops) {
  const firstUnusedPreferredIconId = _symbol_utils.PREFERRED_ICONS.find(iconId => {
    const isSymbolBeingUsed = iconStops.some(({
      icon
    }) => {
      return icon === iconId;
    });
    return !isSymbolBeingUsed;
  });
  if (firstUnusedPreferredIconId) {
    return firstUnusedPreferredIconId;
  }
  const firstUnusedSymbol = _symbol_utils.SYMBOL_OPTIONS.find(({
    value
  }) => {
    const isSymbolBeingUsed = iconStops.some(({
      icon
    }) => {
      return icon === value;
    });
    return !isSymbolBeingUsed;
  });
  return firstUnusedSymbol ? firstUnusedSymbol.value : _constants.DEFAULT_ICON;
}
function IconStops({
  field,
  getValueSuggestions,
  iconStops,
  onChange,
  onCustomIconsChange,
  customIcons
}) {
  const styles = (0, _use_memo_css.useMemoCss)(_map_color_stops.mapColorStopsStyles);
  return iconStops.map(({
    stop,
    icon,
    iconSource
  }, index) => {
    const iconInfo = iconSource === _constants.ICON_SOURCE.CUSTOM ? customIcons.find(({
      symbolId
    }) => symbolId === icon) : (0, _symbol_utils.getMakiSymbol)(icon);
    if (iconInfo === undefined) return;
    const {
      svg,
      label
    } = iconInfo;
    const onIconSelect = ({
      selectedIconId
    }) => {
      const newIconStops = [...iconStops];
      newIconStops[index] = {
        ...iconStops[index],
        icon: selectedIconId
      };
      onChange({
        customStops: newIconStops
      });
    };
    const onStopChange = newStopValue => {
      const newIconStops = [...iconStops];
      newIconStops[index] = {
        ...iconStops[index],
        stop: newStopValue
      };
      onChange({
        customStops: newIconStops,
        isInvalid: isDuplicateStop(newStopValue, iconStops)
      });
    };
    const onAdd = () => {
      onChange({
        customStops: [...iconStops.slice(0, index + 1), {
          stop: '',
          icon: getFirstUnusedSymbol(iconStops)
        }, ...iconStops.slice(index + 1)]
      });
    };
    const onRemove = () => {
      onChange({
        customStops: [...iconStops.slice(0, index), ...iconStops.slice(index + 1)]
      });
    };
    let deleteButton;
    if (iconStops.length > 2 && index !== 0) {
      deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "trash",
        color: "danger",
        "aria-label": _i18n.i18n.translate('xpack.maps.styles.iconStops.deleteButtonAriaLabel', {
          defaultMessage: 'Delete'
        }),
        title: _i18n.i18n.translate('xpack.maps.styles.iconStops.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        onClick: onRemove,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      });
    }
    const iconStopButtons = /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, deleteButton, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      color: "primary",
      "aria-label": "Add",
      title: "Add",
      onClick: onAdd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }));
    const errors = [];
    // TODO check for duplicate values and add error messages here

    const stopInput = index === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "aria-label": _style_util.OTHER_CATEGORY_LABEL,
      placeholder: _style_util.OTHER_CATEGORY_LABEL,
      disabled: true,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_stop_input.StopInput, {
      key: field.getName() // force new component instance when field changes
      ,
      field: field,
      getValueSuggestions: getValueSuggestions,
      value: stop,
      onChange: onStopChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: index,
      css: styles.mapColorStops,
      isInvalid: errors.length !== 0,
      error: errors,
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "mapStyleSettings__fixedBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }, stopInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_icon_select.IconSelect, {
      onCustomIconsChange: onCustomIconsChange,
      customIcons: customIcons,
      onChange: onIconSelect,
      icon: {
        value: icon,
        svg,
        label
      },
      append: iconStopButtons,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    }))));
  }).filter(stop => {
    return stop !== undefined;
  });
}