"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geoLineTitle = exports.REQUIRES_GOLD_LICENSE_MSG = exports.ESGeoLineSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../../common/constants");
var _elasticsearch_util = require("../../../../common/elasticsearch_util");
var _i18n_getters = require("../../../../common/i18n_getters");
var _es_agg_source = require("../es_agg_source");
var _convert_to_geojson = require("./convert_to_geojson");
var _es_doc_field = require("../../fields/es_doc_field");
var _inline_field = require("../../fields/inline_field");
var _update_source_editor = require("./update_source_editor");
var _vector_source = require("../vector_source");
var _valid_string_config = require("../../util/valid_string_config");
var _tooltip_property = require("../../tooltips/tooltip_property");
var _licensed_features = require("../../../licensed_features");
var _execution_context_utils = require("../execution_context_utils");
var _geo_line_form = require("./geo_line_form");
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_line_source/es_geo_line_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const geoLineTitle = exports.geoLineTitle = _i18n.i18n.translate('xpack.maps.source.esGeoLineTitle', {
  defaultMessage: 'Tracks'
});
const REQUIRES_GOLD_LICENSE_MSG = exports.REQUIRES_GOLD_LICENSE_MSG = _i18n.i18n.translate('xpack.maps.source.esGeoLineDisabledReason', {
  defaultMessage: '{title} requires a Gold license.',
  values: {
    title: geoLineTitle
  }
});
class ESGeoLineSource extends _es_agg_source.AbstractESAggSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_agg_source.AbstractESAggSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(normalizedDescriptor.geoField)) {
      throw new Error('Cannot create an ESGeoLineSource without a geoField');
    }
    const groupByTimeseries = typeof normalizedDescriptor.groupByTimeseries === 'boolean' ? normalizedDescriptor.groupByTimeseries : false;
    return {
      ...normalizedDescriptor,
      type: _constants.SOURCE_TYPES.ES_GEO_LINE,
      groupByTimeseries,
      lineSimplificationSize: typeof normalizedDescriptor.lineSimplificationSize === 'number' ? normalizedDescriptor.lineSimplificationSize : _constants2.DEFAULT_LINE_SIMPLIFICATION_SIZE,
      geoField: normalizedDescriptor.geoField,
      splitField: normalizedDescriptor.splitField,
      sortField: normalizedDescriptor.sortField
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = ESGeoLineSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  getBucketsName() {
    return _i18n.i18n.translate('xpack.maps.source.esGeoLine.bucketsName', {
      defaultMessage: 'tracks'
    });
  }
  getGeoFieldName() {
    return this._descriptor.geoField;
  }
  renderSourceSettingsEditor({
    onChange
  }) {
    var _this$_descriptor$spl, _this$_descriptor$sor;
    return /*#__PURE__*/_react.default.createElement(_update_source_editor.UpdateSourceEditor, {
      bucketsName: this.getBucketsName(),
      indexPatternId: this.getIndexPatternId(),
      onChange: onChange,
      metrics: this._descriptor.metrics,
      groupByTimeseries: this._descriptor.groupByTimeseries,
      lineSimplificationSize: this._descriptor.lineSimplificationSize,
      splitField: (_this$_descriptor$spl = this._descriptor.splitField) !== null && _this$_descriptor$spl !== void 0 ? _this$_descriptor$spl : '',
      sortField: (_this$_descriptor$sor = this._descriptor.sortField) !== null && _this$_descriptor$sor !== void 0 ? _this$_descriptor$sor : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    });
  }
  getSyncMeta(dataFilters) {
    return {
      ...super.getSyncMeta(dataFilters),
      groupByTimeseries: this._descriptor.groupByTimeseries,
      lineSimplificationSize: this._descriptor.lineSimplificationSize,
      splitField: this._descriptor.splitField,
      sortField: this._descriptor.sortField
    };
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: geoLineTitle
    }, {
      label: (0, _i18n_getters.getDataViewLabel)(),
      value: await this.getDisplayName()
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.esGeoLine.geospatialFieldLabel', {
        defaultMessage: 'Geospatial field'
      }),
      value: this._descriptor.geoField
    }];
  }
  _createSplitField() {
    return this._descriptor.splitField ? new _es_doc_field.ESDocField({
      fieldName: this._descriptor.splitField,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE
    }) : null;
  }
  _createTsidField() {
    return new _inline_field.InlineField({
      fieldName: _constants2.TIME_SERIES_ID_FIELD_NAME,
      label: _constants2.TIME_SERIES_ID_FIELD_NAME,
      source: this,
      origin: _constants.FIELD_ORIGIN.SOURCE,
      dataType: 'string'
    });
  }
  async getFields() {
    const groupByField = this._descriptor.groupByTimeseries ? this._createTsidField() : this._createSplitField();
    return groupByField ? [...this.getMetricFields(), groupByField] : this.getMetricFields();
  }
  getFieldByName(name) {
    if (name === this._descriptor.splitField) {
      return this._createSplitField();
    }
    if (name === _constants2.TIME_SERIES_ID_FIELD_NAME) {
      return this._createTsidField();
    }
    return this.getMetricFieldForName(name);
  }
  isGeoGridPrecisionAware() {
    return false;
  }
  supportsJoins() {
    return false;
  }
  async getGeoJsonWithMeta(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    if (!(0, _licensed_features.getIsGoldPlus)()) {
      throw new Error(REQUIRES_GOLD_LICENSE_MSG);
    }
    return this._descriptor.groupByTimeseries ? this._getGeoLineByTimeseries(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) : this._getGeoLineByTerms(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters);
  }
  getInspectorRequestIds() {
    return [this._getTracksRequestId(), this._getEntitiesRequestId()];
  }
  _getTracksRequestId() {
    return `${this.getId()}_tracks`;
  }
  _getEntitiesRequestId() {
    return `${this.getId()}_entities`;
  }
  async _getGeoLineByTimeseries(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    var _resp$aggregations$to, _resp$aggregations, _resp$aggregations$to2;
    const indexPattern = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    searchSource.setField('aggs', {
      totalEntities: {
        cardinality: {
          field: '_tsid'
        }
      },
      tracks: {
        time_series: {},
        aggs: {
          path: {
            geo_line: {
              point: {
                field: this._descriptor.geoField
              },
              size: this._descriptor.lineSimplificationSize
            }
          },
          ...this.getValueAggsDsl(indexPattern)
        }
      }
    });
    const warnings = [];
    const resp = await this._runEsQuery({
      requestId: this._getTracksRequestId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_geo_line:time_series_tracks'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const {
      featureCollection
    } = (0, _convert_to_geojson.convertToGeoJson)(resp, _constants2.TIME_SERIES_ID_FIELD_NAME);
    const entityCount = featureCollection.features.length;
    const areEntitiesTrimmed = entityCount >= 10000; // 10000 is max buckets created by time_series aggregation

    return {
      data: featureCollection,
      meta: {
        areResultsTrimmed: areEntitiesTrimmed,
        areEntitiesTrimmed,
        entityCount,
        numTrimmedTracks: 0,
        // geo_line by time series never truncates tracks and instead simplifies tracks
        totalEntities: (_resp$aggregations$to = resp === null || resp === void 0 ? void 0 : (_resp$aggregations = resp.aggregations) === null || _resp$aggregations === void 0 ? void 0 : (_resp$aggregations$to2 = _resp$aggregations.totalEntities) === null || _resp$aggregations$to2 === void 0 ? void 0 : _resp$aggregations$to2.value) !== null && _resp$aggregations$to !== void 0 ? _resp$aggregations$to : 0,
        warnings
      }
    };
  }
  async _getGeoLineByTerms(layerName, requestMeta, registerCancelCallback, isRequestStillActive, inspectorAdapters) {
    if (!this._descriptor.splitField) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esGeoLine.missingConfigurationError', {
        defaultMessage: `Unable to create tracks. Provide a value for required configuration ''{inputLabel}''`,
        values: {
          inputLabel: _geo_line_form.ENTITY_INPUT_LABEL
        }
      }));
    }
    if (!this._descriptor.sortField) {
      throw new Error(_i18n.i18n.translate('xpack.maps.source.esGeoLine.missingConfigurationError', {
        defaultMessage: `Unable to create tracks. Provide a value for required configuration ''{inputLabel}''`,
        values: {
          inputLabel: _geo_line_form.SORT_INPUT_LABEL
        }
      }));
    }
    const indexPattern = await this.getIndexPattern();
    const warnings = [];

    // Request is broken into 2 requests
    // 1) fetch entities: filtered by buffer so that top entities in view are returned
    // 2) fetch tracks: not filtered by buffer to avoid having invalid tracks
    //    when the track extends beyond the area of the map buffer.

    //
    // Fetch entities
    //
    const entitySearchSource = await this.makeSearchSource(requestMeta, 0);
    entitySearchSource.setField('trackTotalHits', false);
    const splitField = (0, _elasticsearch_util.getField)(indexPattern, this._descriptor.splitField);
    const cardinalityAgg = {
      precision_threshold: _constants2.MAX_TERMS_TRACKS
    };
    const termsAgg = {
      size: _constants2.MAX_TERMS_TRACKS
    };
    entitySearchSource.setField('aggs', {
      totalEntities: {
        cardinality: (0, _elasticsearch_util.addFieldToDSL)(cardinalityAgg, splitField)
      },
      entitySplit: {
        terms: (0, _elasticsearch_util.addFieldToDSL)(termsAgg, splitField)
      }
    });
    if (splitField.type === 'string') {
      const entityIsNotEmptyFilter = (0, _esQuery.buildPhraseFilter)(splitField, '', indexPattern);
      entityIsNotEmptyFilter.meta.negate = true;
      entitySearchSource.setField('filter', [...entitySearchSource.getField('filter'), entityIsNotEmptyFilter]);
    }
    const entityResp = await this._runEsQuery({
      requestId: this._getEntitiesRequestId(),
      requestName: _i18n.i18n.translate('xpack.maps.source.esGeoLine.entityRequestName', {
        defaultMessage: `load track entities ({layerName})`,
        values: {
          layerName
        }
      }),
      searchSource: entitySearchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_geo_line:entities'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const entityBuckets = _lodash.default.get(entityResp, 'aggregations.entitySplit.buckets', []);
    const totalEntities = _lodash.default.get(entityResp, 'aggregations.totalEntities.value', 0);
    const areEntitiesTrimmed = entityBuckets.length >= _constants2.MAX_TERMS_TRACKS;
    if (totalEntities === 0) {
      return {
        data: _constants.EMPTY_FEATURE_COLLECTION,
        meta: {
          areResultsTrimmed: false,
          areEntitiesTrimmed: false,
          entityCount: 0,
          numTrimmedTracks: 0,
          totalEntities: 0
        }
      };
    }

    //
    // Fetch tracks
    //
    const entityFilters = {};
    for (let i = 0; i < entityBuckets.length; i++) {
      entityFilters[entityBuckets[i].key] = (0, _esQuery.buildPhraseFilter)(splitField, entityBuckets[i].key, indexPattern).query;
    }
    const tracksSearchFilters = {
      ...requestMeta
    };
    delete tracksSearchFilters.buffer;
    const tracksSearchSource = await this.makeSearchSource(tracksSearchFilters, 0);
    tracksSearchSource.setField('trackTotalHits', false);
    tracksSearchSource.setField('aggs', {
      tracks: {
        filters: {
          filters: entityFilters
        },
        aggs: {
          path: {
            geo_line: {
              point: {
                field: this._descriptor.geoField
              },
              sort: {
                field: this._descriptor.sortField
              }
            }
          },
          ...this.getValueAggsDsl(indexPattern)
        }
      }
    });
    const tracksResp = await this._runEsQuery({
      requestId: this._getTracksRequestId(),
      requestName: (0, _vector_source.getLayerFeaturesRequestName)(layerName),
      searchSource: tracksSearchSource,
      registerCancelCallback,
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_geo_line:terms_tracks'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests,
      onWarning: warning => {
        warnings.push(warning);
      }
    });
    const {
      featureCollection,
      numTrimmedTracks
    } = (0, _convert_to_geojson.convertToGeoJson)(tracksResp, this._descriptor.splitField);
    return {
      data: featureCollection,
      meta: {
        // meta.areResultsTrimmed is used by updateDueToExtent to skip re-fetching results
        // when extent changes contained by original extent are not needed
        // Only trigger re-fetch when the number of entities are trimmed
        // Do not trigger re-fetch when tracks are trimmed since the tracks themselves are not filtered by map view extent.
        areResultsTrimmed: areEntitiesTrimmed,
        areEntitiesTrimmed,
        entityCount: entityBuckets.length,
        numTrimmedTracks,
        totalEntities,
        warnings
      }
    };
  }
  getSourceStatus(sourceDataRequest) {
    const featureCollection = sourceDataRequest ? sourceDataRequest.getData() : null;
    const meta = sourceDataRequest ? sourceDataRequest.getMeta() : null;
    if (!featureCollection || !meta) {
      // no tooltip content needed when there is no feature collection or meta
      return {
        tooltipContent: null,
        areResultsTrimmed: false
      };
    }
    const entitiesFoundMsg = meta.areEntitiesTrimmed ? _i18n.i18n.translate('xpack.maps.esGeoLine.areEntitiesTrimmedMsg', {
      defaultMessage: `Results limited to first {entityCount} tracks of ~{totalEntities}.`,
      values: {
        entityCount: meta.entityCount.toLocaleString(),
        totalEntities: meta.totalEntities.toLocaleString()
      }
    }) : _i18n.i18n.translate('xpack.maps.esGeoLine.tracksCountMsg', {
      defaultMessage: `Found {entityCount} tracks.`,
      values: {
        entityCount: meta.entityCount.toLocaleString()
      }
    });
    const tracksTrimmedMsg = meta.numTrimmedTracks > 0 ? _i18n.i18n.translate('xpack.maps.esGeoLine.tracksTrimmedMsg', {
      defaultMessage: `{numTrimmedTracks} of {entityCount} tracks are incomplete.`,
      values: {
        entityCount: meta.entityCount.toLocaleString(),
        numTrimmedTracks: meta.numTrimmedTracks.toLocaleString()
      }
    }) : undefined;
    return {
      tooltipContent: tracksTrimmedMsg ? `${entitiesFoundMsg} ${tracksTrimmedMsg}` : entitiesFoundMsg,
      // Used to show trimmed icon in legend. Trimmed icon signals the following
      // 1) number of entities are trimmed.
      // 2) one or more tracks are incomplete.
      areResultsTrimmed: meta.areEntitiesTrimmed || meta.numTrimmedTracks > 0
    };
  }
  isFilterByMapBounds() {
    return true;
  }
  hasTooltipProperties() {
    return true;
  }
  async getSupportedShapeTypes() {
    return [_constants.VECTOR_SHAPE_TYPE.LINE];
  }
  async getTooltipProperties(properties) {
    const tooltipProperties = await super.getTooltipProperties(properties);
    if (properties && typeof properties.complete === 'boolean') {
      tooltipProperties.push(new _tooltip_property.TooltipProperty('__kbn__track__complete', this._descriptor.groupByTimeseries ? _i18n.i18n.translate('xpack.maps.source.esGeoLine.isTrackSimplifiedLabel', {
        defaultMessage: 'track is simplified'
      }) : _i18n.i18n.translate('xpack.maps.source.esGeoLine.isTrackTruncatedLabel', {
        defaultMessage: 'track is truncated'
      }), (!properties.complete).toString()));
    }
    return tooltipProperties;
  }
  async getLicensedFeatures() {
    return [_licensed_features.LICENSED_FEATURES.GEO_LINE_AGG];
  }
}
exports.ESGeoLineSource = ESGeoLineSource;