"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardForm = WizardForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _index_pattern_util = require("../../../../../index_pattern_util");
var _left_source_panel = require("./left_source_panel");
var _right_source_panel = require("./right_source_panel");
var _create_spatial_join_layer_descriptor = require("./create_spatial_join_layer_descriptor");
var _join_sources = require("../../../../sources/join_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/spatial_join_wizard/wizard_form/wizard_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isLeftConfigComplete(leftDataView, leftGeoField) {
  return leftDataView !== undefined && leftDataView.id && leftGeoField !== undefined;
}
function isRightConfigComplete(rightDataView, rightGeoField) {
  return rightDataView !== undefined && rightDataView.id && rightGeoField !== undefined;
}
function WizardForm({
  previewLayers
}) {
  const [distance, setDistance] = (0, _react.useState)(_join_sources.DEFAULT_WITHIN_DISTANCE);
  const [leftDataView, setLeftDataView] = (0, _react.useState)();
  const [leftGeoFields, setLeftGeoFields] = (0, _react.useState)([]);
  const [leftGeoField, setLeftGeoField] = (0, _react.useState)();
  const [rightDataView, setRightDataView] = (0, _react.useState)();
  const [rightGeoFields, setRightGeoFields] = (0, _react.useState)([]);
  const [rightGeoField, setRightGeoField] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!isLeftConfigComplete(leftDataView, leftGeoField) || !isRightConfigComplete(rightDataView, rightGeoField)) {
      previewLayers([]);
      return;
    }
    const layerDescriptor = (0, _create_spatial_join_layer_descriptor.createDistanceJoinLayerDescriptor)({
      distance,
      leftDataViewId: leftDataView.id,
      // leftDataView.id verified in isLeftConfigComplete
      leftGeoField: leftGeoField,
      // leftGeoField verified in isLeftConfigComplete
      rightDataViewId: rightDataView.id,
      // rightDataView.id verified in isRightConfigComplete
      rightGeoField: rightGeoField // rightGeoField verified in isRightConfigComplete
    });
    previewLayers([layerDescriptor]);
  }, [distance, leftDataView, leftGeoField, rightDataView, rightGeoField, previewLayers]);
  const rightSourcePanel = isLeftConfigComplete(leftDataView, leftGeoField) ? /*#__PURE__*/_react.default.createElement(_right_source_panel.RightSourcePanel, {
    dataView: rightDataView,
    distance: distance,
    geoField: rightGeoField,
    geoFields: rightGeoFields,
    onDataViewSelect: dataView => {
      setRightDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoFields)(dataView.fields);
      setRightGeoFields(geoFields);
      setRightGeoField(geoFields.length ? geoFields[0].name : undefined);
    },
    onDistanceChange: setDistance,
    onGeoFieldSelect: setRightGeoField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_left_source_panel.LeftSourcePanel, {
    dataView: leftDataView,
    geoField: leftGeoField,
    geoFields: leftGeoFields,
    onDataViewSelect: dataView => {
      setLeftDataView(dataView);
      const geoFields = (0, _index_pattern_util.getGeoPointFields)(dataView.fields);
      setLeftGeoFields(geoFields);
      setLeftGeoField(geoFields.length ? geoFields[0].name : undefined);
    },
    onGeoFieldSelect: setLeftGeoField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), rightSourcePanel);
}