"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksEditorSingleLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("./constants");
var _links_strings = require("../links_strings");
var _dashboard_link_strings = require("../dashboard_link/dashboard_link_strings");
var _content_management = require("../../../common/content_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/editor/links_editor_single_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinksEditorSingleLink = ({
  link,
  editLink,
  deleteLink,
  dragHandleProps
}) => {
  const LinkLabel = (0, _react.useMemo)(() => {
    const labelText = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      tabIndex: 0,
      gutterSize: "s",
      responsive: false,
      wrap: false,
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: link.error ? 'warning' : _constants.LinkInfo[link.type].icon,
      color: link.error ? 'warning' : 'text',
      "aria-label": link.error ? _links_strings.LinksStrings.editor.panelEditor.getBrokenDashboardLinkAriaLabel() : _constants.LinkInfo[link.type].type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: 'linksPanelEditorLinkText',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: 'default',
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, link.label || link.title)));
    return () => link.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: link.error.message,
      title: link.type === _content_management.DASHBOARD_LINK_TYPE ? _dashboard_link_strings.DashboardLinkStrings.getDashboardErrorLabel() : undefined // the messages thrown by an invalid URL are clear enough without an extra title
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }, labelText) : labelText;
  }, [link]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    css: styles,
    hasShadow: false,
    color: link.error ? 'warning' : 'plain',
    className: `linksPanelEditorLink ${link.error ? 'linkError' : ''}`,
    "data-test-subj": `panelEditorLink`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "none"
  }, dragHandleProps, {
    "aria-label": _links_strings.LinksStrings.editor.panelEditor.getDragHandleAriaLabel(),
    "data-test-subj": "panelEditorLink--dragHandle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "linksPanelEditorLinkText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(LinkLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    className: "links_hoverActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _links_strings.LinksStrings.editor.getEditLinkTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "pencil",
    onClick: editLink,
    "aria-label": _links_strings.LinksStrings.editor.getEditLinkTitle(link.title),
    "data-test-subj": "panelEditorLink--editBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _links_strings.LinksStrings.editor.getDeleteLinkTitle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "trash",
    "aria-label": _links_strings.LinksStrings.editor.getDeleteLinkTitle(link.title),
    color: "danger",
    onClick: deleteLink,
    "data-test-subj": "panelEditorLink--deleteBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }))))));
};
exports.LinksEditorSingleLink = LinksEditorSingleLink;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  padding: `${euiTheme.size.xs} ${euiTheme.size.s}`,
  color: euiTheme.colors.textParagraph,
  '.linksPanelEditorLinkText': {
    flex: 1,
    minWidth: 0
  },
  '&.linkError': {
    border: `1px solid ${(0, _eui.transparentize)(euiTheme.colors.textWarning, 0.3)}`,
    color: euiTheme.colors.textWarning
  },
  '& .links_hoverActions': {
    position: 'absolute',
    right: euiTheme.size.l,
    opacity: 0,
    visibility: 'hidden',
    transition: `visibility ${euiTheme.animation.normal}, opacity ${euiTheme.animation.normal}`
  },
  '&:hover .links_hoverActions, &:focus-within .links_hoverActions ': {
    opacity: 1,
    visibility: 'visible'
  }
});