"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardLinkDestinationPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _dashboard_link_strings = require("./dashboard_link_strings");
var _dashboard_link_tools = require("./dashboard_link_tools");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/links/public/components/dashboard_link/dashboard_link_destination_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardLinkDestinationPicker = ({
  onDestinationPicked,
  initialSelection,
  parentDashboardId,
  onUnmount,
  ...other
}) => {
  const [searchString, setSearchString] = (0, _react.useState)('');
  const [selectedOption, setSelectedOption] = (0, _react.useState)([]);
  const getDashboardItem = (0, _react.useCallback)(dashboard => {
    return {
      key: dashboard.id,
      value: dashboard,
      label: dashboard.attributes.title,
      className: 'linksDashboardItem'
    };
  }, []);
  (0, _useMount.default)(async () => {
    if (initialSelection) {
      const dashboard = await (0, _dashboard_link_tools.fetchDashboard)(initialSelection).catch(() => {
        /**
         * Swallow the error that is thrown, since this just means the selected dashboard was deleted and
         * so we should treat this the same as "no previous selection."
         */
      });
      if (dashboard) {
        onDestinationPicked(dashboard);
        setSelectedOption([getDashboardItem(dashboard)]);
      } else {
        onDestinationPicked(undefined);
      }
    }
  });
  (0, _useUnmount.default)(() => {
    var _selectedOption$;
    /** Save the current selection so we can re-populate it if we switch back to this link editor */
    onUnmount((_selectedOption$ = selectedOption[0]) === null || _selectedOption$ === void 0 ? void 0 : _selectedOption$.key);
  });
  const {
    loading: loadingDashboardList,
    value: dashboardList
  } = (0, _useAsync.default)(async () => {
    const dashboards = await (0, _dashboard_link_tools.fetchDashboards)({
      search: searchString,
      parentDashboardId,
      selectedDashboardId: initialSelection
    });
    const dashboardOptions = (dashboards !== null && dashboards !== void 0 ? dashboards : []).map(dashboard => {
      return getDashboardItem(dashboard);
    });
    return dashboardOptions;
  }, [searchString, parentDashboardId, getDashboardItem]);
  const debouncedSetSearch = (0, _react.useMemo)(() => (0, _lodash.debounce)(newSearch => {
    setSearchString(newSearch);
  }, 250), [setSearchString]);
  const renderOption = (0, _react.useCallback)((option, searchValue, contentClassName) => {
    const {
      label,
      key: dashboardId
    } = option;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }, dashboardId === parentDashboardId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: 'linksDashboardItem--current',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, _dashboard_link_strings.DashboardLinkStrings.getCurrentDashboardLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: 'linksPanelEditorLinkText',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: 'wrapText',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, label)));
  }, [parentDashboardId]);

  /* {...other} is needed so the EuiComboBox is treated as part of the form */
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, other, {
    compressed: true,
    async: true,
    fullWidth: true,
    className: 'linksDashboardPicker',
    isLoading: loadingDashboardList,
    "aria-label": _dashboard_link_strings.DashboardLinkStrings.getDashboardPickerAriaLabel(),
    placeholder: _dashboard_link_strings.DashboardLinkStrings.getDashboardPickerPlaceholder(),
    singleSelection: {
      asPlainText: true
    },
    options: dashboardList,
    onSearchChange: searchValue => {
      debouncedSetSearch(searchValue);
    },
    renderOption: renderOption,
    selectedOptions: selectedOption,
    onChange: option => {
      setSelectedOption(option);
      if (option.length > 0) {
        // single select is `true`, so there is only ever one item in the array
        onDestinationPicked(option[0].value);
      } else {
        onDestinationPicked(undefined);
      }
    },
    "data-test-subj": "links--linkEditor--dashboardLink--comboBox",
    inputPopoverProps: {
      panelProps: {
        css: styles
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }));
};
exports.DashboardLinkDestinationPicker = DashboardLinkDestinationPicker;
const styles = (0, _react2.css)({
  '.linksDashboardItem': {
    '.linksDashboardItem--current': {
      cursor: 'pointer !important'
    },
    // in order to ensure that the "Current" badge doesn't recieve an underline on hover, we have to set the
    // text-decoration to `none` for the entire list item and manually set the underline **only** on the text
    '&:hover': {
      textDecoration: 'none !important'
    },
    '.linksPanelEditorLinkText': {
      '&:hover': {
        textDecoration: 'underline !important'
      }
    }
  }
});