"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XyToolbar = void 0;
exports.updateLayer = updateLayer;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _constants = require("@kbn/visualizations-plugin/common/constants");
var _state_helpers = require("../state_helpers");
var _shared_components = require("../../../shared_components");
var _axis_settings_popover = require("./axis_settings_popover");
var _axes_configuration = require("../axes_configuration");
var _visual_options_popover = require("./visual_options_popover");
var _titles_and_text_popover = require("./titles_and_text_popover");
var _to_expression = require("../to_expression");
var _datasource_default_values = require("../../../shared_components/datasource_default_values");
var _visualization_helpers = require("../visualization_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function updateLayer(state, layer, index) {
  return {
    ...state,
    layers: state.layers.map((l, i) => i === index ? layer : l)
  };
}
const legendOptions = [{
  id: `xy_legend_auto`,
  value: 'auto',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: `xy_legend_show`,
  value: 'show',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: `xy_legend_hide`,
  value: 'hide',
  label: _i18n.i18n.translate('xpack.lens.xyChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const getDataBounds = function (activeData, axes) {
  const groups = {};
  axes.forEach(axis => {
    let min = Number.MAX_SAFE_INTEGER;
    let max = -Number.MAX_SAFE_INTEGER;
    axis.series.forEach(series => {
      var _activeData$series$la;
      activeData === null || activeData === void 0 ? void 0 : (_activeData$series$la = activeData[series.layer]) === null || _activeData$series$la === void 0 ? void 0 : _activeData$series$la.rows.forEach(row => {
        const value = row[series.accessor];
        // TODO: add tests for null value
        if (value !== null && Number.isFinite(value)) {
          if (value < min) {
            min = value;
          }
          if (value > max) {
            max = value;
          }
        }
      });
    });
    if (min !== Number.MAX_SAFE_INTEGER && max !== -Number.MAX_SAFE_INTEGER) {
      groups[axis.groupId] = {
        min: Math.round((min + Number.EPSILON) * 100) / 100,
        max: Math.round((max + Number.EPSILON) * 100) / 100
      };
    }
  });
  return groups;
};
function hasPercentageAxis(axisGroups, groupId, state) {
  var _axisGroups$find;
  return Boolean((_axisGroups$find = axisGroups.find(group => group.groupId === groupId)) === null || _axisGroups$find === void 0 ? void 0 : _axisGroups$find.series.some(({
    layer: layerId
  }) => (0, _visualization_helpers.getDataLayers)(state === null || state === void 0 ? void 0 : state.layers).find(layer => layer.layerId === layerId && layer.seriesType.includes('percentage'))));
}
const axisKeyToTitleMapping = {
  x: 'xTitle',
  yLeft: 'yTitle',
  yRight: 'yRightTitle'
};
const xyLegendValues = [{
  value: _charts.LegendValue.Average,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.average', {
    defaultMessage: 'Average'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.averageDesc', {
    defaultMessage: 'Average of all values in the series.'
  })
}, {
  value: _charts.LegendValue.Median,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.median', {
    defaultMessage: 'Median'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.medianDesc', {
    defaultMessage: 'Median value in the series.'
  })
}, {
  value: _charts.LegendValue.Min,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.min', {
    defaultMessage: 'Minimum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.minDesc', {
    defaultMessage: 'Minimum value in the series.'
  })
}, {
  value: _charts.LegendValue.Max,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.max', {
    defaultMessage: 'Maximum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.maxDesc', {
    defaultMessage: 'Maximum value in the series.'
  })
}, {
  value: _charts.LegendValue.Range,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.range', {
    defaultMessage: 'Range'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.rangeDesc', {
    defaultMessage: 'Difference between the min and the max in the series.'
  })
}, {
  value: _charts.LegendValue.LastValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastValue', {
    defaultMessage: 'Last value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastValueDesc', {
    defaultMessage: 'Last value in the series.'
  })
}, {
  value: _charts.LegendValue.LastNonNullValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastNonNullValue', {
    defaultMessage: 'Last non-null value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.lastNonNullValueDesc', {
    defaultMessage: 'Last non-null value in the series.'
  })
}, {
  value: _charts.LegendValue.FirstValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstValue', {
    defaultMessage: 'First value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstValueDesc', {
    defaultMessage: 'First value in the series.'
  })
}, {
  value: _charts.LegendValue.FirstNonNullValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstNonNullValue', {
    defaultMessage: 'First non-null value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.firstNonNullValueDesc', {
    defaultMessage: 'First non-null value in the series.'
  })
}, {
  value: _charts.LegendValue.Difference,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.diff', {
    defaultMessage: 'Difference'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffDesc', {
    defaultMessage: 'Difference between first and last value in the series.'
  })
}, {
  value: _charts.LegendValue.DifferencePercent,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffPercent', {
    defaultMessage: 'Difference %'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.diffPercentDesc', {
    defaultMessage: 'Difference in percent between first and last value in the series.'
  })
}, {
  value: _charts.LegendValue.Total,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.total', {
    defaultMessage: 'Sum'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.totalDesc', {
    defaultMessage: 'The sum of all values in the series.'
  })
}, {
  value: _charts.LegendValue.Count,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.count', {
    defaultMessage: 'Count'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.countDesc', {
    defaultMessage: 'Count of all the values in the series.'
  })
}, {
  value: _charts.LegendValue.DistinctCount,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.distinctCount', {
    defaultMessage: 'Distinct count'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.distinctCountDesc', {
    defaultMessage: 'Count of distinct values in the series.'
  })
}, {
  value: _charts.LegendValue.Variance,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.variance', {
    defaultMessage: 'Variance'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.varianceDesc', {
    defaultMessage: 'Variance of all the values in the series.'
  })
}, {
  value: _charts.LegendValue.StdDeviation,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.stdDev', {
    defaultMessage: 'Std deviation'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.stdDevDesc', {
    defaultMessage: 'Standard deviation of all the values in the series.'
  })
},
// Moved to the bottom to limit its usage. It could cause some UX issues due to the dynamic nature
// of the data displayed
{
  value: _charts.LegendValue.CurrentAndLastValue,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.currentValue', {
    defaultMessage: 'Current or last value'
  }),
  toolTipContent: _i18n.i18n.translate('xpack.lens.shared.legendValues.currentValueDesc', {
    defaultMessage: 'Value of the bucket being hovered or the last bucket value when not hovering.'
  })
}];
const defaultLegendTitle = _i18n.i18n.translate('xpack.lens.xyChart.legendTitle', {
  defaultMessage: 'Legend'
});
const XyToolbar = exports.XyToolbar = /*#__PURE__*/(0, _react.memo)(function XyToolbar(props) {
  var _state$tickLabelsVisi, _state$tickLabelsVisi2, _state$tickLabelsVisi3, _state$tickLabelsVisi4, _state$tickLabelsVisi5, _state$tickLabelsVisi6, _state$gridlinesVisib, _state$gridlinesVisib2, _state$gridlinesVisib3, _state$gridlinesVisib4, _state$gridlinesVisib5, _state$gridlinesVisib6, _state$labelsOrientat, _state$labelsOrientat2, _state$labelsOrientat3, _state$labelsOrientat4, _state$labelsOrientat5, _state$labelsOrientat6, _state$axisTitlesVisi7, _state$axisTitlesVisi8, _state$axisTitlesVisi9, _axisGroups$find2, _axisGroups$find2$ser, _axisGroups$find3, _axisGroups$find3$ser, _frame$activeData$dat, _frame$activeData, _frame$activeData$dat2, _frame$activeData$dat3, _state$legend$shouldT;
  const {
    state,
    setState,
    frame
  } = props;
  const dataLayers = (0, _visualization_helpers.getDataLayers)(state === null || state === void 0 ? void 0 : state.layers);
  const shouldRotate = state !== null && state !== void 0 && state.layers.length ? (0, _state_helpers.isHorizontalChart)(state.layers) : false;
  const axisGroups = (0, _axes_configuration.getAxesConfiguration)(dataLayers, shouldRotate, frame.activeData);
  const dataBounds = getDataBounds(frame.activeData, axisGroups);
  const xDataBounds = (0, _axes_configuration.getXDomain)(dataLayers, frame.activeData);
  const tickLabelsVisibilitySettings = {
    x: (_state$tickLabelsVisi = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi2 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi2 === void 0 ? void 0 : _state$tickLabelsVisi2.x) !== null && _state$tickLabelsVisi !== void 0 ? _state$tickLabelsVisi : true,
    yLeft: (_state$tickLabelsVisi3 = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi4 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi4 === void 0 ? void 0 : _state$tickLabelsVisi4.yLeft) !== null && _state$tickLabelsVisi3 !== void 0 ? _state$tickLabelsVisi3 : true,
    yRight: (_state$tickLabelsVisi5 = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi6 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi6 === void 0 ? void 0 : _state$tickLabelsVisi6.yRight) !== null && _state$tickLabelsVisi5 !== void 0 ? _state$tickLabelsVisi5 : true
  };
  const onTickLabelsVisibilitySettingsChange = optionId => {
    const newTickLabelsVisibilitySettings = {
      ...tickLabelsVisibilitySettings,
      ...{
        [optionId]: !tickLabelsVisibilitySettings[optionId]
      }
    };
    setState({
      ...state,
      tickLabelsVisibilitySettings: newTickLabelsVisibilitySettings
    });
  };
  const gridlinesVisibilitySettings = {
    x: (_state$gridlinesVisib = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib2 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib2 === void 0 ? void 0 : _state$gridlinesVisib2.x) !== null && _state$gridlinesVisib !== void 0 ? _state$gridlinesVisib : true,
    yLeft: (_state$gridlinesVisib3 = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib4 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib4 === void 0 ? void 0 : _state$gridlinesVisib4.yLeft) !== null && _state$gridlinesVisib3 !== void 0 ? _state$gridlinesVisib3 : true,
    yRight: (_state$gridlinesVisib5 = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib6 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib6 === void 0 ? void 0 : _state$gridlinesVisib6.yRight) !== null && _state$gridlinesVisib5 !== void 0 ? _state$gridlinesVisib5 : true
  };
  const onGridlinesVisibilitySettingsChange = optionId => {
    const newGridlinesVisibilitySettings = {
      ...gridlinesVisibilitySettings,
      ...{
        [optionId]: !gridlinesVisibilitySettings[optionId]
      }
    };
    setState({
      ...state,
      gridlinesVisibilitySettings: newGridlinesVisibilitySettings
    });
  };
  const labelsOrientation = {
    x: (_state$labelsOrientat = state === null || state === void 0 ? void 0 : (_state$labelsOrientat2 = state.labelsOrientation) === null || _state$labelsOrientat2 === void 0 ? void 0 : _state$labelsOrientat2.x) !== null && _state$labelsOrientat !== void 0 ? _state$labelsOrientat : 0,
    yLeft: (_state$labelsOrientat3 = state === null || state === void 0 ? void 0 : (_state$labelsOrientat4 = state.labelsOrientation) === null || _state$labelsOrientat4 === void 0 ? void 0 : _state$labelsOrientat4.yLeft) !== null && _state$labelsOrientat3 !== void 0 ? _state$labelsOrientat3 : 0,
    yRight: (_state$labelsOrientat5 = state === null || state === void 0 ? void 0 : (_state$labelsOrientat6 = state.labelsOrientation) === null || _state$labelsOrientat6 === void 0 ? void 0 : _state$labelsOrientat6.yRight) !== null && _state$labelsOrientat5 !== void 0 ? _state$labelsOrientat5 : 0
  };
  const onLabelsOrientationChange = (axis, orientation) => {
    const newLabelsOrientation = {
      ...labelsOrientation,
      ...{
        [axis]: orientation
      }
    };
    setState({
      ...state,
      labelsOrientation: newLabelsOrientation
    });
  };
  const axisTitlesVisibilitySettings = (0, _react.useMemo)(() => {
    var _state$axisTitlesVisi, _state$axisTitlesVisi2, _state$axisTitlesVisi3, _state$axisTitlesVisi4, _state$axisTitlesVisi5, _state$axisTitlesVisi6;
    return {
      x: (_state$axisTitlesVisi = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi2 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi2 === void 0 ? void 0 : _state$axisTitlesVisi2.x) !== null && _state$axisTitlesVisi !== void 0 ? _state$axisTitlesVisi : true,
      yLeft: (_state$axisTitlesVisi3 = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi4 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi4 === void 0 ? void 0 : _state$axisTitlesVisi4.yLeft) !== null && _state$axisTitlesVisi3 !== void 0 ? _state$axisTitlesVisi3 : true,
      yRight: (_state$axisTitlesVisi5 = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi6 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi6 === void 0 ? void 0 : _state$axisTitlesVisi6.yRight) !== null && _state$axisTitlesVisi5 !== void 0 ? _state$axisTitlesVisi5 : true
    };
  }, [state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi7 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi7 === void 0 ? void 0 : _state$axisTitlesVisi7.x, state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi8 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi8 === void 0 ? void 0 : _state$axisTitlesVisi8.yLeft, state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi9 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi9 === void 0 ? void 0 : _state$axisTitlesVisi9.yRight]);
  const onTitleStateChange = (0, _react.useCallback)(({
    title,
    visible
  }, axis) => setState({
    ...state,
    [axisKeyToTitleMapping[axis]]: title,
    axisTitlesVisibilitySettings: {
      ...axisTitlesVisibilitySettings,
      [axis]: visible
    }
  }), [axisTitlesVisibilitySettings, setState, state]);
  const nonOrdinalXAxis = dataLayers.every(layer => {
    var _props$frame$datasour, _props$frame$datasour2;
    return layer.xAccessor && (0, _to_expression.getScaleType)((_props$frame$datasour = (_props$frame$datasour2 = props.frame.datasourceLayers[layer.layerId]) === null || _props$frame$datasour2 === void 0 ? void 0 : _props$frame$datasour2.getOperationForColumnId(layer.xAccessor)) !== null && _props$frame$datasour !== void 0 ? _props$frame$datasour : null, _charts.ScaleType.Linear) !== 'ordinal';
  });
  const isTimeVis = dataLayers.every(layer => {
    var _props$frame$datasour3, _props$frame$datasour4;
    return layer.xAccessor && (0, _to_expression.getScaleType)((_props$frame$datasour3 = (_props$frame$datasour4 = props.frame.datasourceLayers[layer.layerId]) === null || _props$frame$datasour4 === void 0 ? void 0 : _props$frame$datasour4.getOperationForColumnId(layer.xAccessor)) !== null && _props$frame$datasour3 !== void 0 ? _props$frame$datasour3 : null, _charts.ScaleType.Linear) === _charts.ScaleType.Time;
  });

  // only allow changing endzone visibility if it could show up theoretically (if it's a time viz)
  const onChangeEndzoneVisiblity = isTimeVis ? checked => {
    setState({
      ...state,
      hideEndzones: !checked
    });
  } : undefined;
  const onChangeCurrentTimeMarkerVisibility = isTimeVis ? checked => {
    setState({
      ...state,
      showCurrentTimeMarker: checked
    });
  } : undefined;
  const legendMode = state !== null && state !== void 0 && state.legend.isVisible && !(state !== null && state !== void 0 && state.legend.showSingleSeries) ? 'auto' : !(state !== null && state !== void 0 && state.legend.isVisible) ? 'hide' : 'show';
  const hasBarOrAreaOnLeftAxis = Boolean((_axisGroups$find2 = axisGroups.find(group => group.groupId === 'left')) === null || _axisGroups$find2 === void 0 ? void 0 : (_axisGroups$find2$ser = _axisGroups$find2.series) === null || _axisGroups$find2$ser === void 0 ? void 0 : _axisGroups$find2$ser.some(series => {
    var _dataLayers$find;
    const seriesType = (_dataLayers$find = dataLayers.find(l => l.layerId === series.layer)) === null || _dataLayers$find === void 0 ? void 0 : _dataLayers$find.seriesType;
    return (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('bar')) || (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('area'));
  }));
  const setScaleWithExtentFn = (0, _react.useCallback)((extentKey, scaleKey) => (extent, scale) => {
    setState({
      ...state,
      [extentKey]: extent,
      [scaleKey]: scale
    });
  }, [setState, state]);
  const setExtentFn = (0, _react.useCallback)(extentKey => extent => {
    setState({
      ...state,
      [extentKey]: extent
    });
  }, [setState, state]);
  const setScaleFn = (0, _react.useCallback)(scaleKey => scale => {
    setState({
      ...state,
      [scaleKey]: scale
    });
  }, [setState, state]);
  const hasBarOrAreaOnRightAxis = Boolean((_axisGroups$find3 = axisGroups.find(group => group.groupId === 'right')) === null || _axisGroups$find3 === void 0 ? void 0 : (_axisGroups$find3$ser = _axisGroups$find3.series) === null || _axisGroups$find3$ser === void 0 ? void 0 : _axisGroups$find3$ser.some(series => {
    var _dataLayers$find2;
    const seriesType = (_dataLayers$find2 = dataLayers.find(l => l.layerId === series.layer)) === null || _dataLayers$find2 === void 0 ? void 0 : _dataLayers$find2.seriesType;
    return (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('bar')) || (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('area'));
  }));
  const filteredBarLayers = dataLayers.filter(layer => layer.seriesType.includes('bar'));
  const chartHasMoreThanOneBarSeries = filteredBarLayers.length > 1 || filteredBarLayers.some(layer => layer.accessors.length > 1 || layer.splitAccessor);
  const isTimeHistogramModeEnabled = dataLayers.some(({
    xAccessor,
    layerId,
    seriesType,
    splitAccessor
  }) => {
    var _props$frame$datasour5, _props$frame$datasour6;
    if (!xAccessor) {
      return false;
    }
    const xAccessorOp = (_props$frame$datasour5 = (_props$frame$datasour6 = props.frame.datasourceLayers[layerId]) === null || _props$frame$datasour6 === void 0 ? void 0 : _props$frame$datasour6.getOperationForColumnId(xAccessor)) !== null && _props$frame$datasour5 !== void 0 ? _props$frame$datasour5 : null;
    return (0, _to_expression.getScaleType)(xAccessorOp, _charts.ScaleType.Linear) === _charts.ScaleType.Time && (xAccessorOp === null || xAccessorOp === void 0 ? void 0 : xAccessorOp.isBucketed) && (seriesType.includes('stacked') || !splitAccessor) && (seriesType.includes('stacked') || !seriesType.includes('bar') || !chartHasMoreThanOneBarSeries);
  });
  const hasNumberHistogram = dataLayers.some(({
    layerId,
    xAccessor
  }) => (0, _shared_components.hasNumericHistogramDimension)(props.frame.datasourceLayers[layerId], xAccessor));

  // Ask the datasource if it has a say about default truncation value
  const defaultParamsFromDatasources = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, props.frame.datasourceLayers).truncateText;
  const legendSize = state.legend.legendSize;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_visual_options_popover.VisualOptionsPopover, {
    state: state,
    setState: setState,
    datasourceLayers: frame.datasourceLayers,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 511,
      columnNumber: 9
    }
  })), (0, _state_helpers.hasBarSeries)(state.layers) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_titles_and_text_popover.TextPopover, {
    state: state,
    setState: setState,
    datasourceLayers: frame.datasourceLayers,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: shouldRotate ? _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when bottom axis is enabled.'
    }) : _i18n.i18n.translate('xpack.lens.xyChart.leftAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when left axis is enabled.'
    }),
    condition: Object.keys(axisGroups.find(group => group.groupId === 'left') || {}).length === 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 529,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_axis_settings_popover.AxisSettingsPopover, {
    axis: "yLeft",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.yTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.yLeft,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.yLeft,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    isDisabled: Object.keys(axisGroups.find(group => group.groupId === 'left') || {}).length === 0,
    orientation: labelsOrientation.yLeft,
    setOrientation: onLabelsOrientationChange,
    isTitleVisible: axisTitlesVisibilitySettings.yLeft,
    extent: (state === null || state === void 0 ? void 0 : state.yLeftExtent) || {
      mode: 'full'
    },
    setExtent: setExtentFn('yLeftExtent'),
    hasBarOrAreaOnAxis: hasBarOrAreaOnLeftAxis,
    dataBounds: dataBounds.left,
    hasPercentageAxis: hasPercentageAxis(axisGroups, 'left', state),
    scale: state === null || state === void 0 ? void 0 : state.yLeftScale,
    setScale: setScaleFn('yLeftScale'),
    setScaleWithExtent: setScaleWithExtentFn('yLeftExtent', 'yLeftScale'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 543,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_axis_settings_popover.AxisSettingsPopover, {
    axis: "x",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.xTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.x,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.x,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    orientation: labelsOrientation.x,
    setOrientation: onLabelsOrientationChange,
    isTitleVisible: axisTitlesVisibilitySettings.x,
    endzonesVisible: !(state !== null && state !== void 0 && state.hideEndzones),
    setEndzoneVisibility: onChangeEndzoneVisiblity,
    currentTimeMarkerVisible: state === null || state === void 0 ? void 0 : state.showCurrentTimeMarker,
    setCurrentTimeMarkerVisibility: onChangeCurrentTimeMarkerVisibility,
    hasBarOrAreaOnAxis: false,
    hasPercentageAxis: false,
    useMultilayerTimeAxis: isTimeHistogramModeEnabled && !shouldRotate,
    extent: hasNumberHistogram ? (state === null || state === void 0 ? void 0 : state.xExtent) || {
      mode: 'dataBounds'
    } : undefined,
    setExtent: setExtentFn('xExtent'),
    dataBounds: xDataBounds,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 569,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: shouldRotate ? _i18n.i18n.translate('xpack.lens.xyChart.topAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when top axis is enabled.'
    }) : _i18n.i18n.translate('xpack.lens.xyChart.rightAxisDisabledHelpText', {
      defaultMessage: 'This setting only applies when right axis is enabled.'
    }),
    condition: Object.keys(axisGroups.find(group => group.groupId === 'right') || {}).length === 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_axis_settings_popover.AxisSettingsPopover, {
    axis: "yRight",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.yRightTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.yRight,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.yRight,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    isDisabled: Object.keys(axisGroups.find(group => group.groupId === 'right') || {}).length === 0,
    orientation: labelsOrientation.yRight,
    setOrientation: onLabelsOrientationChange,
    hasPercentageAxis: hasPercentageAxis(axisGroups, 'right', state),
    isTitleVisible: axisTitlesVisibilitySettings.yRight,
    extent: (state === null || state === void 0 ? void 0 : state.yRightExtent) || {
      mode: 'full'
    },
    setExtent: setExtentFn('yRightExtent'),
    hasBarOrAreaOnAxis: hasBarOrAreaOnRightAxis,
    dataBounds: dataBounds.right,
    scale: state === null || state === void 0 ? void 0 : state.yRightScale,
    setScale: setScaleFn('yRightScale'),
    setScaleWithExtent: setScaleWithExtentFn('yRightExtent', 'yRightScale'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 607,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettingsPopover, {
    legendOptions: legendOptions,
    mode: legendMode,
    location: state !== null && state !== void 0 && state.legend.isInside ? 'inside' : 'outside',
    onLocationChange: location => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          isInside: location === 'inside'
        }
      });
    },
    titlePlaceholder: (_frame$activeData$dat = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$dat2 = _frame$activeData[dataLayers[0].layerId]) === null || _frame$activeData$dat2 === void 0 ? void 0 : (_frame$activeData$dat3 = _frame$activeData$dat2.columns.find(col => col.id === dataLayers[0].splitAccessor)) === null || _frame$activeData$dat3 === void 0 ? void 0 : _frame$activeData$dat3.name) !== null && _frame$activeData$dat !== void 0 ? _frame$activeData$dat : defaultLegendTitle,
    legendTitle: state === null || state === void 0 ? void 0 : state.legend.title,
    onLegendTitleChange: ({
      title,
      visible
    }) => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          title,
          isTitleVisible: visible
        }
      });
    },
    isTitleVisible: state === null || state === void 0 ? void 0 : state.legend.isTitleVisible,
    onDisplayChange: optionId => {
      const newMode = legendOptions.find(({
        id
      }) => id === optionId).value;
      setState({
        ...state,
        legend: {
          ...state.legend,
          isVisible: newMode !== 'hide',
          showSingleSeries: newMode === 'show'
        }
      });
    },
    position: state === null || state === void 0 ? void 0 : state.legend.position,
    horizontalAlignment: state === null || state === void 0 ? void 0 : state.legend.horizontalAlignment,
    verticalAlignment: state === null || state === void 0 ? void 0 : state.legend.verticalAlignment,
    floatingColumns: state === null || state === void 0 ? void 0 : state.legend.floatingColumns,
    onFloatingColumnsChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          floatingColumns: val
        }
      });
    },
    maxLines: state === null || state === void 0 ? void 0 : state.legend.maxLines,
    onMaxLinesChange: val => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          maxLines: val
        }
      });
    },
    shouldTruncate: (_state$legend$shouldT = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT !== void 0 ? _state$legend$shouldT : defaultParamsFromDatasources,
    onTruncateLegendChange: () => {
      var _state$legend$shouldT2;
      const current = (_state$legend$shouldT2 = state === null || state === void 0 ? void 0 : state.legend.shouldTruncate) !== null && _state$legend$shouldT2 !== void 0 ? _state$legend$shouldT2 : defaultParamsFromDatasources;
      setState({
        ...state,
        legend: {
          ...state.legend,
          shouldTruncate: !current
        }
      });
    },
    onPositionChange: id => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          position: id
        }
      });
    },
    onAlignmentChange: value => {
      const [vertical, horizontal] = value.split('_');
      const verticalAlignment = vertical;
      const horizontalAlignment = horizontal;
      setState({
        ...state,
        legend: {
          ...state.legend,
          verticalAlignment,
          horizontalAlignment
        }
      });
    },
    allowedLegendStats: nonOrdinalXAxis ? xyLegendValues : undefined,
    legendStats: state === null || state === void 0 ? void 0 : state.legend.legendStats,
    onLegendStatsChange: (legendStats, hasConvertedToTable) => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendStats,
          isVisible: true,
          showSingleSeries: true,
          ...(hasConvertedToTable ? {
            legendSize: _constants.LegendSize.AUTO
          } : {})
        }
      });
    },
    legendSize: legendSize,
    onLegendSizeChange: newLegendSize => {
      setState({
        ...state,
        legend: {
          ...state.legend,
          legendSize: newLegendSize
        }
      });
    },
    showAutoLegendSizeOption: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 637,
      columnNumber: 9
    }
  })));
});