"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsDimensionEditor = TagsDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _visualizationUtils = require("@kbn/visualization-utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _utils = require("../../../common/expressions/impl/datatable/utils");
var _color_mapping_by_terms = require("../../shared_components/coloring/color_mapping_by_terms");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/tagcloud/tags_dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TagsDimensionEditor({
  state,
  frame,
  setState,
  panelRef,
  isDarkMode,
  palettes,
  paletteService,
  isInlineEditing,
  formatFactory
}) {
  var _frame$activeData, _getDatatableColumn, _getDatatableColumn$m;
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: state,
    onChange: setState
  });
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];
  const formatter = !state.tagAccessor ? undefined : formatFactory((_getDatatableColumn = (0, _utils.getDatatableColumn)(currentData, state.tagAccessor)) === null || _getDatatableColumn === void 0 ? void 0 : (_getDatatableColumn$m = _getDatatableColumn.meta) === null || _getDatatableColumn$m === void 0 ? void 0 : _getDatatableColumn$m.params);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    setLocalState({
      ...localState,
      colorMapping
    });
  }, [localState, setLocalState]);
  const setPalette = (0, _react.useCallback)(palette => {
    setLocalState({
      ...localState,
      palette,
      colorMapping: undefined
    });
  }, [localState, setLocalState]);
  const categories = (0, _react.useMemo)(() => {
    return (0, _chartExpressionsCommon.getColorCategories)(currentData === null || currentData === void 0 ? void 0 : currentData.rows, state.tagAccessor);
  }, [currentData === null || currentData === void 0 ? void 0 : currentData.rows, state.tagAccessor]);
  return /*#__PURE__*/_react.default.createElement(_color_mapping_by_terms.ColorMappingByTerms, {
    isDarkMode: isDarkMode,
    panelRef: panelRef,
    palettes: palettes,
    palette: state.palette,
    setPalette: setPalette,
    colorMapping: state.colorMapping,
    setColorMapping: setColorMapping,
    categories: categories,
    paletteService: paletteService,
    formatter: formatter,
    isInlineEditing: isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  });
}