"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricDimensionEditor = MetricDimensionEditor;
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/charts-plugin/common");
var _react2 = require("@emotion/react");
var _utils = require("../../../common/expressions/impl/datatable/utils");
var _shared_components = require("../../shared_components");
var _palette_config = require("./palette_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/legacy_metric/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const idPrefix = (0, _eui.htmlIdGenerator)()();
function MetricDimensionEditor(props) {
  var _frame$activeData;
  const {
    state,
    setState,
    frame,
    accessor,
    isInlineEditing
  } = props;
  const currentData = (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : _frame$activeData[state.layerId];
  const [firstRow] = (currentData === null || currentData === void 0 ? void 0 : currentData.rows) || [];
  if (accessor == null || firstRow == null || !(0, _utils.isNumericFieldForDatatable)(currentData, accessor)) {
    return null;
  }
  const currentColorMode = (state === null || state === void 0 ? void 0 : state.colorMode) || _common.ColorMode.None;
  const hasDynamicColoring = currentColorMode !== _common.ColorMode.None;
  const currentMinMax = {
    min: Math.min(firstRow[accessor] * 2, firstRow[accessor] === 0 ? -50 : 0),
    // if value is 0, then fallback to 100 as last resort
    max: Math.max(firstRow[accessor] * 2, firstRow[accessor] === 0 ? 100 : 0)
  };
  const activePalette = (state === null || state === void 0 ? void 0 : state.palette) || {
    type: 'palette',
    name: _palette_config.defaultPaletteParams.name,
    params: {
      ..._palette_config.defaultPaletteParams,
      stops: undefined,
      colorStops: undefined,
      rangeMin: currentMinMax.min,
      rangeMax: currentMinMax.max * 3 / 4
    }
  };

  // need to tell the helper that the colorStops are required to display
  const stops = (0, _coloring.applyPaletteParams)(props.paletteService, activePalette, currentMinMax);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.legacyMetric.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.legacyMetric.dynamicColoring.label', {
      defaultMessage: 'Color by value'
    }),
    "data-test-subj": "lnsLegacyMetric_dynamicColoring_groups",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}None`,
      label: _i18n.i18n.translate('xpack.lens.legacyMetric.dynamicColoring.none', {
        defaultMessage: 'None'
      }),
      'data-test-subj': 'lnsLegacyMetric_dynamicColoring_groups_none'
    }, {
      id: `${idPrefix}Background`,
      label: _i18n.i18n.translate('xpack.lens.legacyMetric.dynamicColoring.background', {
        defaultMessage: 'Fill'
      }),
      'data-test-subj': 'lnsLegacyMetric_dynamicColoring_groups_background'
    }, {
      id: `${idPrefix}Labels`,
      label: _i18n.i18n.translate('xpack.lens.legacyMetric.dynamicColoring.text', {
        defaultMessage: 'Text'
      }),
      'data-test-subj': 'lnsLegacyMetric_dynamicColoring_groups_labels'
    }],
    idSelected: `${idPrefix}${currentColorMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      const params = {
        colorMode: newMode
      };
      if (!(state !== null && state !== void 0 && state.palette) && newMode !== _common.ColorMode.None) {
        params.palette = {
          ...activePalette,
          params: {
            ...activePalette.params,
            // align this initial computation with same format for default
            // palettes in the panel. This to avoid custom computation issue with metric
            // fake data range
            stops: stops.map((v, i, array) => ({
              ...v,
              stop: currentMinMax.min + (i === 0 ? 0 : array[i - 1].stop)
            }))
          }
        };
      }
      // clear up when switching to no coloring
      if (state !== null && state !== void 0 && state.palette && newMode === _common.ColorMode.None) {
        params.palette = undefined;
      }
      setState({
        ...state,
        ...params
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })), hasDynamicColoring && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteMetricGradient.label', {
      defaultMessage: 'Color mapping'
    }),
    css: (0, _react2.css)`
            align-items: center;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    palette: stops.map(({
      color
    }) => color),
    siblingRef: props.panelRef,
    isInlineEditing: isInlineEditing,
    title: _i18n.i18n.translate('xpack.lens.paletteMetricGradient.label', {
      defaultMessage: 'Color mapping'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    setPalette: newPalette => {
      // if the new palette is not custom, replace the rangeMin with the artificial one
      if (newPalette.name !== _coloring.CUSTOM_PALETTE && newPalette.params && newPalette.params.rangeMin !== currentMinMax.min) {
        newPalette.params.rangeMin = currentMinMax.min;
      }
      setState({
        ...state,
        palette: newPalette
      });
    },
    showRangeTypeSelector: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }))));
}