"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPanelWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _easteregg = require("./easteregg");
var _state_management = require("../../state_management");
var _state_helpers = require("./state_helpers");
var _lens_slice = require("../../state_management/lens_slice");
var _utils = require("../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/data_panel_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const memoizeStrictlyEqual = (0, _memoizeOne.default)(arg => arg, _lodash.isEqual);
const DataPanelWrapper = exports.DataPanelWrapper = /*#__PURE__*/(0, _react.memo)(props => {
  var _props$datasourceMap$, _props$visualizationM, _props$visualizationM2;
  const externalContext = (0, _state_management.useLensSelector)(_state_management.selectExecutionContext);
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const visualizationState = (0, _state_management.useLensSelector)(_state_management.selectVisualizationState);
  const datasourceIsLoading = activeDatasourceId ? datasourceStates[activeDatasourceId].isLoading : true;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const setDatasourceState = (0, _react.useMemo)(() => {
    return (newDatasourceState, options) => {
      dispatchLens((0, _state_management.updateDatasourceState)({
        newDatasourceState,
        datasourceId: activeDatasourceId,
        clearStagedPreview: true
      }));
      if (options !== null && options !== void 0 && options.applyImmediately) {
        dispatchLens((0, _state_management.applyChanges)());
      }
    };
  }, [activeDatasourceId, dispatchLens]);
  (0, _react.useEffect)(() => {
    if (activeDatasourceId && datasourceStates[activeDatasourceId].state === null) {
      (0, _state_helpers.initializeSources)({
        datasourceMap: props.datasourceMap,
        eventAnnotationService: props.plugins.eventAnnotationService,
        visualizationMap: props.visualizationMap,
        visualizationState,
        datasourceStates,
        dataViews: props.plugins.dataViews,
        references: undefined,
        initialContext: undefined,
        storage: new _public.Storage(localStorage),
        defaultIndexPatternId: props.core.uiSettings.get('defaultIndex')
      }, {
        isFullEditor: true
      }).then(({
        datasourceStates: newDatasourceStates,
        visualizationState: newVizState,
        indexPatterns,
        indexPatternRefs
      }) => {
        dispatchLens((0, _state_management.setState)({
          visualization: {
            ...visualizationState,
            state: newVizState
          },
          datasourceStates: Object.entries(newDatasourceStates).reduce((state, [datasourceId, datasourceState]) => ({
            ...state,
            [datasourceId]: {
              ...datasourceState,
              isLoading: false
            }
          }), {}),
          dataViews: (0, _utils.getInitialDataViewsObject)(indexPatterns, indexPatternRefs)
        }));
      });
    }
  }, [datasourceStates, visualizationState, activeDatasourceId, props.datasourceMap, props.visualizationMap, dispatchLens, props.plugins.dataViews, props.core.uiSettings, props.plugins.eventAnnotationService]);
  const onChangeIndexPattern = (0, _react.useCallback)(async (indexPatternId, datasourceId, layerId) => {
    // reload the indexpattern
    const indexPatterns = await props.indexPatternService.ensureIndexPattern({
      id: indexPatternId,
      cache: props.frame.dataViews.indexPatterns
    });
    // now update the state
    dispatchLens((0, _lens_slice.changeIndexPattern)({
      dataViews: {
        indexPatterns
      },
      datasourceIds: [datasourceId],
      indexPatternId,
      layerId
    }));
  }, [props.indexPatternService, props.frame.dataViews.indexPatterns, dispatchLens]);
  const datasourceProps = {
    ...externalContext,
    state: activeDatasourceId ? datasourceStates[activeDatasourceId].state : null,
    setState: setDatasourceState,
    core: props.core,
    showNoDataPopover: props.showNoDataPopover,
    dropOntoWorkspace: props.dropOntoWorkspace,
    hasSuggestionForField: props.hasSuggestionForField,
    uiActions: props.plugins.uiActions,
    onChangeIndexPattern,
    indexPatternService: props.indexPatternService,
    frame: props.frame,
    // Visualization can handle dataViews, so need to pass to the data panel the full list of used dataViews
    usedIndexPatterns: memoizeStrictlyEqual([...(activeDatasourceId && ((_props$datasourceMap$ = props.datasourceMap[activeDatasourceId]) === null || _props$datasourceMap$ === void 0 ? void 0 : _props$datasourceMap$.getUsedDataViews(datasourceStates[activeDatasourceId].state)) || []), ...(visualizationState.activeId && ((_props$visualizationM = props.visualizationMap[visualizationState.activeId]) === null || _props$visualizationM === void 0 ? void 0 : (_props$visualizationM2 = _props$visualizationM.getUsedDataViews) === null || _props$visualizationM2 === void 0 ? void 0 : _props$visualizationM2.call(_props$visualizationM, visualizationState.state)) || [])])
  };
  const DataPanelComponent = activeDatasourceId && !datasourceIsLoading ? props.datasourceMap[activeDatasourceId].DataPanelComponent : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_easteregg.Easteregg, {
    query: externalContext === null || externalContext === void 0 ? void 0 : externalContext.query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), DataPanelComponent && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsDataPanelWrapper",
    "data-test-subj": "lnsDataPanelWrapper",
    css: (0, _react2.css)`
            flex: 1 0 100%;
            overflow: hidden;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, DataPanelComponent(datasourceProps)));
});