"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeExcludeRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/terms/include_exclude_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTermsIncludeExcludeOptions = (include, exclude) => {
  const includeOptions = include === null || include === void 0 ? void 0 : include.map(term => ({
    label: String(term)
  }));
  const excludeOptions = exclude === null || exclude === void 0 ? void 0 : exclude.map(term => ({
    label: String(term)
  }));
  return {
    ...((includeOptions === null || includeOptions === void 0 ? void 0 : includeOptions.length) && {
      include: includeOptions
    }),
    ...((excludeOptions === null || excludeOptions === void 0 ? void 0 : excludeOptions.length) && {
      exclude: excludeOptions
    })
  };
};
const IncludeExcludeRow = ({
  include,
  exclude,
  tableRows,
  columnId,
  isNumberField,
  includeIsRegex,
  excludeIsRegex,
  updateParams
}) => {
  const [includeExcludeSelectedOptions, setIncludeExcludeSelectedOptions] = (0, _react.useState)(getTermsIncludeExcludeOptions(include, exclude));
  const [termsOptions, setTermsOptions] = (0, _react.useState)(undefined);
  const [isRegexUsed, setIsRegexUsed] = (0, _react.useState)({
    include: includeIsRegex,
    exclude: excludeIsRegex
  });
  const [regex, setRegex] = (0, _react.useState)({
    include: includeIsRegex ? include === null || include === void 0 ? void 0 : include[0] : '',
    exclude: excludeIsRegex ? exclude === null || exclude === void 0 ? void 0 : exclude[0] : ''
  });
  (0, _react.useEffect)(() => {
    if (isNumberField) {
      setIsRegexUsed({
        include: false,
        exclude: false
      });
    }
  }, [isNumberField]);
  (0, _react.useEffect)(() => {
    var _includeExcludeSelect;
    if (includeExcludeSelectedOptions !== null && includeExcludeSelectedOptions !== void 0 && (_includeExcludeSelect = includeExcludeSelectedOptions.include) !== null && _includeExcludeSelect !== void 0 && _includeExcludeSelect.length) return;
    const uniqueTerms = (0, _lodash.uniq)(tableRows === null || tableRows === void 0 ? void 0 : tableRows.map(row => row[columnId])).filter(row => row !== '__other__');
    const options = uniqueTerms === null || uniqueTerms === void 0 ? void 0 : uniqueTerms.map(row => {
      return {
        label: String(row)
      };
    });
    setTermsOptions(options);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tableRows]);
  const onChangeIncludeExcludeOptions = (selectedOptions, operation) => {
    var _includeExcludeSelect2;
    const otherOperation = operation === 'include' ? 'exclude' : 'include';
    const otherSelectedOptions = (_includeExcludeSelect2 = includeExcludeSelectedOptions[otherOperation]) !== null && _includeExcludeSelect2 !== void 0 ? _includeExcludeSelect2 : [];
    const hasIdenticalOptions = selectedOptions.some(option => {
      return otherSelectedOptions.some(otherOption => otherOption.label === option.label);
    });
    const otherSelectedNonIdenticalOptions = hasIdenticalOptions ? otherSelectedOptions.filter(otherOption => !selectedOptions.some(option => option.label === otherOption.label)) : otherSelectedOptions;
    const options = {
      [otherOperation]: otherSelectedNonIdenticalOptions,
      [operation]: selectedOptions
    };
    setIncludeExcludeSelectedOptions(options);
    const getTerms = updatedSelectedOptions => updatedSelectedOptions.map(option => {
      if (!Number.isNaN(Number(option.label))) {
        return Number(option.label);
      }
      return option.label;
    });
    const terms = getTerms(selectedOptions);
    const param = `${operation}IsRegex`;
    updateParams(operation, terms, param, false);
    if (hasIdenticalOptions) {
      const otherTerms = getTerms(otherSelectedNonIdenticalOptions);
      const otherParam = `${otherOperation}IsRegex`;
      updateParams(otherOperation, otherTerms, otherParam, false);
    }
  };
  const onCreateOption = (searchValue, operation) => {
    var _includeExcludeSelect3;
    const newOption = {
      label: searchValue
    };
    const selectedOptions = [...((_includeExcludeSelect3 = includeExcludeSelectedOptions[operation]) !== null && _includeExcludeSelect3 !== void 0 ? _includeExcludeSelect3 : []), newOption];
    onChangeIncludeExcludeOptions(selectedOptions, operation);
  };
  const onIncludeRegexChangeToDebounce = (0, _react.useCallback)(newIncludeValue => {
    const isEqualToExcludeValue = newIncludeValue === regex.exclude;
    const excludeValue = isEqualToExcludeValue ? '' : regex.exclude;
    setRegex({
      exclude: excludeValue,
      include: newIncludeValue
    });
    updateParams('include', [newIncludeValue !== null && newIncludeValue !== void 0 ? newIncludeValue : ''], 'includeIsRegex', true);
    if (isEqualToExcludeValue) {
      updateParams('exclude', [''], 'excludeIsRegex', true);
    }
  }, [regex, updateParams]);
  const onExcludeRegexChangeToDebounce = (0, _react.useCallback)(newExcludeValue => {
    const isEqualToIncludeValue = newExcludeValue === regex.include;
    const includeValue = isEqualToIncludeValue ? '' : regex.include;
    setRegex({
      include: includeValue,
      exclude: newExcludeValue
    });
    updateParams('exclude', [newExcludeValue !== null && newExcludeValue !== void 0 ? newExcludeValue : ''], 'excludeIsRegex', true);
    if (isEqualToIncludeValue) {
      updateParams('include', [''], 'includeIsRegex', true);
    }
  }, [regex, updateParams]);
  const {
    inputValue: includeRegexValue,
    handleInputChange: onIncludeRegexValueChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onIncludeRegexChangeToDebounce,
    value: regex.include
  });
  const {
    inputValue: excludeRegexValue,
    handleInputChange: onExcludeRegexValueChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: onExcludeRegexChangeToDebounce,
    value: regex.exclude
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.include', {
      defaultMessage: 'Include values'
    }),
    display: "rowCompressed",
    fullWidth: true,
    labelAppend: !isNumberField ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.addRegex', {
        defaultMessage: 'Use regular expression'
      })),
      "data-test-subj": "lens-include-terms-regex-switch",
      compressed: true,
      checked: isRegexUsed.include,
      onChange: e => {
        const value = e.target.checked;
        setIsRegexUsed({
          ...isRegexUsed,
          include: value
        });
        setRegex({
          ...regex,
          include: ''
        });
        setIncludeExcludeSelectedOptions(getTermsIncludeExcludeOptions([], exclude));
        updateParams('include', [], 'includeIsRegex', value);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, isRegexUsed.include ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    "data-test-subj": "lens-include-terms-regex-input",
    value: includeRegexValue,
    onChange: e => {
      onIncludeRegexValueChange(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.include', {
      defaultMessage: 'Include values'
    }),
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePlaceholder', {
      defaultMessage: 'Select values or create a new one'
    }),
    options: termsOptions,
    selectedOptions: includeExcludeSelectedOptions.include,
    onChange: options => onChangeIncludeExcludeOptions(options, 'include'),
    onCreateOption: searchValue => onCreateOption(searchValue, 'include'),
    isClearable: true,
    "data-test-subj": "lens-include-terms-combobox",
    autoFocus: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.terms.exclude', {
      defaultMessage: 'Exclude values'
    }),
    display: "rowCompressed",
    fullWidth: true,
    labelAppend: !isNumberField ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.terms.addRegex', {
        defaultMessage: 'Use regular expression'
      })),
      compressed: true,
      checked: isRegexUsed.exclude,
      onChange: e => {
        const value = e.target.checked;
        setIsRegexUsed({
          ...isRegexUsed,
          exclude: value
        });
        setRegex({
          ...regex,
          exclude: ''
        });
        setIncludeExcludeSelectedOptions(getTermsIncludeExcludeOptions(include, []));
        updateParams('exclude', [], 'excludeIsRegex', value);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 13
      }
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, isRegexUsed.exclude ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    "data-test-subj": "lens-exclude-terms-regex-input",
    value: excludeRegexValue,
    onChange: e => {
      onExcludeRegexValueChange(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePatternPlaceholder', {
      defaultMessage: 'Enter a regex to filter values'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.terms.exclude', {
      defaultMessage: 'Exclude values'
    }),
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.terms.includeExcludePlaceholder', {
      defaultMessage: 'Select values or create a new one'
    }),
    options: termsOptions,
    selectedOptions: includeExcludeSelectedOptions.exclude,
    onChange: options => onChangeIncludeExcludeOptions(options, 'exclude'),
    onCreateOption: searchValue => onCreateOption(searchValue, 'exclude'),
    isClearable: true,
    "data-test-subj": "lens-exclude-terms-combobox",
    autoFocus: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  })));
};
exports.IncludeExcludeRow = IncludeExcludeRow;