"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countOperation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/expressions-plugin/public");
var _lensFormulaDocs = require("@kbn/lens-formula-docs");
var _esqlUtils = require("@kbn/esql-utils");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _layer_helpers = require("../layer_helpers");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const countLabel = _i18n.i18n.translate('xpack.lens.indexPattern.countOf', {
  defaultMessage: 'Count of records'
});
const supportedTypes = new Set(['string', 'boolean', 'number', 'number_range', 'ip', 'ip_range', 'date', 'date_range', 'murmur3']);
function ofName(field, timeShift, timeScale, reducedTimeRange) {
  if (field !== null && field !== void 0 && field.customLabel && (field === null || field === void 0 ? void 0 : field.type) !== 'document') {
    return field.customLabel;
  }
  return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)((field === null || field === void 0 ? void 0 : field.type) !== 'document' ? _i18n.i18n.translate('xpack.lens.indexPattern.valueCountOf', {
    defaultMessage: 'Count of {name}',
    values: {
      name: (field === null || field === void 0 ? void 0 : field.displayName) || '-'
    }
  }) : countLabel, undefined, timeScale, undefined, timeShift, undefined, reducedTimeRange);
}
const SCALE = 'ratio';
const IS_BUCKETED = false;
const countOperation = exports.countOperation = {
  type: _lensFormulaDocs.COUNT_ID,
  displayName: _lensFormulaDocs.COUNT_NAME,
  input: 'field',
  getErrorMessage: (layer, columnId, indexPattern) => [...(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), ...(0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)],
  allowAsReference: true,
  onFieldChange: (oldColumn, field) => {
    return {
      ...oldColumn,
      label: ofName(field, oldColumn.timeShift, oldColumn.timeShift, oldColumn.reducedTimeRange),
      sourceField: field.name
    };
  },
  getPossibleOperationForField: ({
    aggregationRestrictions,
    aggregatable,
    type,
    timeSeriesMetric
  }) => {
    if (type === 'document' || aggregatable && timeSeriesMetric !== 'counter' && (!aggregationRestrictions || aggregationRestrictions.value_count) && supportedTypes.has(type)) {
      return {
        dataType: 'number',
        isBucketed: IS_BUCKETED,
        scale: SCALE
      };
    }
  },
  getDefaultLabel: (column, columns, indexPattern) => {
    const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(column.sourceField);
    return ofName(field, column.timeShift, column.timeScale, column.reducedTimeRange);
  },
  buildColumn({
    field,
    previousColumn
  }, columnParams) {
    var _previousColumn$param;
    return {
      label: ofName(field, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      dataType: 'number',
      operationType: _lensFormulaDocs.COUNT_ID,
      isBucketed: false,
      sourceField: field.name,
      timeScale: previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale,
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
      params: {
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn),
        emptyAsNull: previousColumn && (0, _helpers.isColumnOfType)(_lensFormulaDocs.COUNT_ID, previousColumn) ? (_previousColumn$param = previousColumn.params) === null || _previousColumn$param === void 0 ? void 0 : _previousColumn$param.emptyAsNull : !(columnParams !== null && columnParams !== void 0 && columnParams.usedInMath)
      }
    };
  },
  getAdvancedOptions: ({
    layer,
    columnId,
    currentColumn,
    paramEditorUpdater,
    euiTheme
  }) => {
    var _currentColumn$params;
    return [{
      dataTestSubj: 'hide-zero-values',
      inlineElement: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 162,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.lens.indexPattern.hideZero', {
          defaultMessage: 'Hide zero values'
        })),
        labelProps: {
          style: {
            fontWeight: euiTheme.font.weight.medium
          }
        },
        checked: Boolean((_currentColumn$params = currentColumn.params) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.emptyAsNull),
        onChange: () => {
          var _currentColumn$params2;
          paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
            layer,
            columnId,
            paramName: 'emptyAsNull',
            value: !((_currentColumn$params2 = currentColumn.params) !== null && _currentColumn$params2 !== void 0 && _currentColumn$params2.emptyAsNull)
          }));
        },
        compressed: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 11
        }
      })
    }];
  },
  getSerializedFormat: (column, columnId, indexPattern) => {
    var _field$format;
    const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(column.sourceField);
    return (_field$format = field === null || field === void 0 ? void 0 : field.format) !== null && _field$format !== void 0 ? _field$format : {
      id: 'number'
    };
  },
  toESQL: (column, columnId, indexPattern) => {
    var _column$params;
    if (((_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.emptyAsNull) === false || column.timeShift) return;
    const field = indexPattern.getFieldByName(column.sourceField);
    let esql = '';
    if (!field || (field === null || field === void 0 ? void 0 : field.type) === 'document') {
      esql = `COUNT(*)`;
    } else {
      esql = `COUNT(${(0, _esqlUtils.sanitazeESQLInput)(field.name)})`;
    }
    return esql;
  },
  toEsAggsFn: (column, columnId, indexPattern) => {
    const field = indexPattern.getFieldByName(column.sourceField);
    if ((field === null || field === void 0 ? void 0 : field.type) === 'document') {
      var _column$params2;
      return (0, _public.buildExpressionFunction)('aggCount', {
        id: columnId,
        enabled: true,
        schema: 'metric',
        // time shift is added to wrapping aggFilteredMetric if filter is set
        timeShift: column.filter || column.reducedTimeRange ? undefined : column.timeShift,
        emptyAsNull: (_column$params2 = column.params) === null || _column$params2 === void 0 ? void 0 : _column$params2.emptyAsNull
      }).toAst();
    } else {
      var _column$params3;
      return (0, _public.buildExpressionFunction)('aggValueCount', {
        id: columnId,
        enabled: true,
        schema: 'metric',
        field: column.sourceField,
        // time shift is added to wrapping aggFilteredMetric if filter is set
        timeShift: column.filter || column.reducedTimeRange ? undefined : column.timeShift,
        emptyAsNull: (_column$params3 = column.params) === null || _column$params3 === void 0 ? void 0 : _column$params3.emptyAsNull
      }).toAst();
    }
  },
  getGroupByKey: agg => {
    return (0, _get_group_by_key.getGroupByKey)(agg, ['aggCount', 'aggValueCount'], [{
      name: 'field'
    }, {
      name: 'emptyAsNull',
      transformer: val => String(Boolean(val))
    }]);
  },
  isTransferable: (column, newIndexPattern) => {
    const newField = newIndexPattern.getFieldByName(column.sourceField);
    return Boolean(newField && (newField.type === 'document' || supportedTypes.has(newField.type) && newField.aggregatable && (!newField.aggregationRestrictions || newField.aggregationRestrictions.cardinality)));
  },
  timeScalingMode: 'optional',
  filterable: true,
  canReduceTimeRange: true,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.count.documentation.quick', {
    defaultMessage: `
The total number of documents. When you provide a field, the total number of field values is counted. When you use the Count function for fields that have multiple values in a single document, all values are counted.
      `
  }),
  shiftable: true
};