"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateEditor = void 0;
var _react = require("@emotion/react");
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/url_template_editor/url_template_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UrlTemplateEditor = ({
  height = 105,
  fitToContent,
  value,
  variables,
  onChange,
  placeholder,
  onEditor,
  Editor = _codeEditor.CodeEditor
}) => {
  const refEditor = React.useRef(null);
  const handleEditor = React.useCallback(editor => {
    refEditor.current = editor;
    if (onEditor) {
      onEditor(editor);
    }
  }, []);
  const handleKeyDown = React.useCallback(event => {
    const editor = refEditor.current;
    if (!editor) return;
    if (event.key === 'Escape') {
      if (editor.hasWidgetFocus()) {
        // Don't propagate Escape click if Monaco editor is focused, this allows
        // user to close the autocomplete widget with Escape button without
        // closing the EUI flyout.
        event.stopPropagation();
        editor.trigger('editor', 'hideSuggestWidget', []);
      }
    }
  }, []);
  React.useEffect(() => {
    if (!variables) {
      return;
    }
    const {
      dispose
    } = _codeEditor.monaco.languages.registerCompletionItemProvider(_codeEditor.HANDLEBARS_LANG_ID, {
      triggerCharacters: ['{', '/', '?', '&', '='],
      provideCompletionItems(model, position, context, token) {
        const {
          lineNumber
        } = position;
        const line = model.getLineContent(lineNumber);
        const wordUntil = model.getWordUntilPosition(position);
        const word = model.getWordAtPosition(position) || wordUntil;
        const {
          startColumn,
          endColumn
        } = word;
        const range = {
          startLineNumber: lineNumber,
          endLineNumber: lineNumber,
          startColumn,
          endColumn
        };
        const leadingMustacheCount = 0 + (line[range.startColumn - 2] === '{' ? 1 : 0) + (line[range.startColumn - 3] === '{' ? 1 : 0);
        const trailingMustacheCount = 0 + (line[range.endColumn - 1] === '}' ? 1 : 0) + (line[range.endColumn + 0] === '}' ? 1 : 0);
        return {
          suggestions: variables.map(({
            label,
            title = '',
            documentation = '',
            kind = _codeEditor.monaco.languages.CompletionItemKind.Variable,
            sortText
          }) => ({
            kind,
            label,
            insertText: (leadingMustacheCount === 2 ? '' : leadingMustacheCount === 1 ? '{' : '{{') + label + (trailingMustacheCount === 2 ? '' : trailingMustacheCount === 1 ? '}' : '}}'),
            detail: title,
            documentation,
            range,
            sortText
          }))
        };
      }
    });
    return () => {
      dispose();
    };
  }, [variables]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const editorStyle = (0, _react.css)({
    '.monaco-editor .lines-content.monaco-editor-background': {
      margin: `0 ${euiTheme.size.s}`
    }
  });
  return /*#__PURE__*/React.createElement("div", {
    "data-test-subj": "url-template-editor-container",
    css: editorStyle,
    onKeyDown: handleKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement(Editor, {
    languageId: _codeEditor.HANDLEBARS_LANG_ID,
    height: height,
    fitToContent: fitToContent,
    value: value,
    onChange: onChange,
    editorDidMount: handleEditor,
    placeholder: placeholder,
    options: {
      fontSize: 14,
      renderLineHighlight: 'none',
      lineNumbers: 'off',
      glyphMargin: false,
      folding: false,
      lineDecorationsWidth: 2,
      quickSuggestions: {
        comments: false,
        strings: false,
        other: false
      },
      suggestOnTriggerCharacters: true,
      minimap: {
        enabled: false
      },
      guides: {
        highlightActiveIndentation: false
      },
      wordWrap: 'on',
      wrappingIndent: 'none',
      automaticLayout: true,
      scrollBeyondLastLine: false,
      overviewRulerLanes: 0,
      padding: {
        top: 8,
        bottom: 8
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }));
};
exports.UrlTemplateEditor = UrlTemplateEditor;