"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Providers = exports.InteractiveSetupPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _app = require("./app");
var _use_kibana = require("./use_kibana");
var _use_verification = require("./use_verification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class InteractiveSetupPlugin {
  setup(core) {
    core.application.register({
      id: 'interactiveSetup',
      title: 'Configure Elastic to get started',
      appRoute: '/',
      chromeless: true,
      mount: async ({
        element
      }) => {
        const url = new URL(window.location.href);
        const defaultCode = url.searchParams.get('code') || undefined;
        const onSuccess = () => {
          url.searchParams.delete('code');
          window.location.replace(url.href);
        };
        const [services] = await core.getStartServices();
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(Providers, {
          defaultCode: defaultCode,
          services: services,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_app.App, {
          onSuccess: onSuccess,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 13
          }
        })), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
  }
  start(_core) {}
}
exports.InteractiveSetupPlugin = InteractiveSetupPlugin;
const Providers = ({
  defaultCode,
  services,
  children
}) => /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, services, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 3
  }
}), /*#__PURE__*/_react.default.createElement(_use_kibana.KibanaProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_use_verification.VerificationProvider, {
  defaultCode: defaultCode,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 7
  }
}, children)));
exports.Providers = Providers;