"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _lib = require("../../../../../../lib");
var _shared_imports = require("../../../../../../../shared_imports");
var _add_docs_accordion = require("./add_docs_accordion");
var _reset_documents_modal = require("./reset_documents_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_tabs/tab_documents/tab_documents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const {
  emptyField,
  isJsonField
} = _shared_imports.fieldValidators;
const i18nTexts = {
  learnMoreLink: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsTab.simulateDocumentionLink', {
    defaultMessage: 'Learn more.'
  }),
  documentsEditorAriaLabel: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsTab.editorFieldAriaLabel', {
    defaultMessage: 'Documents JSON editor'
  }),
  documentsEditorClearAllButton: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsTab.editorFieldClearAllButtonLabel', {
    defaultMessage: 'Clear all'
  }),
  runButton: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsTab.runButtonLabel', {
    defaultMessage: 'Run the pipeline'
  }),
  runningButton: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsTab.runningButtonLabel', {
    defaultMessage: 'Running'
  })
};
const documentFieldConfig = {
  label: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsForm.documentsFieldLabel', {
    defaultMessage: 'Documents'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.form.onFailureFieldHelpText",
    defaultMessage: "Use JSON format: {code}",
    values: {
      code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }, JSON.stringify([{
        _index: 'index',
        _id: 'id',
        _source: {
          foo: 'bar'
        }
      }]))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }),
  serializer: _lib.parseJson,
  deserializer: _lib.stringifyJson,
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsForm.noDocumentsError', {
      defaultMessage: 'Documents are required.'
    }))
  }, {
    validator: isJsonField(_i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsForm.documentsJsonError', {
      defaultMessage: 'The documents JSON is not valid.'
    }))
  }, {
    validator: ({
      value
    }) => {
      const parsedJSON = JSON.parse(value);
      if (!parsedJSON.length) {
        return {
          message: _i18n.i18n.translate('xpack.ingestPipelines.testPipelineFlyout.documentsForm.oneDocumentRequiredError', {
            defaultMessage: 'At least one document is required.'
          })
        };
      }
    }
  }]
};
const styles = {
  documentField: (0, _react2.css)`
    position: relative;
  `,
  documentFieldButton: (0, _react2.css)`
    position: absolute;
    right: 0;
    top: 0;
  `
};
const TabDocuments = ({
  validateAndTestPipeline,
  resetTestOutput,
  isRunningTest,
  form
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const {
    getFormData,
    reset
  } = form;
  const onAddDocumentHandler = (0, _react.useCallback)(document => {
    const {
      documents: existingDocuments = []
    } = getFormData();
    reset({
      defaultValue: {
        documents: [...existingDocuments, document]
      }
    });
  }, [reset, getFormData]);
  const [showResetModal, setShowResetModal] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "testPipelineForm",
    isInvalid: form.isSubmitted && form.isValid === false,
    onSubmit: validateAndTestPipeline,
    error: form.getErrors(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "documentsTabContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.testPipelineFlyout.documentsTab.tabDescriptionText",
    defaultMessage: "Provide documents for the pipeline to ingest. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: services.documentation.getSimulatePipelineApiUrl(),
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 19
        }
      }, i18nTexts.learnMoreLink)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_add_docs_accordion.AddDocumentsAccordion, {
    onAddDocuments: onAddDocumentHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(UseField, {
    config: documentFieldConfig,
    path: "documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, field => /*#__PURE__*/_react.default.createElement("div", {
    css: styles.documentField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: () => setShowResetModal(true),
    "data-test-subj": "clearAllDocumentsButton",
    css: styles.documentFieldButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }, i18nTexts.documentsEditorClearAllButton), /*#__PURE__*/_react.default.createElement(_shared_imports.JsonEditorField, {
    field: field,
    codeEditorProps: {
      'data-test-subj': 'documentsEditor',
      height: '300px',
      'aria-label': i18nTexts.documentsEditorAriaLabel
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: validateAndTestPipeline,
    "data-test-subj": "runPipelineButton",
    size: "s",
    isLoading: isRunningTest,
    disabled: form.isSubmitted && !form.isValid,
    iconType: "play",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, isRunningTest ? i18nTexts.runningButton : i18nTexts.runButton), showResetModal && /*#__PURE__*/_react.default.createElement(_reset_documents_modal.ResetDocumentsModal, {
    confirmResetTestOutput: () => {
      resetTestOutput();
      form.reset({
        defaultValue: {
          documents: []
        }
      });
      setShowResetModal(false);
    },
    closeModal: () => setShowResetModal(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })));
};
exports.TabDocuments = TabDocuments;