"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsEditorItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _utils = require("../../utils");
var _pipeline_processors_editor_item_status = require("../pipeline_processors_editor_item_status");
var _context = require("../../context");
var _shared = require("../shared");
var _context_menu = require("./context_menu");
var _i18n_texts = require("./i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/pipeline_processors_editor_item/pipeline_processors_editor_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = ({
  isSelected,
  isDimmedStyle,
  shouldHideDescription,
  isCancelButton
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    panel: (0, _react2.css)`
      transition: border-color ${euiTheme.animation.extraSlow} ${euiTheme.animation.resistance};
      min-height: 50px;
      ${isSelected && (0, _react2.css)`
        border: ${euiTheme.border.thin};
        border-color: ${euiTheme.colors.primary};
      `}
      ${isDimmedStyle && (0, _react2.css)`
        box-shadow: none;
      `}
    `,
    flexItemMinWidth: (0, _react2.css)`
      min-width: 0;
    `,
    innerFlexGroup: (0, _react2.css)`
      width: 100%;
      overflow: hidden;
    `,
    statusContainer: (0, _react2.css)`
      min-width: 15px;
    `,
    processorText: (0, _react2.css)`
      line-height: ${euiTheme.size.l};
    `,
    descriptionContainer: (0, _react2.css)`
      min-width: 0;
      ${shouldHideDescription && (0, _react2.css)`
        display: none;
      `}
    `,
    moveButton: (0, _react2.css)`
      &:hover {
        transform: none !important;
      }
      ${isCancelButton && (0, _react2.css)`
        z-index: ${euiTheme.levels.menu};
      `}
    `
  };
};
const PipelineProcessorsEditorItem = exports.PipelineProcessorsEditorItem = /*#__PURE__*/(0, _react.memo)(function PipelineProcessorsEditorItem({
  processor,
  description,
  handlers: {
    onCancelMove,
    onMove
  },
  selector,
  movingProcessor,
  renderOnFailureHandlers,
  editor,
  processorsDispatch
}) {
  var _processorOutput$stat, _processorDescriptor$, _processor$onFailure;
  const editButtonRef = (0, _react.useRef)(null);
  const contextMenuButtonRef = (0, _react.useRef)(null);
  const isEditorNotInIdleMode = editor.mode.id !== 'idle';
  const isInMoveMode = Boolean(movingProcessor);
  const isMovingThisProcessor = processor.id === (movingProcessor === null || movingProcessor === void 0 ? void 0 : movingProcessor.id);
  const isEditingThisProcessor = editor.mode.id === 'managingProcessor' && processor.id === editor.mode.arg.processor.id;
  const isEditingOtherProcessor = editor.mode.id === 'managingProcessor' && !isEditingThisProcessor;
  const isMovingOtherProcessor = editor.mode.id === 'movingProcessor' && !isMovingThisProcessor;
  const isDimmed = isEditingOtherProcessor || isMovingOtherProcessor;
  const processorDescriptor = (0, _shared.getProcessorDescriptor)(processor.type);
  const {
    testPipelineData
  } = (0, _context.useTestPipelineContext)();
  const {
    config: {
      selectedDocumentIndex
    },
    testOutputPerProcessor,
    isExecutingPipeline
  } = testPipelineData;
  const processorOutput = testOutputPerProcessor && testOutputPerProcessor[selectedDocumentIndex][processor.id];
  const processorStatus = (_processorOutput$stat = processorOutput === null || processorOutput === void 0 ? void 0 : processorOutput.status) !== null && _processorOutput$stat !== void 0 ? _processorOutput$stat : 'inactive';
  const defaultDescription = processorDescriptor === null || processorDescriptor === void 0 ? void 0 : processorDescriptor.getDefaultDescription(processor.options);
  const hasNoDescription = !defaultDescription && !processor.options.description;
  const styles = useStyles({
    isSelected: isMovingThisProcessor || isEditingThisProcessor,
    isDimmedStyle: isDimmed,
    shouldHideDescription: isInMoveMode && hasNoDescription,
    isCancelButton: isMovingThisProcessor
  });
  const onDescriptionChange = (0, _react.useCallback)(nextDescription => {
    let nextOptions;
    if (!nextDescription) {
      const {
        description: _description,
        ...restOptions
      } = processor.options;
      nextOptions = restOptions;
    } else {
      nextOptions = {
        ...processor.options,
        description: nextDescription
      };
    }
    processorsDispatch({
      type: 'updateProcessor',
      payload: {
        processor: {
          ...processor,
          options: nextOptions
        },
        selector
      }
    });
  }, [processor, processorsDispatch, selector]);
  const renderMoveButton = () => {
    const label = !isMovingThisProcessor ? _i18n_texts.i18nTexts.moveButtonLabel : _i18n_texts.i18nTexts.cancelMoveButtonLabel;
    const dataTestSubj = !isMovingThisProcessor ? 'moveItemButton' : 'cancelMoveItemButton';
    const icon = isMovingThisProcessor ? 'cross' : 'sortable';
    const disabled = isEditorNotInIdleMode && !isMovingThisProcessor;
    const moveButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: isMovingThisProcessor ? 'primary' : 'text',
      iconType: icon,
      "data-test-subj": dataTestSubj,
      size: "s",
      isDisabled: disabled,
      "aria-label": label,
      onClick: () => {
        if (isMovingThisProcessor) {
          onCancelMove();
        } else {
          onMove();
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    });
    // Remove the tooltip from the DOM to prevent it from lingering if the mouse leave event
    // did not fire.
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.moveButton,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 9
      }
    }, !isInMoveMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n_texts.i18nTexts.moveButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }, moveButton) : moveButton);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    css: styles.panel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    alignItems: "center",
    justifyContent: "spaceBetween",
    "data-test-subj": (0, _utils.selectorToDataTestSubject)(selector),
    "data-processor-id": processor.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.flexItemMinWidth,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.innerFlexGroup,
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, renderMoveButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.statusContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 15
    }
  }, isExecutingPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_pipeline_processors_editor_item_status.PipelineProcessorsItemStatus, {
    processorStatus: processorStatus,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: styles.processorText,
    color: isDimmed ? 'subdued' : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    ref: editButtonRef,
    tabIndex: isEditorNotInIdleMode ? -1 : 0,
    disabled: isEditorNotInIdleMode,
    onClick: () => {
      editor.setMode({
        id: 'managingProcessor',
        arg: {
          processor,
          selector,
          buttonRef: editButtonRef
        }
      });
    },
    "data-test-subj": "manageItemButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 21
    }
  }, (_processorDescriptor$ = processorDescriptor === null || processorDescriptor === void 0 ? void 0 : processorDescriptor.label) !== null && _processorDescriptor$ !== void 0 ? _processorDescriptor$ : processor.type)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "pipelineProcessorItemDescriptionContainer",
    css: styles.descriptionContainer,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    size: "s",
    defaultValue: description || '',
    readModeProps: {
      'data-test-subj': 'inlineTextInputNonEditableText'
    },
    placeholder: defaultDescription !== null && defaultDescription !== void 0 ? defaultDescription : _i18n_texts.i18nTexts.descriptionPlaceholder,
    inputAriaLabel: _i18n_texts.i18nTexts.processorTypeLabel({
      type: processor.type
    }),
    isReadOnly: isEditorNotInIdleMode,
    onSave: newTextValue => {
      onDescriptionChange(newTextValue);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_context_menu.ContextMenu, {
    ref: contextMenuButtonRef,
    "data-test-subj": "moreMenu",
    disabled: isEditorNotInIdleMode,
    hidden: isInMoveMode,
    showAddOnFailure: !((_processor$onFailure = processor.onFailure) !== null && _processor$onFailure !== void 0 && _processor$onFailure.length),
    onAddOnFailure: () => {
      editor.setMode({
        id: 'creatingProcessor',
        arg: {
          selector,
          buttonRef: contextMenuButtonRef
        }
      });
    },
    onDelete: () => {
      editor.setMode({
        id: 'removingProcessor',
        arg: {
          selector
        }
      });
    },
    onDuplicate: () => {
      processorsDispatch({
        type: 'duplicateProcessor',
        payload: {
          source: selector
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  }))), renderOnFailureHandlers && renderOnFailureHandlers());
});