"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initDeleteMetricsExplorerViewRoute = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NON_STARTED_SERVICE_ERROR = {
  statusCode: 500,
  body: {
    message: `Handler for "DELETE ${_latest.METRICS_EXPLORER_VIEW_URL_ENTITY}" was registered but MetricsViewService has not started.`
  }
};
const initDeleteMetricsExplorerViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'delete',
    path: _latest.METRICS_EXPLORER_VIEW_URL_ENTITY,
    validate: {
      params: (0, _ioTsUtils.createRouteValidationFunction)(_latest.metricsExplorerViewRequestParamsRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      params
    } = request;
    const [,, {
      metricsExplorerViews
    }] = await getStartServices();
    if (metricsExplorerViews === undefined) {
      return response.customError(NON_STARTED_SERVICE_ERROR);
    }
    const metricsExplorerViewsClient = metricsExplorerViews.getScopedClient(request);
    try {
      await metricsExplorerViewsClient.delete(params.metricsExplorerViewId);
      return response.noContent();
    } catch (error) {
      var _error$statusCode, _error$message;
      if ((0, _boom.isBoom)(error)) {
        return response.customError({
          statusCode: error.output.statusCode,
          body: {
            message: error.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initDeleteMetricsExplorerViewRoute = initDeleteMetricsExplorerViewRoute;