"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SurveyKubernetes = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/survey_kubernetes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KUBERNETES_TOAST_STORAGE_KEY = 'kubernetesToastKey';
const KUBERNETES_FEEDBACK_LINK = 'https://ela.st/k8s-feedback';
const FEEDBACK_BUTTON_KUBERNETES_TEXT = _i18n.i18n.translate('xpack.infra.featureFeedbackButton.kubernetesText', {
  defaultMessage: 'Give feedback (K8s)'
});
const START_SURVEY_BUTTON_TEXT = _i18n.i18n.translate('xpack.infra.homePage.kubernetesToastButton', {
  defaultMessage: 'Start survey'
});
const SurveyKubernetes = () => {
  const [isToastSeen, setIsToastSeen] = (0, _useLocalStorage.default)(KUBERNETES_TOAST_STORAGE_KEY, false);
  const markToastAsSeen = () => setIsToastSeen(true);
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    formUrl: KUBERNETES_FEEDBACK_LINK,
    "data-test-subj": "infra-kubernetes-feedback-link",
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    surveyButtonText: FEEDBACK_BUTTON_KUBERNETES_TEXT,
    sanitizedPath: document.location.pathname,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), !isToastSeen && /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toastLifeTimeMs: Infinity,
    dismissToast: markToastAsSeen,
    toasts: [{
      id: 'k8s-toast',
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastTitle",
        defaultMessage: "We need your help!",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }),
      color: 'primary',
      iconType: 'help',
      text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        css: {
          wordWrap: 'break-word',
          whiteSpace: 'normal'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.homePage.kubernetesToastText",
        defaultMessage: "Help us design your Kubernetes experience by completing a feedback survey.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
        formUrl: KUBERNETES_FEEDBACK_LINK,
        "data-test-subj": "infra-toast-kubernetes-survey-start",
        onClickCapture: markToastAsSeen,
        defaultButton: true,
        kibanaVersion: kibanaVersion,
        isCloudEnv: isCloudEnv,
        isServerlessEnv: isServerlessEnv,
        surveyButtonText: START_SURVEY_BUTTON_TEXT,
        sanitizedPath: document.location.pathname,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 23
        }
      }))))
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }));
};
exports.SurveyKubernetes = SurveyKubernetes;