"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomDrawer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/observability-shared-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _try_it_button = require("../../../../components/try_it_button");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _timeline = require("./timeline/timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/bottom_drawer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showHistory = _i18n.i18n.translate('xpack.infra.showHistory', {
  defaultMessage: 'Show history'
});
const hideHistory = _i18n.i18n.translate('xpack.infra.hideHistory', {
  defaultMessage: 'Hide history'
});
const LOCAL_STORAGE_KEY = 'inventoryUI:k8sDashboardClicked';
const KubernetesButton = () => {
  const [clicked, setClicked] = (0, _useLocalStorage.default)(LOCAL_STORAGE_KEY, false);
  const clickedRef = (0, _react.useRef)(clicked);
  return /*#__PURE__*/_react.default.createElement(_try_it_button.TryItButton, {
    color: clickedRef.current ? 'primary' : 'accent',
    label: _i18n.i18n.translate('xpack.infra.bottomDrawer.kubernetesDashboardsLink', {
      defaultMessage: 'Kubernetes dashboards'
    }),
    "data-test-subj": "inventory-kubernetesDashboard-link",
    link: {
      app: 'dashboards',
      hash: '/list',
      search: {
        _g: '()',
        s: 'kubernetes tag:(Managed)'
      }
    },
    onClick: () => {
      if (!clickedRef.current) {
        setClicked(true);
      }
    },
    hideBadge: clickedRef.current,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  });
};
const BottomDrawer = ({
  interval,
  formatter,
  view,
  nodeType
}) => {
  const {
    timelineOpen,
    changeTimelineOpen
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const [isOpen, setIsOpen] = (0, _react.useState)(Boolean(timelineOpen));
  (0, _react.useEffect)(() => {
    if (isOpen !== timelineOpen) setIsOpen(Boolean(timelineOpen));
  }, [isOpen, timelineOpen]);
  const trackDrawerOpen = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const onClick = (0, _react.useCallback)(() => {
    if (!isOpen) trackDrawerOpen({
      metric: 'open_timeline_drawer__inventory'
    });
    setIsOpen(!isOpen);
    changeTimelineOpen(!isOpen);
  }, [isOpen, trackDrawerOpen, changeTimelineOpen]);
  if (view === 'table') {
    return nodeType === 'pod' ? /*#__PURE__*/_react.default.createElement(BottomPanel, {
      hasBorder: false,
      hasShadow: false,
      borderRadius: "none",
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(KubernetesButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    })) : null;
  }
  return /*#__PURE__*/_react.default.createElement(BottomActionContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StickyPanel, {
    borderRadius: "none",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-expanded": isOpen,
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    onClick: onClick,
    "data-test-subj": "toggleTimelineButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, isOpen ? hideHistory : showHistory)), nodeType === 'pod' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(KubernetesButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxHeight: isOpen ? '224px' : 0,
      transition: 'max-height 0.15s ease',
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_timeline.Timeline, {
    isVisible: isOpen,
    interval: interval,
    yAxisFormatter: formatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
};
exports.BottomDrawer = BottomDrawer;
const BottomActionContainer = _styled.default.div`
  position: sticky;
  bottom: 0;
  left: 0;
  background: ${props => props.theme.euiTheme.colors.backgroundBasePlain};
  width: calc(100% + ${props => props.theme.euiTheme.size.l} * 2);
  margin-left: -${props => props.theme.euiTheme.size.l};
`; // Additional width comes from the padding on the EuiPageBody and inner nodes container

const BottomPanel = (0, _styled.default)(_eui.EuiPanel)`
  padding: ${props => props.theme.euiTheme.size.l} 0;
`;
const StickyPanel = (0, _styled.default)(_eui.EuiPanel)`
  padding: 0 ${props => props.theme.euiTheme.size.l};
`;