"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToHostDetailViaIP = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_host_ip_to_name = require("./use_host_ip_to_name");
var _loading_page = require("../../components/loading_page");
var _error = require("../error");
var _metrics_source = require("../../containers/metrics_source");
var _use_kibana = require("../../hooks/use_kibana");
var _redirect_to_node_detail = require("./redirect_to_node_detail");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/link_to/redirect_to_host_detail_via_ip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RedirectToHostDetailViaIP = ({
  match: {
    params: {
      hostIp
    }
  },
  location
}) => {
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const baseLocator = share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const {
    error,
    name
  } = (0, _use_host_ip_to_name.useHostIpToName)(hostIp, metricsView && metricsView.indices || null);
  (0, _react.useEffect)(() => {
    if (name) {
      const queryParams = new URLSearchParams(location.search);
      const search = (0, _redirect_to_node_detail.getSearchParams)('host', queryParams);
      baseLocator === null || baseLocator === void 0 ? void 0 : baseLocator.navigate({
        ...search,
        entityType: 'host',
        entityId: name,
        state: location.state
      });
    }
  }, [baseLocator, location.search, location.state, name]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error.Error, {
      message: _i18n.i18n.translate('xpack.infra.linkTo.hostWithIp.error', {
        defaultMessage: 'Host not found with IP address "{hostIp}".',
        values: {
          hostIp
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    });
  }
  if (!name) {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      message: _i18n.i18n.translate('xpack.infra.linkTo.hostWithIp.loading', {
        defaultMessage: 'Loading host with IP address "{hostIp}".',
        values: {
          hostIp
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    });
  }
  return null;
};
exports.RedirectToHostDetailViaIP = RedirectToHostDetailViaIP;