"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogAnalysisSetupFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _log_entry_categories_setup_view = require("./log_entry_categories_setup_view");
var _log_entry_rate_setup_view = require("./log_entry_rate_setup_view");
var _module_list = require("./module_list");
var _setup_flyout_state = require("./setup_flyout_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/setup_flyout/setup_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FLYOUT_HEADING_ID = 'logAnalysisSetupFlyoutHeading';
const LogAnalysisSetupFlyout = ({
  allowedModules = _setup_flyout_state.moduleIds
}) => {
  const {
    closeFlyout,
    flyoutView,
    showModuleList,
    showModuleSetup
  } = (0, _setup_flyout_state.useLogAnalysisSetupFlyoutStateContext)();
  if (flyoutView.view === 'hidden') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": FLYOUT_HEADING_ID,
    maxWidth: 800,
    onClose: closeFlyout,
    "data-test-subj": "infraLogAnalysisSetupFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: FLYOUT_HEADING_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.analysis.setupFlyoutTitle",
    defaultMessage: "Anomaly detection with Machine Learning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, flyoutView.view === 'moduleList' ? /*#__PURE__*/_react.default.createElement(_module_list.LogAnalysisModuleList, {
    onViewModuleSetup: showModuleSetup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }) : flyoutView.view === 'moduleSetup' && allowedModules.includes(flyoutView.module) ? /*#__PURE__*/_react.default.createElement(ModuleSetupView, {
    moduleId: flyoutView.module,
    onClose: closeFlyout,
    onViewModuleList: allowedModules.length > 1 ? showModuleList : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }) : null));
};
exports.LogAnalysisSetupFlyout = LogAnalysisSetupFlyout;
const ModuleSetupView = ({
  moduleId,
  onClose,
  onViewModuleList
}) => {
  switch (moduleId) {
    case 'logs_ui_analysis':
      return /*#__PURE__*/_react.default.createElement(LogAnalysisSetupFlyoutSubPage, {
        onViewModuleList: onViewModuleList,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_log_entry_rate_setup_view.LogEntryRateSetupView, {
        onClose: onClose,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }));
    case 'logs_ui_categories':
      return /*#__PURE__*/_react.default.createElement(LogAnalysisSetupFlyoutSubPage, {
        onViewModuleList: onViewModuleList,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_log_entry_categories_setup_view.LogEntryCategoriesSetupView, {
        onClose: onClose,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }));
  }
};
const LogAnalysisSetupFlyoutSubPage = ({
  children,
  onViewModuleList
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  direction: "column",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 3
  }
}, onViewModuleList ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "infraLogAnalysisSetupFlyoutSubPageAllMachineLearningJobsButton",
  flush: "left",
  iconSide: "left",
  iconType: "arrowLeft",
  onClick: onViewModuleList,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 100,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.analysis.setupFlyoutGotoListButtonLabel",
  defaultMessage: "All Machine Learning jobs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 11
  }
}))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 5
  }
}, children));