"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants = require("../constants");
var _content = require("../content/content");
var _flyout_header = require("../header/flyout_header");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _use_asset_details_url_state = require("../hooks/use_asset_details_url_state");
var _use_page_header = require("../hooks/use_page_header");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/template/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Flyout = ({
  tabs = [],
  links = [],
  closeFlyout
}) => {
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    entity,
    loading,
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    rightSideItems,
    tabEntries
  } = (0, _use_page_header.usePageHeader)(tabs, links);
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _react.useEffect)(() => {
    if (!loading) {
      telemetry.reportAssetDetailsFlyoutViewed({
        componentName: _constants.ASSET_DETAILS_FLYOUT_COMPONENT_NAME,
        assetType: entity.type,
        tabId: activeTabId,
        schema_selected: schema || 'ecs'
      });
    }
  }, [schema, entity.type, activeTabId, telemetry, loading]);
  const handleOnClose = (0, _react.useCallback)(() => {
    setUrlState(null);
    closeFlyout();
  }, [closeFlyout, setUrlState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleOnClose,
    "data-component-name": _constants.ASSET_DETAILS_FLYOUT_COMPONENT_NAME,
    "data-asset-type": entity.type,
    "data-schema-selected": schema,
    "aria-labelledby": _i18n.i18n.translate('xpack.infra.assetDetails.flyout.ariaLabel', {
      defaultMessage: '{name} details',
      values: {
        name: entity.name
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    title: entity.name,
    tabs: tabEntries,
    rightSideItems: rightSideItems,
    entityType: entity.type,
    loading: loading,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_content.Content, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))));
};
exports.Flyout = Flyout;