"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesSectionTitle = exports.MetricsSectionTitle = exports.AlertsSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lens = require("../../../lens");
var _section_title = require("../../components/section_title");
var _alerts_tooltip_content = require("../../components/alerts_tooltip_content");
var _services_tooltip_content = require("../../components/services_tooltip_content");
var _container_metrics_explanation_content = require("../../../lens/metric_explanation/container_metrics_explanation_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/section_titles.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MetricsSectionTitle = ({
  entityType
}) => {
  return /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
    tooltipAriaLabel: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metricsSectionTitle.areaLabel', {
      defaultMessage: 'Metrics information'
    }),
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.metricsSectionTitle', {
      defaultMessage: 'Metrics'
    }),
    "data-test-subj": "infraAssetDetailsMetricsTitle",
    tooltipTestSubj: "infraAssetDetailsMetricsPopoverButton",
    tooltipContent: getTooltipContent(entityType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  });
};
exports.MetricsSectionTitle = MetricsSectionTitle;
const AlertsSectionTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
    tooltipAriaLabel: _i18n.i18n.translate('xpack.infra.assetDetails.overview.alertsSectionTitle.areaLabel', {
      defaultMessage: 'Alerts information'
    }),
    title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.alertsSectionTitle', {
      defaultMessage: 'Alerts'
    }),
    "data-test-subj": "infraAssetDetailsAlertsTitle",
    tooltipTestSubj: "infraAssetDetailsAlertsPopoverButton",
    tooltipContent: /*#__PURE__*/_react.default.createElement(_alerts_tooltip_content.AlertsTooltipContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.AlertsSectionTitle = AlertsSectionTitle;
const ServicesSectionTitle = () => /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
  tooltipAriaLabel: _i18n.i18n.translate('xpack.infra.assetDetails.overview.servicesSectionTitle.areaLabel', {
    defaultMessage: 'Services information'
  }),
  title: _i18n.i18n.translate('xpack.infra.assetDetails.overview.servicesSectionTitle', {
    defaultMessage: 'Services'
  }),
  "data-test-subj": "infraAssetDetailsServicesTitle",
  tooltipTestSubj: "infraAssetDetailsServicesPopoverButton",
  tooltipContent: /*#__PURE__*/_react.default.createElement(_services_tooltip_content.ServicesTooltipContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 21
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 3
  }
});
exports.ServicesSectionTitle = ServicesSectionTitle;
function getTooltipContent(entityType) {
  switch (entityType) {
    case 'host':
      return /*#__PURE__*/_react.default.createElement(_lens.HostMetricsExplanationContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 14
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_container_metrics_explanation_content.ContainerMetricsExplanationContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 14
        }
      });
  }
}