"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultExpression = exports.default = exports.Expressions = exports.ExpressionRow = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _alertingComparators = require("@kbn/alerting-comparators");
var _common2 = require("@kbn/observability-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _schema_selector = require("../../../components/schema_selector");
var _unified_search_bar = require("../../../components/shared/unified_search_bar");
var _http_api = require("../../../../common/http_api");
var _metrics = require("../../../../common/alerting/metrics");
var _snapshot_metric_i18n = require("../../../../common/snapshot_metric_i18n");
var _metrics_source = require("../../../containers/metrics_source");
var _kuery = require("../../../utils/kuery");
var _expression_chart = require("./expression_chart");
var _metrics_expression = require("./metrics_expression");
var _expression_dropdown = require("./expression_dropdown");
var _supported_data_tooltip_link = require("../../../components/supported_data_tooltip_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/inventory/components/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultExpression = exports.defaultExpression = {
  metric: 'cpuV2',
  comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
  threshold: [],
  timeSize: 1,
  timeUnit: 'm',
  customMetric: {
    type: 'custom',
    id: 'alert-custom-metric',
    field: '',
    aggregation: 'avg'
  }
};
const Expressions = props => {
  var _ruleParams$schema;
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata
  } = props;
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const [timeSize, setTimeSize] = (0, _react2.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react2.useState)('m');
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const updateParams = (0, _react2.useCallback)((id, e) => {
    const exp = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    exp[id] = e;
    setRuleParams('criteria', exp);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react2.useCallback)(() => {
    var _ruleParams$criteria;
    const exp = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    exp.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', exp);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react2.useCallback)(id => {
    const exp = ruleParams.criteria.slice();
    if (exp.length > 1) {
      exp.splice(id, 1);
      setRuleParams('criteria', exp);
    }
  }, [setRuleParams, ruleParams.criteria]);
  const onFilterChange = (0, _react2.useCallback)(payload => {
    var _payload$query;
    const kuery = (_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.query;
    setRuleParams('filterQueryText', kuery !== null && kuery !== void 0 ? kuery : '');
    try {
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(kuery, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, false) || '');
    } catch (e) {
      setRuleParams('filterQuery', _metrics.QUERY_INVALID);
    }
  }, [metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, setRuleParams]);
  const emptyError = (0, _react2.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react2.useCallback)(ts => {
    const criteria = ruleParams.criteria.map(c => ({
      ...c,
      timeSize: ts
    }));
    setTimeSize(ts || undefined);
    setRuleParams('criteria', criteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react2.useCallback)(tu => {
    const criteria = ruleParams.criteria.map(c => ({
      ...c,
      timeUnit: tu
    }));
    setTimeUnit(tu);
    setRuleParams('criteria', criteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateNodeType = (0, _react2.useCallback)(nt => {
    setRuleParams('nodeType', nt);
  }, [setRuleParams]);
  const updateSchema = (0, _react2.useCallback)(nt => {
    setRuleParams('schema', nt);
  }, [setRuleParams]);
  const handleFieldSearchChange = (0, _react2.useCallback)(e => onFilterChange({
    query: {
      query: e.target.value,
      language: 'kuery'
    }
  }), [onFilterChange]);
  const preFillAlertCriteria = (0, _react2.useCallback)(() => {
    const md = metadata;
    if (md && md.options) {
      setRuleParams('criteria', [{
        ...defaultExpression,
        metric: md.options.metric.type,
        customMetric: _http_api.SnapshotCustomMetricInputRT.is(md.options.metric) ? md.options.metric : defaultExpression.customMetric
      }]);
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
  }, [metadata, setRuleParams]);
  const preFillAlertFilter = (0, _react2.useCallback)(() => {
    const md = metadata;
    if (md && md.filter) {
      setRuleParams('filterQueryText', md.filter);
      setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(md.filter, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference) || '');
    }
  }, [metadata, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, setRuleParams]);
  (0, _react2.useEffect)(() => {
    const md = metadata;
    const isHost = ruleParams.nodeType === 'host' || md && md.nodeType === 'host';
    if (!ruleParams.nodeType) {
      if (md && md.nodeType) {
        setRuleParams('nodeType', md.nodeType);
      } else {
        setRuleParams('nodeType', 'host');
      }
    }
    if (!ruleParams.schema) {
      if (md && md.schema && isHost) {
        setRuleParams('schema', md.schema);
      }
    }
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      preFillAlertCriteria();
    }
    if (ruleParams.filterQuery === undefined) {
      preFillAlertFilter();
    }
    if (!ruleParams.sourceId) {
      setRuleParams('sourceId', (source === null || source === void 0 ? void 0 : source.id) || 'default');
    }
  }, [metadata, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, defaultExpression, source]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.conditions",
    defaultMessage: "Conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement("div", {
    css: StyledExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: NonCollapsibleExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_expression_dropdown.ExpressionDropDown, {
    options: nodeTypeOptions,
    value: ruleParams.nodeType || 'host',
    onChange: updateNodeType,
    description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.for.descriptionLabel', {
      defaultMessage: 'For'
    }),
    popoverTitle: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.for.popoverTitle', {
      defaultMessage: 'Node type'
    }),
    "data-test-subj": "forExpressionSelect",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.for.ariaLabel', {
      defaultMessage: 'Select a node type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_supported_data_tooltip_link.SupportedDataTooltipLink, {
    nodeType: ruleParams.nodeType,
    isAlertUI: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 11
    }
  }))), ruleParams.nodeType === 'host' && /*#__PURE__*/_react2.default.createElement("div", {
    css: StyledExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: NonCollapsibleExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_expression_dropdown.ExpressionDropDown, {
    options: schemaOptions,
    value: (_ruleParams$schema = ruleParams.schema) !== null && _ruleParams$schema !== void 0 ? _ruleParams$schema : 'ecs',
    onChange: updateSchema,
    description: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.schema.descriptionLabel', {
      defaultMessage: 'Schema'
    }),
    popoverTitle: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.schema.popoverTitle', {
      defaultMessage: 'Schema'
    }),
    "data-test-subj": "forExpressionSelect",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expression.for.ariaLabel', {
      defaultMessage: 'Select a schema'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 7
    }
  }), ruleParams.criteria && ruleParams.criteria.map((e, idx) => {
    return /*#__PURE__*/_react2.default.createElement(ExpressionRow, {
      nodeType: ruleParams.nodeType,
      canDelete: ruleParams.criteria.length > 1,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 360,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_expression_chart.ExpressionChart, {
      expression: e,
      kuery: ruleParams.filterQueryText,
      nodeType: ruleParams.nodeType,
      sourceId: ruleParams.sourceId,
      accountId: ruleParams.accountId,
      region: ruleParams.region,
      schema: ruleParams.schema,
      "data-test-subj": "preview-chart",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: NonCollapsibleExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_public.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.expressions.addconditionButton.ariaLabel', {
      defaultMessage: 'Add condition'
    }),
    "data-test-subj": "infraExpressionsAddConditionButton",
    color: "primary",
    iconSide: "left",
    flush: "left",
    iconType: "plusInCircleFilled",
    onClick: addExpression,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.addCondition",
    defaultMessage: "Add condition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCheckbox, {
    id: "metrics-alert-no-data-toggle",
    label: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.alertOnNoData', {
      defaultMessage: "Alert me if there's no data"
    }), ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      type: "question",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.noDataHelpText', {
        defaultMessage: 'Enable this to trigger the action if the metric(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 13
      }
    })),
    checked: ruleParams.alertOnNoData,
    onChange: e => setRuleParams('alertOnNoData', e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.filterLabel', {
      defaultMessage: 'Filter (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 7
    }
  }, metadata ? /*#__PURE__*/_react2.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    onQuerySubmit: onFilterChange,
    useDefaultBehaviors: false,
    query: {
      query: ruleParams.filterQueryText || '',
      language: 'kuery'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraExpressionsFieldSearch",
    onChange: handleFieldSearchChange,
    value: ruleParams.filterQueryText,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 7
    }
  }));
};

// required for dynamic import
// eslint-disable-next-line import/no-default-export
exports.Expressions = Expressions;
var _default = exports.default = (0, _metrics_source.withSourceProvider)(Expressions)('default');
const NonCollapsibleExpressionCss = (0, _react.css)`
  margin-left: 28px;
`;
const StyledExpressionRowCss = (0, _react.css)`
  display: flex;
  flex-wrap: wrap;
  margin: 0 -4px;
`;
const StyledExpressionCss = (0, _react.css)`
  padding: 0 4px;
`;
const StyledHealthCss = (0, _react.css)`
  margin-left: 4px;
`;
const ExpressionRow = props => {
  var _ref, _ref2, _ofFields$find;
  const [isExpanded, toggle] = (0, _useToggle.default)(true);
  const {
    children,
    setRuleParams,
    expression,
    errors,
    expressionId,
    remove,
    canDelete,
    nodeType
  } = props;
  const {
    metric,
    comparator = _alertingComparators.COMPARATORS.GREATER_THAN,
    threshold = [],
    customMetric,
    warningThreshold = [],
    warningComparator
  } = expression;
  const [displayWarningThreshold, setDisplayWarningThreshold] = (0, _react2.useState)(Boolean(warningThreshold === null || warningThreshold === void 0 ? void 0 : warningThreshold.length));
  const updateMetric = (0, _react2.useCallback)(m => {
    const newMetric = _common.SnapshotMetricTypeRT.is(m) ? m : Boolean(m) ? 'custom' : undefined;
    const newAlertParams = {
      ...expression,
      metric: newMetric
    };
    setRuleParams(expressionId, newAlertParams);
  }, [expressionId, expression, setRuleParams]);
  const updateCustomMetric = (0, _react2.useCallback)(cm => {
    if (_http_api.SnapshotCustomMetricInputRT.is(cm)) {
      setRuleParams(expressionId, {
        ...expression,
        customMetric: cm
      });
    }
  }, [expressionId, expression, setRuleParams]);
  const updateComparator = (0, _react2.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      comparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const updateWarningComparator = (0, _react2.useCallback)(c => {
    setRuleParams(expressionId, {
      ...expression,
      warningComparator: c
    });
  }, [expressionId, expression, setRuleParams]);
  const updateThreshold = (0, _react2.useCallback)(t => {
    if (t.join() !== expression.threshold.join()) {
      setRuleParams(expressionId, {
        ...expression,
        threshold: t
      });
    }
  }, [expressionId, expression, setRuleParams]);
  const updateWarningThreshold = (0, _react2.useCallback)(t => {
    var _expression$warningTh;
    if (t.join() !== ((_expression$warningTh = expression.warningThreshold) === null || _expression$warningTh === void 0 ? void 0 : _expression$warningTh.join())) {
      setRuleParams(expressionId, {
        ...expression,
        warningThreshold: t
      });
    }
  }, [expressionId, expression, setRuleParams]);
  const toggleWarningThreshold = (0, _react2.useCallback)(() => {
    if (!displayWarningThreshold) {
      setDisplayWarningThreshold(true);
      setRuleParams(expressionId, {
        ...expression,
        warningComparator: comparator,
        warningThreshold: []
      });
    } else {
      setDisplayWarningThreshold(false);
      setRuleParams(expressionId, (0, _lodash.omit)(expression, 'warningComparator', 'warningThreshold'));
    }
  }, [displayWarningThreshold, setDisplayWarningThreshold, setRuleParams, comparator, expression, expressionId]);
  const criticalThresholdExpression = /*#__PURE__*/_react2.default.createElement(ThresholdElement, {
    comparator: comparator,
    threshold: threshold,
    updateComparator: updateComparator,
    updateThreshold: updateThreshold,
    errors: (_ref = errors.critical) !== null && _ref !== void 0 ? _ref : {},
    metric: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 597,
      columnNumber: 5
    }
  });
  const warningThresholdExpression = displayWarningThreshold && /*#__PURE__*/_react2.default.createElement(ThresholdElement, {
    comparator: warningComparator || comparator,
    threshold: warningThreshold,
    updateComparator: updateWarningComparator,
    updateThreshold: updateWarningThreshold,
    errors: (_ref2 = errors.warning) !== null && _ref2 !== void 0 ? _ref2 : {},
    metric: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 5
    }
  });
  const inventoryModels = (0, _common.findInventoryModel)(nodeType);
  const {
    value: aggregations
  } = (0, _useAsync.default)(() => inventoryModels.metrics.getAggregations(), [inventoryModels]);
  const ofFields = (0, _react2.useMemo)(() => {
    var _aggregations$getAll;
    return Object.keys((_aggregations$getAll = aggregations === null || aggregations === void 0 ? void 0 : aggregations.getAll()) !== null && _aggregations$getAll !== void 0 ? _aggregations$getAll : {}).map(key => (0, _snapshot_metric_i18n.toMetricOpt)(key, nodeType));
  }, [aggregations, nodeType]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 633,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraExpressionRowButton",
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    onClick: toggle,
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.expandRowLabel', {
      defaultMessage: 'Expand row.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 645,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: StyledExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 646,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_metrics_expression.MetricExpression, {
    metric: {
      value: metric,
      text: ((_ofFields$find = ofFields.find(v => (v === null || v === void 0 ? void 0 : v.value) === metric)) === null || _ofFields$find === void 0 ? void 0 : _ofFields$find.text) || ''
    },
    metrics: ofFields.filter(m => m !== undefined && m.value !== undefined),
    nodeType: nodeType,
    onChange: updateMetric,
    onChangeCustom: updateCustomMetric,
    errors: errors,
    customMetric: customMetric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 647,
      columnNumber: 15
    }
  })), !displayWarningThreshold && criticalThresholdExpression), displayWarningThreshold && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 669,
      columnNumber: 15
    }
  }, criticalThresholdExpression, /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
    css: StyledHealthCss,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 671,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.criticalThreshold",
    defaultMessage: "Alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 672,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 678,
      columnNumber: 15
    }
  }, warningThresholdExpression, /*#__PURE__*/_react2.default.createElement(_eui.EuiHealth, {
    css: StyledHealthCss,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 680,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.warningThreshold",
    defaultMessage: "Warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 681,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.removeWarningThreshold', {
      defaultMessage: 'Remove warningThreshold'
    }),
    iconSize: "s",
    color: "text",
    iconType: "minusInCircleFilled",
    onClick: toggleWarningThreshold,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 686,
      columnNumber: 17
    }
  }))), !displayWarningThreshold && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 705,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: StyledExpressionRowCss,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 706,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.expressionRow.addwarningthresholdButton.ariaLabel', {
      defaultMessage: 'Add warning threshold'
    }),
    "data-test-subj": "infraExpressionRowAddWarningThresholdButton",
    color: "primary",
    flush: "left",
    size: "xs",
    iconType: "plusInCircleFilled",
    onClick: toggleWarningThreshold,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 707,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.alertFlyout.addWarningThreshold",
    defaultMessage: "Add warning threshold",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 719,
      columnNumber: 19
    }
  }))))), canDelete && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 729,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraExpressionRowButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.removeCondition', {
      defaultMessage: 'Remove condition'
    }),
    color: "danger",
    iconType: "trash",
    onClick: () => remove(expressionId),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 730,
      columnNumber: 13
    }
  }))), isExpanded ? /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            padding: 0 0 0 28px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 743,
      columnNumber: 9
    }
  }, children) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 751,
      columnNumber: 7
    }
  }));
};
exports.ExpressionRow = ExpressionRow;
const ThresholdElement = ({
  updateComparator,
  updateThreshold,
  threshold,
  metric,
  comparator,
  errors
}) => {
  var _metricUnit$metric;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    css: StyledExpressionCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 766,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_public.ThresholdExpression, {
    thresholdComparator: (0, _common2.convertToBuiltInComparators)(comparator) || _alertingComparators.COMPARATORS.GREATER_THAN,
    threshold: threshold,
    onChangeSelectedThresholdComparator: updateComparator,
    onChangeSelectedThreshold: updateThreshold,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 767,
      columnNumber: 9
    }
  })), metric && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            align-self: center;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 776,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 781,
      columnNumber: 11
    }
  }, ((_metricUnit$metric = metricUnit[metric]) === null || _metricUnit$metric === void 0 ? void 0 : _metricUnit$metric.label) || '')));
};
const getDisplayNameForType = type => {
  const inventoryModel = (0, _common.findInventoryModel)(type);
  return inventoryModel.displayName;
};
const nodeTypeOptions = {
  host: {
    text: getDisplayNameForType('host'),
    value: 'host'
  },
  pod: {
    text: getDisplayNameForType('pod'),
    value: 'pod'
  },
  container: {
    text: getDisplayNameForType('container'),
    value: 'container'
  },
  awsEC2: {
    text: getDisplayNameForType('awsEC2'),
    value: 'awsEC2'
  },
  awsS3: {
    text: getDisplayNameForType('awsS3'),
    value: 'awsS3'
  },
  awsRDS: {
    text: getDisplayNameForType('awsRDS'),
    value: 'awsRDS'
  },
  awsSQS: {
    text: getDisplayNameForType('awsSQS'),
    value: 'awsSQS'
  }
};
const schemaOptions = {
  ecs: {
    text: _schema_selector.schemaTranslationMap.ecs,
    value: _common.DataSchemaFormatEnum.ECS
  },
  semconv: {
    text: _schema_selector.schemaTranslationMap.semconv,
    value: _common.DataSchemaFormatEnum.SEMCONV
  }
};
const metricUnit = {
  count: {
    label: ''
  },
  cpu: {
    label: '%'
  },
  cpuV2: {
    label: '%'
  },
  memory: {
    label: '%'
  },
  rx: {
    label: 'bits/s'
  },
  tx: {
    label: 'bits/s'
  },
  rxV2: {
    label: 'bits/s'
  },
  txV2: {
    label: 'bits/s'
  },
  logRate: {
    label: '/s'
  },
  diskIOReadBytes: {
    label: 'bytes/s'
  },
  diskIOWriteBytes: {
    label: 'bytes/s'
  },
  s3BucketSize: {
    label: 'bytes'
  },
  s3TotalRequests: {
    label: ''
  },
  s3NumberOfObjects: {
    label: ''
  },
  s3UploadBytes: {
    label: 'bytes'
  },
  s3DownloadBytes: {
    label: 'bytes'
  },
  sqsOldestMessage: {
    label: 'seconds'
  },
  rdsLatency: {
    label: 'ms'
  },
  custom: {
    label: ''
  }
};