"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityCategoryForScore = exports.getFriendlyNameForPartitionId = exports.formatOneDecimalPlace = exports.formatAnomalyScore = exports.compareDatasetsByMaximumAnomalyScore = void 0;
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
var _anomaly_threshold = require("@kbn/ml-anomaly-utils/anomaly_threshold");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeverityCategoryForScore = score => {
  if (score >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.CRITICAL) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL;
  } else if (score >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MAJOR) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR;
  } else if (score >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.MINOR) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.MINOR;
  } else if (score >= _anomaly_threshold.ML_ANOMALY_THRESHOLD.WARNING) {
    return _anomaly_severity.ML_ANOMALY_SEVERITY.WARNING;
  } else {
    // Category is too low to include
    return _anomaly_severity.ML_ANOMALY_SEVERITY.LOW;
  }
};
exports.getSeverityCategoryForScore = getSeverityCategoryForScore;
const formatAnomalyScore = score => {
  return Math.round(score);
};
exports.formatAnomalyScore = formatAnomalyScore;
const formatOneDecimalPlace = number => {
  return Math.round(number * 10) / 10;
};
exports.formatOneDecimalPlace = formatOneDecimalPlace;
const getFriendlyNameForPartitionId = partitionId => {
  return partitionId !== '' ? partitionId : 'unknown';
};
exports.getFriendlyNameForPartitionId = getFriendlyNameForPartitionId;
const compareDatasetsByMaximumAnomalyScore = (firstDataset, secondDataset) => firstDataset.maximumAnomalyScore - secondDataset.maximumAnomalyScore;
exports.compareDatasetsByMaximumAnomalyScore = compareDatasetsByMaximumAnomalyScore;