"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMappingWithContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../../../services");
var _ui_metric = require("../../../../../../../common/constants/ui_metric");
var _http = require("../../../../../services/http");
var _notification = require("../../../../../services/notification");
var _ui_metric2 = require("../../../../../services/ui_metric");
var _ = require("../../../../..");
var _details_page_mappings = require("../details_page_mappings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/with_context_components/index_mapping_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexMappingWithContext = ({
  core,
  dependencies,
  index,
  showAboutMappings,
  hasUpdateMappingsPrivilege
}) => {
  // this normally happens when the index management app is rendered
  // but if components are embedded elsewhere that setup is skipped, so we have to do it here
  // would do it in plugin.ts but that blows up the bundle size
  // can't do it in an effect because then the first http call fails as the instantiation happens after first render
  if (!_http.httpService.httpClient) {
    _http.httpService.setup(core.http);
    _notification.notificationService.setup(core.notifications);
  }
  _services.documentationService.setup(core.docLinks);
  const newDependencies = {
    ...dependencies,
    services: {
      ...(dependencies.services || {}),
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService: new _ui_metric2.UiMetricService(_ui_metric.UIM_APP_NAME)
    }
  };
  return /*#__PURE__*/_react.default.createElement(_.IndexManagementAppContext, {
    core: core,
    dependencies: newDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_details_page_mappings.DetailsPageMappings, {
    index: index,
    showAboutMappings: showAboutMappings,
    hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.IndexMappingWithContext = IndexMappingWithContext;