"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetailPanel = exports.ConditionalWrap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _index_mode_labels = require("../../../../lib/index_mode_labels");
var _discover_link = require("../../../../lib/discover_link");
var _data_streams = require("../../../../lib/data_streams");
var _shared_imports = require("../../../../../shared_imports");
var _components = require("../../../../components");
var _api = require("../../../../services/api");
var _delete_data_stream_confirmation_modal = require("../delete_data_stream_confirmation_modal");
var _edit_data_retention_modal = require("../edit_data_retention_modal");
var _configure_failure_store_modal = require("../configure_failure_store_modal");
var _humanize_time_stamp = require("../humanize_time_stamp");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _data_stream_badges = require("../data_stream_badges");
var _use_ilm_locator = require("../../../../services/use_ilm_locator");
var _streams_promotion = require("./streams_promotion");
var _ = require("../../../../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/data_stream_detail_panel/data_stream_detail_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetailsList = ({
  details
}) => {
  const descriptionListItems = details.map((detail, index) => {
    const {
      name,
      toolTip,
      content,
      dataTestSubj
    } = detail;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `${name}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, toolTip && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: toolTip,
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 27
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, content));
  });
  const midpoint = Math.ceil(descriptionListItems.length / 2);
  const descriptionListColumnOne = descriptionListItems.slice(0, midpoint);
  const descriptionListColumnTwo = descriptionListItems.slice(midpoint, descriptionListItems.length);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, descriptionListColumnOne)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, descriptionListColumnTwo)));
};
const ConditionalWrap = ({
  condition,
  wrap,
  children
}) => condition ? wrap(children) : children;
exports.ConditionalWrap = ConditionalWrap;
const DataStreamDetailPanel = ({
  dataStreamName,
  onClose
}) => {
  var _dataStream$privilege, _dataStream$privilege2, _dataStream$privilege3, _panels$0$items;
  const [isManagePopOverOpen, setManagePopOver] = (0, _react.useState)(false);
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const [isEditingDataRetention, setIsEditingDataRetention] = (0, _react.useState)(false);
  const [isConfiguringFailureStore, setIsConfiguringFailureStore] = (0, _react.useState)(false);
  const {
    error,
    data: dataStream,
    isLoading
  } = (0, _api.useLoadDataStream)(dataStreamName);
  const {
    url
  } = (0, _app_context.useAppContext)();
  const locator = url.locators.get(_.INDEX_MANAGEMENT_LOCATOR_ID);
  const ilmPolicyLink = (0, _use_ilm_locator.useIlmLocator)(_constants.ILM_PAGES_POLICY_EDIT, dataStream === null || dataStream === void 0 ? void 0 : dataStream.ilmPolicyName);
  const {
    config,
    core
  } = (0, _app_context.useAppContext)();
  let indicesLink;
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.loadingDataStreamDescription', {
      defaultMessage: 'Loading data stream'
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.loadingDataStreamErrorMessage', {
        defaultMessage: 'Error loading data stream'
      }),
      error: error,
      "data-test-subj": "sectionError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    });
  } else if (dataStream) {
    const {
      health,
      indices,
      timeStampField,
      generation,
      indexTemplateName,
      ilmPolicyName,
      storageSize,
      maxTimeStamp,
      meteringStorageSize,
      meteringDocsCount,
      lifecycle,
      indexMode,
      hidden
    } = dataStream;
    const getManagementDetails = () => {
      const managementDetails = [];
      if (ilmPolicyName) {
        managementDetails.push({
          name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyTitle', {
            defaultMessage: 'Index lifecycle policy'
          }),
          toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyToolTip', {
            defaultMessage: `The index lifecycle policy that manages the data in the data stream. `
          }),
          content: (0, _data_streams.isDataStreamFullyManagedByDSL)(dataStream) ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "top",
            content: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyToolTipWarning', {
              defaultMessage: `This data stream is not currently being managed by the ILM policy.`
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 193,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": 'ilmPolicyLink',
            "data-href": ilmPolicyLink,
            onClick: () => core.application.navigateToUrl(ilmPolicyLink),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 204,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "subdued",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 209,
              columnNumber: 21
            }
          }, ilmPolicyName)) : ilmPolicyName)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": 'ilmPolicyLink',
            "data-href": ilmPolicyLink,
            onClick: () => core.application.navigateToUrl(ilmPolicyLink),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 219,
              columnNumber: 17
            }
          }, ilmPolicyName) : ilmPolicyName),
          dataTestSubj: 'ilmPolicyDetail'
        });
      }
      return managementDetails;
    };
    indicesLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
        page: 'data_stream_index_list',
        dataStreamName
      })) || '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 7
      }
    }, indices.length);
    const defaultDetails = [{
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.healthTitle', {
        defaultMessage: 'Health'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.healthToolTip', {
        defaultMessage: `The health of the data stream's current backing indices.`
      }),
      content: /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
        health: health,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 18
        }
      }),
      dataTestSubj: 'healthDetail'
    }];

    // add either documents count and size or last updated and size
    if (config.enableSizeAndDocCount) {
      defaultDetails.push({
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.meteringDocsCountTitle', {
          defaultMessage: 'Documents count'
        }),
        toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.meteringDocsCountToolTip', {
          defaultMessage: 'The number of documents in this data stream.'
        }),
        content: meteringDocsCount,
        dataTestSubj: 'docsCountDetail'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeTitle', {
          defaultMessage: 'Storage size'
        }),
        toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeToolTip', {
          defaultMessage: `The total size of all shards in the data stream’s backing indices.`
        }),
        content: meteringStorageSize,
        dataTestSubj: 'meteringStorageSizeDetail'
      });
    }
    if (config.enableDataStreamStats) {
      defaultDetails.push({
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampTitle', {
          defaultMessage: 'Last updated'
        }),
        toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampToolTip', {
          defaultMessage: 'The most recent document to be added to the data stream.'
        }),
        content: maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(maxTimeStamp) : /*#__PURE__*/_react.default.createElement("em", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 301,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampNoneMessage', {
          defaultMessage: `Never`
        })),
        dataTestSubj: 'lastUpdatedDetail'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeTitle', {
          defaultMessage: 'Storage size'
        }),
        toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeToolTip', {
          defaultMessage: `The total size of all shards in the data stream’s backing indices.`
        }),
        content: storageSize,
        dataTestSubj: 'storageSizeDetail'
      });
    }
    defaultDetails.push({
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indicesTitle', {
        defaultMessage: 'Indices'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indicesToolTip', {
        defaultMessage: `The data stream's current backing indices.`
      }),
      content: indicesLink,
      dataTestSubj: 'indicesDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.timestampFieldTitle', {
        defaultMessage: 'Timestamp field'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.timestampFieldToolTip', {
        defaultMessage: 'The timestamp field shared by all documents in the data stream.'
      }),
      content: timeStampField.name,
      dataTestSubj: 'timestampDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.generationTitle', {
        defaultMessage: 'Generation'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.generationToolTip', {
        defaultMessage: 'The number of backing indices generated for the data stream.'
      }),
      content: generation,
      dataTestSubj: 'generationDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexTemplateTitle', {
        defaultMessage: 'Index template'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexTemplateToolTip', {
        defaultMessage: 'The index template that configured the data stream and configures its backing indices.'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": 'indexTemplateLink',
        href: (locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
          page: 'index_template',
          indexTemplate: indexTemplateName
        })) || '',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 362,
          columnNumber: 11
        }
      }, indexTemplateName),
      dataTestSubj: 'indexTemplateDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexModeTitle', {
        defaultMessage: 'Index mode'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexModeToolTip', {
        defaultMessage: "The index mode applied to the data stream's backing indices, as defined in its associated index template."
      }),
      content: _index_mode_labels.indexModeLabels[indexMode],
      dataTestSubj: 'indexModeDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.dataRetentionTitle', {
        defaultMessage: 'Effective data retention'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.dataRetentionToolTip', {
        defaultMessage: `Data is kept at least this long before being automatically deleted. The data retention value only applies to the data managed directly by the data stream. {canEnableDataRetention, plural, one {If some data is subject to an index lifecycle management policy, then the data retention value set for the data stream doesn't apply to that data.} other {}}`,
        values: {
          canEnableDataRetention: config.enableTogglingDataRetention ? 1 : 0
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
        condition: (0, _data_streams.isDataStreamFullyManagedByILM)(dataStream),
        wrap: children => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 400,
            columnNumber: 33
          }
        }, children),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _data_streams.getLifecycleValue)(lifecycle))),
      dataTestSubj: 'dataRetentionDetail'
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.failureStoreTitle', {
        defaultMessage: 'Failure store'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.failureStoreToolTip', {
        defaultMessage: 'The failure store provides a mechanism to store documents that fail to be indexed.'
      }),
      content: dataStream.failureStoreEnabled ? _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.failureStoreEnabledText', {
        defaultMessage: 'Enabled'
      }) : _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.failureStoreDisabledText', {
        defaultMessage: 'Disabled'
      }),
      dataTestSubj: 'failureStoreDetail'
    });

    // If both rentention types are available, we wanna surface to the user both
    if (lifecycle !== null && lifecycle !== void 0 && lifecycle.effective_retention && lifecycle !== null && lifecycle !== void 0 && lifecycle.data_retention) {
      defaultDetails.push({
        name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.customerDefinedDataRetentionTitle', {
          defaultMessage: 'Data retention'
        }),
        toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.customerDefinedDataRetentionTooltip', {
          defaultMessage: "This is the data retention that you defined. Because of other system constraints or settings, the data retention that is effectively applied may be different from the value you set. You can find the value retained and applied by the system under 'Effective data retention'."
        }),
        content: /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
          condition: (0, _data_streams.isDataStreamFullyManagedByILM)(dataStream),
          wrap: children => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "subdued",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 445,
              columnNumber: 33
            }
          }, children),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 443,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _data_streams.getLifecycleValue)((0, _lodash.omit)(lifecycle, ['effective_retention'])))),
        dataTestSubj: 'dataRetentionDetail'
      });
    }
    const managementDetails = getManagementDetails();
    const details = [...defaultDetails, ...managementDetails];
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _data_streams.isDataStreamFullyManagedByILM)(dataStream) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.fullyManagedByILMTitle', {
        defaultMessage: 'This data stream and its associated indices are managed by ILM'
      }),
      iconType: "pin",
      "data-test-subj": "dsIsFullyManagedByILM",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.fullyManagedByILMDescription",
      defaultMessage: "To edit data retention for this data stream, you must edit its associated {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => core.application.navigateToUrl(ilmPolicyLink),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 475,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.fullyManagedByILMButtonLabel",
          defaultMessage: "ILM policy",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 476,
            columnNumber: 25
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 470,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 487,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(DetailsList, {
      details: details,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 9
      }
    }), !hidden && /*#__PURE__*/_react.default.createElement(_streams_promotion.StreamsPromotion, {
      dataStreamName: dataStreamName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 492,
        columnNumber: 21
      }
    }));
  }
  const closePopover = () => {
    setManagePopOver(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "manageDataStreamButton",
    onClick: () => setManagePopOver(!isManagePopOverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 502,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreamsDetailsPanel.manageButtonLabel",
    defaultMessage: "Manage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 7
    }
  }));
  const panels = [{
    id: 0,
    title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.managePanelTitle', {
      defaultMessage: 'Data stream options'
    }),
    items: [...(!(0, _data_streams.isDataStreamFullyManagedByILM)(dataStream) && dataStream !== null && dataStream !== void 0 && (_dataStream$privilege = dataStream.privileges) !== null && _dataStream$privilege !== void 0 && _dataStream$privilege.manage_data_stream_lifecycle ? [{
      key: 'editDataRetention',
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.managePanelEditDataRetention', {
        defaultMessage: 'Edit data retention'
      }),
      'data-test-subj': 'editDataRetentionButton',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "pencil",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 535,
          columnNumber: 23
        }
      }),
      onClick: () => {
        closePopover();
        setIsEditingDataRetention(true);
      }
    }] : []), ...(dataStream !== null && dataStream !== void 0 && (_dataStream$privilege2 = dataStream.privileges) !== null && _dataStream$privilege2 !== void 0 && _dataStream$privilege2.read_failure_store ? [{
      key: 'configureFailureStore',
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.configureFailureStore', {
        defaultMessage: 'Configure failure store'
      }),
      'data-test-subj': 'configureFailureStoreButton',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "gear",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 551,
          columnNumber: 23
        }
      }),
      onClick: () => {
        closePopover();
        setIsConfiguringFailureStore(true);
      }
    }] : []), ...(dataStream !== null && dataStream !== void 0 && (_dataStream$privilege3 = dataStream.privileges) !== null && _dataStream$privilege3 !== void 0 && _dataStream$privilege3.delete_index ? [{
      key: 'deleteDataStream',
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.managePanelDelete', {
        defaultMessage: 'Delete'
      }),
      'data-test-subj': 'deleteDataStreamButton',
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        size: "m",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 567,
          columnNumber: 23
        }
      }),
      onClick: () => {
        closePopover();
        setIsDeleting(true);
      }
    }] : [])]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleting && /*#__PURE__*/_react.default.createElement(_delete_data_stream_confirmation_modal.DeleteDataStreamConfirmationModal, {
    onClose: data => {
      if (data && data.hasDeletedDataStreams) {
        onClose(true);
      } else {
        setIsDeleting(false);
      }
    },
    dataStreams: [dataStreamName],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 9
    }
  }), isEditingDataRetention && dataStream && /*#__PURE__*/_react.default.createElement(_edit_data_retention_modal.EditDataRetentionModal, {
    onClose: data => {
      if (data && data !== null && data !== void 0 && data.hasUpdatedDataRetention) {
        onClose(true);
      } else {
        setIsEditingDataRetention(false);
      }
    },
    ilmPolicyName: dataStream === null || dataStream === void 0 ? void 0 : dataStream.ilmPolicyName,
    ilmPolicyLink: ilmPolicyLink,
    dataStreams: [dataStream],
    isBulkEdit: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 595,
      columnNumber: 9
    }
  }), isConfiguringFailureStore && dataStream && /*#__PURE__*/_react.default.createElement(_configure_failure_store_modal.ConfigureFailureStoreModal, {
    onClose: data => {
      if (data && data !== null && data !== void 0 && data.hasUpdatedFailureStore) {
        onClose(true);
      } else {
        setIsConfiguringFailureStore(false);
      }
    },
    dataStreams: [dataStream],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => onClose(),
    "data-test-subj": "dataStreamDetailPanel",
    "aria-labelledby": "dataStreamDetailPanelTitle",
    size: "m",
    maxWidth: 500,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 623,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 630,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 631,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "dataStreamDetailPanelTitle",
    "data-test-subj": "dataStreamDetailPanelTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 13
    }
  }, dataStreamName, /*#__PURE__*/_react.default.createElement(_discover_link.DiscoverLink, {
    indexName: dataStreamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 15
    }
  }), dataStream && /*#__PURE__*/_react.default.createElement(_data_stream_badges.DataStreamsBadges, {
    dataStream: dataStream,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 635,
      columnNumber: 30
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 640,
      columnNumber: 9
    }
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 643,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: () => onClose(),
    "data-test-subj": "closeDetailsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 645,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.closeButtonLabel', {
    defaultMessage: 'Close'
  }))), !isLoading && !error && !!((_panels$0$items = panels[0].items) !== null && _panels$0$items !== void 0 && _panels$0$items.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isManagePopOverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 666,
      columnNumber: 19
    }
  })))))));
};
exports.DataStreamDetailPanel = DataStreamDetailPanel;