"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibana = exports.renderApp = exports.IndexManagementAppContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactDom = require("react-dom");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
var _app = require("./app");
var _store = require("./store");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  GlobalFlyoutProvider
} = _shared_imports.GlobalFlyout;
const IndexManagementAppContext = ({
  children,
  core,
  dependencies
}) => {
  const {
    docLinks,
    notifications,
    application,
    executionContext,
    overlays,
    analytics,
    i18n,
    theme,
    userProfile
  } = core;
  const startServices = {
    analytics,
    i18n,
    overlays,
    theme,
    userProfile
  };
  const {
    services,
    setBreadcrumbs,
    uiSettings,
    settings,
    kibanaVersion
  } = dependencies;

  // theme is required by the CodeEditor component used to edit runtime field Painless scripts.
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    application,
    uiSettings,
    settings,
    kibanaVersion: {
      get: () => kibanaVersion
    },
    theme,
    userProfile
  });
  const componentTemplateProviderValues = {
    httpClient: services.httpService.httpClient,
    overlays,
    apiBasePath: _common.API_BASE_PATH,
    trackMetric: services.uiMetricService.trackMetric.bind(services.uiMetricService),
    docLinks,
    toasts: notifications.toasts,
    setBreadcrumbs,
    getUrlForApp: application.getUrlForApp,
    executionContext,
    startServices
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: (0, _store.indexManagementStore)(services),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      ...dependencies,
      overlays
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MappingsEditorProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ComponentTemplatesProvider, {
    value: componentTemplateProviderValues,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(GlobalFlyoutProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 19
    }
  }, children))))))));
};
exports.IndexManagementAppContext = IndexManagementAppContext;
const renderApp = (elem, {
  core,
  dependencies
}) => {
  if (!elem) {
    return () => undefined;
  }
  const {
    history
  } = dependencies;
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(IndexManagementAppContext, {
    core: core,
    dependencies: dependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_app.App, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  })), elem);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(elem);
  };
};
exports.renderApp = renderApp;
// We override useKibana() from the react plugin to return a typed version for this app
const useKibana = () => {
  return (0, _shared_imports.useKibana)();
};
exports.useKibana = useKibana;