"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPolicy = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _navigation = require("../../services/navigation");
var _form = require("./form");
var _save_policy = require("./save_policy");
var _components = require("./components");
var _edit_policy_context = require("./edit_policy_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/edit_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const policyNamePath = 'name';
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    // offset the vertical line and the phase icons to align with the phase toggle
    phases: (0, _react2.css)`
      [class*='euiTimelineItemIcon-top'] {
        padding-top: ${euiTheme.size.base};
      }
      [class*='euiTimelineItemIcon-top']::before {
        margin-top: ${euiTheme.size.xl};
      }
    `,
    fullWidth: (0, _react2.css)`
      max-width: 100%;
    `
  };
};
const EditPolicy = () => {
  const styles = useStyles();
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, []);
  const [isShowingPolicyJsonFlyout, setIsShowingPolicyJsonFlyout] = (0, _react.useState)(false);
  const {
    isNewPolicy,
    policy: currentPolicy,
    existingPolicies,
    policyName,
    license
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const {
    services: {
      cloud,
      docLinks,
      history,
      navigateToUrl,
      overlays,
      http
    }
  } = (0, _shared_imports.useKibana)();
  const [isClonedPolicy, setIsClonedPolicy] = (0, _react.useState)(false);
  const [hasSubmittedForm, setHasSubmittedForm] = (0, _react.useState)(false);
  const originalPolicyName = isNewPolicy ? '' : policyName;
  const isAllowedByLicense = license.canUseSearchableSnapshot();
  const isCloudEnabled = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled);
  const serializer = (0, _react.useMemo)(() => {
    return (0, _form.createSerializer)(isNewPolicy ? undefined : currentPolicy);
  }, [isNewPolicy, currentPolicy]);
  const deserializer = (0, _react.useMemo)(() => {
    return (0, _form.createDeserializer)(isCloudEnabled);
  }, [isCloudEnabled]);
  const defaultValue = (0, _react.useMemo)(() => ({
    ...currentPolicy,
    name: originalPolicyName
  }), [currentPolicy, originalPolicyName]);
  const schema = (0, _react.useMemo)(() => {
    return (0, _form.getSchema)(isCloudEnabled);
  }, [isCloudEnabled]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema,
    defaultValue,
    deserializer,
    serializer
  });
  const [formData] = (0, _shared_imports.useFormData)({
    form,
    watch: policyNamePath
  });
  const isFormDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const getPolicyName = () => {
    return isNewPolicy || isClonedPolicy ? (0, _lodash.get)(formData, policyNamePath) : originalPolicyName;
  };
  const policyNameValidations = (0, _react.useMemo)(() => (0, _form.createPolicyNameValidations)({
    originalPolicyName,
    policies: existingPolicies,
    isClonedPolicy
  }), [originalPolicyName, existingPolicies, isClonedPolicy]);
  const backToPolicyList = name => {
    const url = name ? (0, _navigation.getPolicyViewPath)(name) : (0, _navigation.getPoliciesListPath)();
    history.push(url);
  };
  const submit = async () => {
    const {
      data: policy,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const name = getPolicyName();
    setHasSubmittedForm(true);
    const success = await (0, _save_policy.savePolicy)({
      ...policy,
      name
    }, isNewPolicy || isClonedPolicy);
    if (success) {
      backToPolicyList(name);
    }
  };
  const togglePolicyJsonFlyout = () => {
    setIsShowingPolicyJsonFlyout(!isShowingPolicyJsonFlyout);
  };
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    titleText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.unsavedPrompt.title', {
      defaultMessage: 'Exit without saving changes?'
    }),
    messageText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.unsavedPrompt.body', {
      defaultMessage: 'The data will be lost if you leave this page without saving the policy changes.'
    }),
    hasUnsavedChanges: isFormDirty && hasSubmittedForm === false,
    openConfirm: overlays.openConfirm,
    history,
    http,
    navigateToUrl
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "policyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 11
      }
    }, isNewPolicy ? _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.createPolicyMessage', {
      defaultMessage: 'Create policy'
    }) : _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.editPolicyMessage', {
      defaultMessage: 'Edit policy {originalPolicyName}',
      values: {
        originalPolicyName
      }
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: docLinks.links.elasticsearch.ilm,
      target: "_blank",
      iconType: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.documentationLinkText",
      defaultMessage: "Documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 13
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, isNewPolicy ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_components.EditWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "saveAsNewSwitch",
    css: styles.fullWidth,
    checked: isClonedPolicy,
    onChange: e => {
      setIsClonedPolicy(e.target.checked);
    },
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewPolicyMessage",
      defaultMessage: "Save as new policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }))), isClonedPolicy || isNewPolicy ? /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: policyNamePath,
    config: {
      label: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameLabel', {
        defaultMessage: 'Policy name'
      }),
      helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.validPolicyNameMessage', {
        defaultMessage: 'A policy name cannot start with an underscore and cannot contain a comma or a space.'
      }),
      validations: policyNameValidations
    },
    component: _shared_imports.TextField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': 'policyNameField'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_components.Timeline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTimeline, {
    css: styles.phases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.HotPhase, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.WarmPhase, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.ColdPhase, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 11
    }
  }), isAllowedByLicense && /*#__PURE__*/_react.default.createElement(_components.FrozenPhase, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 34
    }
  }), /*#__PURE__*/_react.default.createElement(_components.DeletePhase, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_components.FormErrorsCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "savePolicyButton",
    fill: true,
    iconType: "check",
    iconSide: "left",
    disabled: form.isValid === false || form.isSubmitting,
    onClick: submit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 17
    }
  }, isClonedPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewButton",
    defaultMessage: "Save as new policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveButton",
    defaultMessage: "Save policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelTestPolicy",
    onClick: () => backToPolicyList(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: togglePolicyJsonFlyout,
    "data-test-subj": "requestButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 13
    }
  }, isShowingPolicyJsonFlyout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.hidePolicyJsonButton",
    defaultMessage: "Hide request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.showPolicyJsonButton",
    defaultMessage: "Show request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 17
    }
  })))), isShowingPolicyJsonFlyout ? /*#__PURE__*/_react.default.createElement(_components.PolicyJsonFlyout, {
    policyName: getPolicyName(),
    close: () => setIsShowingPolicyJsonFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  }) : null));
};
exports.EditPolicy = EditPolicy;