"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRolloverValueRequiredValidation = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _shared_imports = require("../../../../../../shared_imports");
var _constants = require("../../../constants");
var _form = require("../../../form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rolloverFieldPaths = Object.values(_constants.ROLLOVER_FORM_PATHS);
const useRolloverValueRequiredValidation = () => {
  const [isValid, setIsValid] = (0, _react.useState)(false);
  const [formData] = (0, _shared_imports.useFormData)({
    watch: rolloverFieldPaths
  });
  const {
    getFields
  } = (0, _shared_imports.useFormContext)();
  (0, _react.useEffect)(() => {
    var _get$errors, _get;
    // We check just the ROLLOVER_FORM_PATHS.maxPrimaryShardSize field because if
    // it has the ROLLOVER_VALUE_REQUIRED_VALIDATION_CODE error, all the other rollover
    // fields should too.
    const rolloverFieldErrors = (_get$errors = (_get = (0, _lodash.get)(getFields(), _constants.ROLLOVER_FORM_PATHS.maxPrimaryShardSize)) === null || _get === void 0 ? void 0 : _get.errors) !== null && _get$errors !== void 0 ? _get$errors : [];
    setIsValid(rolloverFieldErrors.some(validation => validation.code === _form.ROLLOVER_VALUE_REQUIRED_VALIDATION_CODE));
  }, [getFields, formData]);
  return isValid;
};
exports.useRolloverValueRequiredValidation = useRolloverValueRequiredValidation;