"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidancePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _state_management = require("../../state_management");
var _source_modal = require("../../services/source_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/guidance_panel/guidance_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ListItem({
  children,
  state
}) {
  const isDisabled = state === 'disabled';
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/role-supports-aria-props
    _react.default.createElement("li", {
      css: [styles.listItem, isDisabled && styles.disabledListItem],
      "aria-disabled": isDisabled,
      "aria-current": state === 'active' ? 'step' : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 5
      }
    }, !isDisabled && /*#__PURE__*/_react.default.createElement("span", {
      css: [styles.itemIcon, state === 'done' && styles.doneIcon],
      "aria-hidden": true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: state === 'active' ? 'sortRight' : 'check',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }, children))
  );
}
function GuidancePanelComponent(props) {
  const {
    onFillWorkspace,
    onOpenFieldPicker,
    onIndexPatternSelected,
    hasDatasource,
    hasFields
  } = props;
  const kibana = (0, _public.useKibana)();
  const {
    services,
    overlays
  } = kibana;
  const {
    application,
    data,
    contentManagement,
    uiSettings
  } = services;
  const [hasDataViews, setHasDataViews] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const checkIfDataViewsExist = async () => {
      setHasDataViews(await data.dataViews.hasData.hasUserDataView());
    };
    checkIfDataViewsExist();
  }, [setHasDataViews, data.dataViews]);
  if (!overlays || !application) return null;
  const onOpenDatasourcePicker = () => {
    (0, _source_modal.openSourceModal)({
      overlays,
      contentManagement,
      uiSettings
    }, onIndexPatternSelected);
  };
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "graphGuidancePanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "graphApp",
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "graphHeading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.title', {
    defaultMessage: 'Three steps to your graph'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: styles.list,
    "aria-labelledby": "graphHeading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasDatasource ? 'done' : 'active',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenDatasourcePicker,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.datasourceItem.indexPatternButtonLabel', {
    defaultMessage: 'Select a data source.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'done' : hasDatasource ? 'active' : 'disabled',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenFieldPicker,
    disabled: !hasFields && !hasDatasource,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.fieldsItem.fieldsButtonLabel', {
    defaultMessage: 'Add fields.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'active' : 'disabled',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.guidancePanel.nodesItem.description",
    defaultMessage: "Enter a query in the search bar to start exploring. Don't know where to start? {topTerms}.",
    values: {
      topTerms: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onFillWorkspace,
        disabled: !hasFields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.graph.guidancePanel.nodesItem.topTermsButtonLabel', {
        defaultMessage: 'Graph the top terms'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }))))));
  if (!hasDataViews) {
    const dataViewManagementUrl = application.getUrlForApp('management', {
      path: '/kibana/dataViews'
    });
    const sampleDataUrl = `${application.getUrlForApp('home')}#/tutorial_directory/sampleData`;
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "question",
      title: _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
        defaultMessage: 'No data source'
      }),
      heading: "h1",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      id: "graphHeading",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
      defaultMessage: 'No data source'
    }))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.noDataSourceNotificationMessageText",
      defaultMessage: "No data sources found. Go to {managementIndexPatternsLink} and create a data view for your Elasticsearch indices.",
      values: {
        managementIndexPatternsLink: /*#__PURE__*/_react.default.createElement("a", {
          href: dataViewManagementUrl,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.noDataSourceNotificationMessageText.managementDataViewLinkText",
          defaultMessage: "Management > Data views",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 21
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.noDataSource.newToKibanaDescription",
      defaultMessage: "New to Kibana? You can also use our {sampleDataInstallLink}.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: sampleDataUrl,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 195,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.listing.noDataSource.sampleDataInstallLinkText",
          defaultMessage: "sample data",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 21
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.guidancePanel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, content));
}
const GuidancePanel = exports.GuidancePanel = (0, _reactRedux.connect)(state => {
  return {
    hasDatasource: (0, _state_management.hasDatasourceSelector)(state),
    hasFields: (0, _state_management.hasFieldsSelector)(state)
  };
}, dispatch => ({
  onIndexPatternSelected: indexPattern => {
    dispatch((0, _state_management.requestDatasource)({
      type: 'indexpattern',
      id: indexPattern.id,
      title: indexPattern.attributes.title
    }));
  },
  onFillWorkspace: () => {
    dispatch((0, _state_management.fillWorkspace)());
  }
}))(GuidancePanelComponent);
const styles = {
  guidancePanel: ({
    euiTheme
  }) => (0, _react2.css)({
    maxWidth: '580px',
    margin: `${euiTheme.size.l} 0`
  }),
  list: (0, _react2.css)({
    listStyle: 'none',
    margin: '0',
    padding: '0'
  }),
  listItem: ({
    euiTheme
  }) => (0, _react2.css)({
    display: 'block',
    maxWidth: '420px',
    position: 'relative',
    paddingLeft: euiTheme.size.xl,
    marginBottom: euiTheme.size.l
  }),
  disabledListItem: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.darkShade,
    button: {
      color: `${euiTheme.colors.darkShade} !important`
    }
  }),
  itemIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'absolute',
    left: '0',
    top: `calc(-${euiTheme.size.xs} / 2)`,
    width: euiTheme.size.l,
    height: euiTheme.size.l,
    padding: euiTheme.size.xs
  }),
  doneIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.success,
    color: euiTheme.colors.emptyShade,
    borderRadius: '50%'
  })
};