"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDownIconLinks = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _icon_renderer = require("../icon_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/control_panel/drill_down_icon_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DrillDownIconLinks = ({
  hasNodes,
  urlTemplates,
  openUrlTemplate
}) => {
  const drillDownsWithIcons = urlTemplates.filter(({
    icon
  }) => icon && icon.id !== '');
  if (drillDownsWithIcons.length === 0) {
    return null;
  }
  const drillDowns = drillDownsWithIcons.map(cur => {
    const onUrlTemplateClick = () => openUrlTemplate(cur);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: cur.description,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: cur.icon ? () => /*#__PURE__*/_react.default.createElement(_icon_renderer.IconRenderer, {
        icon: cur.icon,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 40
        }
      }) : '',
      size: "xs",
      isDisabled: hasNodes,
      onClick: onUrlTemplateClick,
      "aria-label": cur.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    })));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      marginTop: `calc(0.5 * ${euiTheme.size.xs})`,
      marginBottom: `calc(0.5 * ${euiTheme.size.xs})`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, drillDowns);
};
exports.DrillDownIconLinks = DrillDownIconLinks;