"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTagList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/global_search_bar/public/components/result_tag_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_TAGS_TO_SHOW = 3;
const TagListWrapper = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react2.css)({
    display: 'inline-block',
    // Horizontally aligns the tag list to the 'Go to' badge when row is focused
    [(0, _eui.useEuiMaxBreakpoint)('m')]: {
      display: 'none'
    },
    '.kbnSearchOption__tagsListItem': {
      display: 'inline-block',
      maxWidth: (0, _eui.mathWithUnits)(euiTheme.size.xxl, x => x * 2),
      marginRight: euiTheme.size.s
    }
  });
  return /*#__PURE__*/_react.default.createElement("ul", {
    css: styles,
    "aria-label": _i18n.i18n.translate('xpack.globalSearchBar.searchBar.optionTagListAriaLabel', {
      defaultMessage: 'Tags'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, children);
};
const buildListItem = ({
  color,
  name,
  id
}) => {
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "kbnSearchOption__tagsListItem",
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, name));
};
const ResultTagList = ({
  tags,
  searchTagIds
}) => {
  const showOverflow = tags.length > MAX_TAGS_TO_SHOW;
  if (!showOverflow) {
    return /*#__PURE__*/_react.default.createElement(TagListWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 12
      }
    }, tags.map(buildListItem));
  }

  // float searched tags to the start of the list, actual order doesn't matter
  tags.sort(a => {
    if (searchTagIds.find(id => id === a.id)) return -1;
    return 1;
  });
  const overflowList = tags.splice(MAX_TAGS_TO_SHOW);
  const overflowMessage = _i18n.i18n.translate('xpack.globalSearchBar.searchbar.overflowTagsAriaLabel', {
    defaultMessage: '{n} more {n, plural, one {tag} other {tags}}: {tags}',
    values: {
      n: overflowList.length,
      // @ts-ignore-line
      tags: overflowList.map(({
        name
      }) => name)
    }
  });
  return /*#__PURE__*/_react.default.createElement(TagListWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, tags.map(buildListItem), /*#__PURE__*/_react.default.createElement("li", {
    className: "kbnSearchOption__tagsListItem",
    "aria-label": overflowMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: overflowMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, "+", overflowList.length)));
};
exports.ResultTagList = ResultTagList;