"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFindRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerFindRoute = router => {
  router.get({
    path: `${_utils.KBN_CLIENT_API_PREFIX}/_find`,
    security: {
      authz: {
        requiredPrivileges: ['ftrApis']
      }
    },
    validate: {
      query: _configSchema.schema.object({
        per_page: _configSchema.schema.number({
          min: 0,
          defaultValue: 20
        }),
        page: _configSchema.schema.number({
          min: 0,
          defaultValue: 1
        }),
        type: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        fields: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]))
      })
    }
  }, (0, _utils.catchAndReturnBoomErrors)(async (ctx, req, res) => {
    const query = req.query;
    const {
      savedObjects
    } = await ctx.core;
    const hiddenTypes = (0, _utils.listHiddenTypes)(savedObjects.typeRegistry);
    const soClient = savedObjects.getClient({
      includedHiddenTypes: hiddenTypes
    });
    const result = await soClient.find({
      perPage: query.per_page,
      page: query.page,
      type: Array.isArray(query.type) ? query.type : [query.type],
      search: query.search,
      fields: typeof query.fields === 'string' ? [query.fields] : query.fields
    });
    return res.ok({
      body: result
    });
  }));
};
exports.registerFindRoute = registerFindRoute;