"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckPermissionsResponseSchema = exports.CheckPermissionsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CheckPermissionsRequestSchema = exports.CheckPermissionsRequestSchema = {
  query: _configSchema.schema.object({
    fleetServerSetup: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const CheckPermissionsResponseSchema = exports.CheckPermissionsResponseSchema = _configSchema.schema.object({
  success: _configSchema.schema.boolean(),
  error: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('MISSING_SECURITY'), _configSchema.schema.literal('MISSING_PRIVILEGES'), _configSchema.schema.literal('MISSING_FLEET_SERVER_SETUP_PRIVILEGES')]))
});