"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentSOAttributesToFleetServerAgentDoc = agentSOAttributesToFleetServerAgentDoc;
exports.searchHitToAgent = searchHitToAgent;
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function searchHitToAgent(hit) {
  var _hit$_source, _hit$_source2, _hit$_source3, _hit$_source4, _hit$_source5, _hit$_source6, _hit$_source7, _hit$_source8, _hit$_source9, _hit$_source10, _hit$_source11, _hit$_source12, _hit$_source13, _hit$_source14, _hit$_source15, _hit$_source16, _hit$_source17, _hit$_source18, _hit$_source19, _hit$_source20, _hit$_source20$last_c, _hit$_source21, _hit$_source22, _hit$_source$packages, _hit$_source23, _hit$_source24, _hit$_source25, _hit$_source26, _hit$_source27, _hit$_source28, _hit$_source29, _hit$_source30, _hit$_source31, _hit$_source32, _hit$_source33, _hit$fields, _hit$fields$status;
  const outputs = (_hit$_source = hit._source) !== null && _hit$_source !== void 0 && _hit$_source.outputs ? Object.entries((_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : _hit$_source2.outputs).reduce((acc, [key, val]) => {
    acc[key] = {
      api_key_id: val.api_key_id,
      type: val.type,
      to_retire_api_key_ids: val.to_retire_api_key_ids ? val.to_retire_api_key_ids.map(item => ({
        id: item.id,
        retired_at: item.retired_at
      })) : undefined
    };
    return acc;
  }, {}) : undefined;
  const components = Array.isArray((_hit$_source3 = hit._source) === null || _hit$_source3 === void 0 ? void 0 : _hit$_source3.components) ? (_hit$_source4 = hit._source) === null || _hit$_source4 === void 0 ? void 0 : _hit$_source4.components.map(component => {
    var _component$units;
    return {
      id: component.id,
      type: component.type,
      status: component.status,
      message: component.message,
      units: (_component$units = component.units) === null || _component$units === void 0 ? void 0 : _component$units.map(unit => ({
        id: unit.id,
        type: unit.type,
        status: unit.status,
        message: unit.message,
        // key-value pairs
        payload: unit.payload
      }))
    };
  }) : undefined;
  const agent = {
    id: hit._id,
    type: (_hit$_source5 = hit._source) === null || _hit$_source5 === void 0 ? void 0 : _hit$_source5.type,
    namespaces: (_hit$_source6 = hit._source) === null || _hit$_source6 === void 0 ? void 0 : _hit$_source6.namespaces,
    active: (_hit$_source7 = hit._source) === null || _hit$_source7 === void 0 ? void 0 : _hit$_source7.active,
    enrolled_at: (_hit$_source8 = hit._source) === null || _hit$_source8 === void 0 ? void 0 : _hit$_source8.enrolled_at,
    unenrolled_at: (_hit$_source9 = hit._source) === null || _hit$_source9 === void 0 ? void 0 : _hit$_source9.unenrolled_at,
    unenrollment_started_at: (_hit$_source10 = hit._source) === null || _hit$_source10 === void 0 ? void 0 : _hit$_source10.unenrollment_started_at,
    audit_unenrolled_reason: (_hit$_source11 = hit._source) === null || _hit$_source11 === void 0 ? void 0 : _hit$_source11.audit_unenrolled_reason,
    upgraded_at: (_hit$_source12 = hit._source) === null || _hit$_source12 === void 0 ? void 0 : _hit$_source12.upgraded_at,
    upgrade_started_at: (_hit$_source13 = hit._source) === null || _hit$_source13 === void 0 ? void 0 : _hit$_source13.upgrade_started_at,
    upgrade_details: (_hit$_source14 = hit._source) === null || _hit$_source14 === void 0 ? void 0 : _hit$_source14.upgrade_details,
    upgrade_attempts: (_hit$_source15 = hit._source) === null || _hit$_source15 === void 0 ? void 0 : _hit$_source15.upgrade_attempts,
    access_api_key_id: (_hit$_source16 = hit._source) === null || _hit$_source16 === void 0 ? void 0 : _hit$_source16.access_api_key_id,
    default_api_key_id: (_hit$_source17 = hit._source) === null || _hit$_source17 === void 0 ? void 0 : _hit$_source17.default_api_key_id,
    policy_id: (_hit$_source18 = hit._source) === null || _hit$_source18 === void 0 ? void 0 : _hit$_source18.policy_id,
    last_checkin: (_hit$_source19 = hit._source) === null || _hit$_source19 === void 0 ? void 0 : _hit$_source19.last_checkin,
    last_checkin_status: (_hit$_source20 = hit._source) === null || _hit$_source20 === void 0 ? void 0 : (_hit$_source20$last_c = _hit$_source20.last_checkin_status) === null || _hit$_source20$last_c === void 0 ? void 0 : _hit$_source20$last_c.toLowerCase(),
    last_checkin_message: (_hit$_source21 = hit._source) === null || _hit$_source21 === void 0 ? void 0 : _hit$_source21.last_checkin_message,
    policy_revision: (_hit$_source22 = hit._source) === null || _hit$_source22 === void 0 ? void 0 : _hit$_source22.policy_revision_idx,
    packages: (_hit$_source$packages = (_hit$_source23 = hit._source) === null || _hit$_source23 === void 0 ? void 0 : _hit$_source23.packages) !== null && _hit$_source$packages !== void 0 ? _hit$_source$packages : [],
    sort: hit.sort,
    tags: (_hit$_source24 = hit._source) === null || _hit$_source24 === void 0 ? void 0 : _hit$_source24.tags,
    outputs,
    components,
    default_api_key_history: (_hit$_source25 = hit._source) !== null && _hit$_source25 !== void 0 && _hit$_source25.default_api_key_history ? (_hit$_source26 = hit._source) === null || _hit$_source26 === void 0 ? void 0 : _hit$_source26.default_api_key_history.map(item => ({
      id: item.id,
      retired_at: item.retired_at
    })) : undefined,
    agent: (_hit$_source27 = hit._source) !== null && _hit$_source27 !== void 0 && _hit$_source27.agent ? {
      id: (_hit$_source28 = hit._source) === null || _hit$_source28 === void 0 ? void 0 : _hit$_source28.agent.id,
      version: (_hit$_source29 = hit._source) === null || _hit$_source29 === void 0 ? void 0 : _hit$_source29.agent.version
    } : undefined,
    // key-value pairs
    user_provided_metadata: (_hit$_source30 = hit._source) === null || _hit$_source30 === void 0 ? void 0 : _hit$_source30.user_provided_metadata,
    local_metadata: (_hit$_source31 = hit._source) === null || _hit$_source31 === void 0 ? void 0 : _hit$_source31.local_metadata,
    unhealthy_reason: (_hit$_source32 = hit._source) === null || _hit$_source32 === void 0 ? void 0 : _hit$_source32.unhealthy_reason,
    last_known_status: (_hit$_source33 = hit._source) === null || _hit$_source33 === void 0 ? void 0 : _hit$_source33.last_known_status
  };
  if (!((_hit$fields = hit.fields) !== null && _hit$fields !== void 0 && (_hit$fields$status = _hit$fields.status) !== null && _hit$fields$status !== void 0 && _hit$fields$status.length)) {
    _.appContextService.getLogger().error('Agent status runtime field is missing, unable to get agent status for agent ' + agent.id);
  } else {
    agent.status = hit.fields.status[0];
  }
  return agent;
}
function agentSOAttributesToFleetServerAgentDoc(data) {
  const {
    policy_revision: policyRevison,
    ...rest
  } = data;
  const doc = {
    ...rest
  };
  if (policyRevison !== undefined) {
    doc.policy_revision_idx = policyRevison;
  }
  if (!doc.updated_at) {
    doc.updated_at = new Date().toISOString();
  }
  return doc;
}