"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkedAgentCount = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764849815072412198/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/linked_agent_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays the provided `count` number as a link to the Agents list if it is greater than zero
 */
const LinkedAgentCount = exports.LinkedAgentCount = /*#__PURE__*/(0, _react.memo)(({
  count,
  agentPolicyId,
  showAgentText,
  privilegeMode,
  ...otherEuiLinkProps
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const displayValue = showAgentText ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.linkedAgentCountText",
    defaultMessage: "{count, plural, one {# agent} other {# agents}}",
    values: {
      count
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }) : count;
  const kuery = `${_constants.AGENTS_PREFIX}.policy_id : ${agentPolicyId}${privilegeMode ? ` and ${privilegeMode === 'unprivileged' ? _constants.UNPRIVILEGED_AGENT_KUERY : _constants.PRIVILEGED_AGENT_KUERY}` : ''}`;
  return count > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, otherEuiLinkProps, {
    href: getHref('agent_list', {
      kuery,
      showInactive: true
    }),
    "data-test-subj": "LinkedAgentCountLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }), displayValue) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": otherEuiLinkProps['data-test-subj'],
    className: otherEuiLinkProps.className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, displayValue);
});